/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.filterchain;

import java.util.EnumSet;
import org.glassfish.grizzly.Closeable;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Context;
import org.glassfish.grizzly.IOEvent;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChain;
import org.glassfish.grizzly.filterchain.FilterChainContext;

public abstract class AbstractFilterChain
implements FilterChain {
    protected final EnumSet<IOEvent> interestedIoEventsMask = EnumSet.allOf(IOEvent.class);

    @Override
    public int indexOfType(Class<? extends Filter> filterType) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            Filter filter = (Filter)this.get(i);
            if (!filterType.isAssignableFrom(filter.getClass())) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean isInterested(IOEvent ioEvent) {
        return this.interestedIoEventsMask.contains((Object)ioEvent);
    }

    @Override
    public void setInterested(IOEvent ioEvent, boolean isInterested) {
        if (isInterested) {
            this.interestedIoEventsMask.add(ioEvent);
        } else {
            this.interestedIoEventsMask.remove((Object)ioEvent);
        }
    }

    @Override
    public final FilterChainContext obtainFilterChainContext(Connection connection) {
        FilterChainContext context = FilterChainContext.create(connection);
        context.internalContext.setProcessor(this);
        return context;
    }

    @Override
    public FilterChainContext obtainFilterChainContext(Connection connection, Closeable closeable) {
        FilterChainContext context = FilterChainContext.create(connection, closeable);
        context.internalContext.setProcessor(this);
        return context;
    }

    @Override
    public FilterChainContext obtainFilterChainContext(Connection connection, int startIdx, int endIdx, int currentIdx) {
        FilterChainContext ctx = this.obtainFilterChainContext(connection);
        ctx.setStartIdx(startIdx);
        ctx.setEndIdx(endIdx);
        ctx.setFilterIdx(currentIdx);
        return ctx;
    }

    @Override
    public FilterChainContext obtainFilterChainContext(Connection connection, Closeable closeable, int startIdx, int endIdx, int currentIdx) {
        FilterChainContext ctx = this.obtainFilterChainContext(connection, closeable);
        ctx.setStartIdx(startIdx);
        ctx.setEndIdx(endIdx);
        ctx.setFilterIdx(currentIdx);
        return ctx;
    }

    @Override
    public final Context obtainContext(Connection connection) {
        return this.obtainFilterChainContext((Connection)connection).internalContext;
    }

    protected void finalize() throws Throwable {
        this.clear();
        super.finalize();
    }
}

