/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly;

import org.glassfish.grizzly.Cacheable;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.Result;
import org.glassfish.grizzly.ThreadCache;
import org.glassfish.grizzly.utils.Holder;

public final class WriteResult<K, L>
implements Result,
Cacheable {
    private static final ThreadCache.CachedTypeIndex<WriteResult> CACHE_IDX = ThreadCache.obtainIndex(WriteResult.class, 4);
    private boolean isRecycled = false;
    private Connection connection;
    private K message;
    private Holder<L> dstAddressHolder;
    private long writtenSize;

    public static <K, L> WriteResult<K, L> create(Connection connection) {
        WriteResult<K, L> writeResult = WriteResult.takeFromCache();
        if (writeResult != null) {
            writeResult.connection = connection;
            writeResult.isRecycled = false;
            return writeResult;
        }
        return new WriteResult<K, L>(connection);
    }

    public static <K, L> WriteResult<K, L> create(Connection connection, K message, L dstAddress, int writeSize) {
        WriteResult<K, L> writeResult = WriteResult.takeFromCache();
        if (writeResult != null) {
            writeResult.connection = connection;
            writeResult.message = message;
            writeResult.dstAddressHolder = Holder.staticHolder(dstAddress);
            writeResult.writtenSize = writeSize;
            writeResult.isRecycled = false;
            return writeResult;
        }
        return new WriteResult<K, L>(connection, message, dstAddress, writeSize);
    }

    private static <K, L> WriteResult<K, L> takeFromCache() {
        return ThreadCache.takeFromCache(CACHE_IDX);
    }

    private WriteResult(Connection connection) {
        this(connection, null, null, 0L);
    }

    private WriteResult(Connection connection, K message, L dstAddress, long writeSize) {
        this.connection = connection;
        this.message = message;
        this.dstAddressHolder = Holder.staticHolder(dstAddress);
        this.writtenSize = writeSize;
    }

    @Override
    public final Connection getConnection() {
        this.checkRecycled();
        return this.connection;
    }

    public final K getMessage() {
        this.checkRecycled();
        return this.message;
    }

    public final void setMessage(K message) {
        this.checkRecycled();
        this.message = message;
    }

    public final L getDstAddress() {
        this.checkRecycled();
        return this.dstAddressHolder != null ? (L)this.dstAddressHolder.get() : null;
    }

    public final Holder<L> getDstAddressHolder() {
        this.checkRecycled();
        return this.dstAddressHolder;
    }

    public final void setDstAddress(L dstAddress) {
        this.checkRecycled();
        this.dstAddressHolder = Holder.staticHolder(dstAddress);
    }

    public final void setDstAddressHolder(Holder<L> dstAddressHolder) {
        this.checkRecycled();
        this.dstAddressHolder = dstAddressHolder;
    }

    public final long getWrittenSize() {
        this.checkRecycled();
        return this.writtenSize;
    }

    public final void setWrittenSize(long writeSize) {
        this.checkRecycled();
        this.writtenSize = writeSize;
    }

    private void checkRecycled() {
        if (Grizzly.isTrackingThreadCache() && this.isRecycled) {
            throw new IllegalStateException("ReadResult has been recycled!");
        }
    }

    private void reset() {
        this.connection = null;
        this.message = null;
        this.dstAddressHolder = null;
        this.writtenSize = 0L;
    }

    @Override
    public void recycle() {
        this.reset();
        this.isRecycled = true;
        ThreadCache.putToCache(CACHE_IDX, this);
    }
}

