/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.multipart;

import java.io.IOException;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.ReadHandler;
import org.glassfish.grizzly.http.io.NIOInputStream;
import org.glassfish.grizzly.http.multipart.MultipartEntry;

final class MultipartEntryNIOInputStream
extends NIOInputStream {
    private boolean isClosed;
    private final MultipartEntry multipartEntry;
    private NIOInputStream parentNIOInputStream;
    private int requestedSize;
    private ReadHandler handler;

    public MultipartEntryNIOInputStream(MultipartEntry multipartEntry) {
        this.multipartEntry = multipartEntry;
    }

    protected void initialize(NIOInputStream parentNIOInputStream) {
        this.parentNIOInputStream = parentNIOInputStream;
    }

    public int read() throws IOException {
        if (this.isClosed) {
            throw new IOException();
        }
        if (this.readyData() == 0) {
            throw new IllegalStateException("Can't be invoked when available() == 0");
        }
        this.multipartEntry.addAvailableBytes(-1);
        return this.parentNIOInputStream.read();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.isClosed) {
            throw new IOException();
        }
        if (len == 0) {
            return 0;
        }
        int nlen = Math.min(this.multipartEntry.availableBytes(), len);
        this.multipartEntry.addAvailableBytes(-nlen);
        return this.parentNIOInputStream.read(b, off, nlen);
    }

    public long skip(long n) throws IOException {
        if (this.isClosed) {
            throw new IOException();
        }
        if ((long)this.readyData() < n) {
            throw new IllegalStateException("Can not skip more bytes than available");
        }
        this.multipartEntry.addAvailableBytes((int)(-n));
        return this.parentNIOInputStream.skip(n);
    }

    public int available() throws IOException {
        return this.readyData();
    }

    public void close() throws IOException {
        this.isClosed = true;
    }

    public void mark(int readlimit) {
        this.parentNIOInputStream.mark(readlimit);
    }

    public void reset() throws IOException {
        this.parentNIOInputStream.reset();
    }

    public boolean markSupported() {
        return this.parentNIOInputStream.markSupported();
    }

    public void notifyAvailable(ReadHandler handler) {
        this.notifyAvailable(handler, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyAvailable(ReadHandler handler, int size) {
        if (this.isClosed || this.isFinished()) {
            try {
                handler.onAllDataRead();
            }
            catch (Exception ioe) {
                try {
                    handler.onError((Throwable)ioe);
                }
                finally {
                    try {
                        this.parentNIOInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return;
        }
        if (MultipartEntryNIOInputStream.shouldNotifyNow(size, this.multipartEntry.availableBytes())) {
            try {
                handler.onDataAvailable();
            }
            catch (Exception ioe) {
                try {
                    handler.onError((Throwable)ioe);
                }
                finally {
                    try {
                        this.parentNIOInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return;
        }
        this.requestedSize = size;
        this.handler = handler;
    }

    public boolean isFinished() {
        return this.multipartEntry.isFinished();
    }

    public int readyData() {
        return this.isClosed ? 0 : this.multipartEntry.availableBytes();
    }

    public boolean isReady() {
        return this.readyData() > 0;
    }

    public Buffer getBuffer() {
        int remaining = this.readyData();
        Buffer underlyingBuffer = this.parentNIOInputStream.getBuffer();
        underlyingBuffer.limit(underlyingBuffer.position() + remaining);
        return underlyingBuffer;
    }

    public Buffer readBuffer() {
        return this.readBuffer(this.readyData());
    }

    public Buffer readBuffer(int size) {
        if (size > this.readyData()) {
            throw new IllegalStateException("Can not read more bytes than available");
        }
        this.multipartEntry.addAvailableBytes(-size);
        return this.parentNIOInputStream.readBuffer(size);
    }

    protected void recycle() {
        this.parentNIOInputStream = null;
        this.handler = null;
        this.isClosed = false;
        this.requestedSize = 0;
    }

    void onDataCame() throws Exception {
        if (this.handler == null) {
            return;
        }
        try {
            if (this.isFinished()) {
                this.handler.onAllDataRead();
            } else if (MultipartEntryNIOInputStream.shouldNotifyNow(this.requestedSize, this.multipartEntry.availableBytes())) {
                this.handler.onDataAvailable();
            }
        }
        catch (Exception e) {
            try {
                this.handler.onError((Throwable)e);
            }
            finally {
                try {
                    this.parentNIOInputStream.close();
                }
                catch (IOException iOException) {}
            }
            throw e;
        }
    }

    private static boolean shouldNotifyNow(int size, int available) {
        return available != 0 && available >= size;
    }
}

