/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.server;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.ThreadCache;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.http.Cookie;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.server.HttpServerProbeNotifier;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Session;
import org.glassfish.grizzly.http.server.SuspendStatus;
import org.glassfish.grizzly.http.server.io.NIOOutputStream;
import org.glassfish.grizzly.http.server.io.NIOWriter;
import org.glassfish.grizzly.http.server.io.OutputBuffer;
import org.glassfish.grizzly.http.util.CharChunk;
import org.glassfish.grizzly.http.util.CookieSerializerUtils;
import org.glassfish.grizzly.http.util.FastHttpDateFormat;
import org.glassfish.grizzly.http.util.HttpRequestURIDecoder;
import org.glassfish.grizzly.http.util.HttpStatus;
import org.glassfish.grizzly.http.util.MessageBytes;
import org.glassfish.grizzly.http.util.MimeHeaders;
import org.glassfish.grizzly.http.util.StringManager;
import org.glassfish.grizzly.http.util.UEncoder;
import org.glassfish.grizzly.utils.DelayedExecutor;

public class Response {
    private static final Logger LOGGER = Grizzly.logger(Response.class);
    private static final ThreadCache.CachedTypeIndex<Response> CACHE_IDX = ThreadCache.obtainIndex(Response.class, (int)2);
    private boolean cacheEnabled = false;
    private String detailErrorMsg;
    private static final String HTTP_RESPONSE_DATE_HEADER = "EEE, dd MMM yyyy HH:mm:ss zzz";
    protected SimpleDateFormat format = null;
    protected static final String info = "org.glassfish.grizzly.http.server.Response/2.0";
    protected static final StringManager sm = StringManager.getManager((String)"org.glassfish.grizzly.http.server.res");
    protected Request request = null;
    protected HttpResponsePacket response;
    protected FilterChainContext ctx;
    protected OutputBuffer outputBuffer;
    protected NIOOutputStream outputStream;
    protected NIOWriter writer;
    protected boolean appCommitted = false;
    protected boolean error = false;
    protected final List<Cookie> cookies = new ArrayList<Cookie>(4);
    protected boolean usingOutputStream = false;
    protected boolean usingWriter = false;
    protected UEncoder urlEncoder = new UEncoder();
    protected MessageBytes redirectURLCC = MessageBytes.newInstance();
    protected DelayedExecutor.DelayQueue<Response> delayQueue;
    protected boolean isSuspended;
    private final SuspendedRunnable suspendedRunnable = new SuspendedRunnable();
    private final Object suspendSync = new Object();
    private SuspendStatus suspendStatus;

    public static Response create() {
        Response response = (Response)ThreadCache.takeFromCache(CACHE_IDX);
        if (response != null) {
            return response;
        }
        return new Response();
    }

    static DelayedExecutor.DelayQueue<Response> createDelayQueue(DelayedExecutor delayedExecutor) {
        return delayedExecutor.createDelayQueue((DelayedExecutor.Worker)new DelayQueueWorker(), (DelayedExecutor.Resolver)new DelayQueueResolver());
    }

    protected Response() {
        this.urlEncoder.addSafeCharacter('/');
    }

    public void initialize(Request request, HttpResponsePacket response, FilterChainContext ctx, DelayedExecutor.DelayQueue<Response> delayQueue, SuspendStatus suspendStatus) {
        this.request = request;
        this.response = response;
        this.outputBuffer = new OutputBuffer();
        this.outputBuffer.initialize(response, ctx);
        this.ctx = ctx;
        this.delayQueue = delayQueue;
        this.suspendStatus = suspendStatus;
    }

    public Request getRequest() {
        return this.request;
    }

    public HttpResponsePacket getResponse() {
        return this.response;
    }

    protected final void recycle() {
        this.suspendStatus = null;
        this.delayQueue = null;
        this.suspendedRunnable.reset();
        this.outputBuffer.recycle();
        this.usingOutputStream = false;
        this.usingWriter = false;
        this.appCommitted = false;
        this.error = false;
        this.detailErrorMsg = null;
        this.request = null;
        this.response.recycle();
        this.response = null;
        this.ctx = null;
        this.isSuspended = false;
        this.cookies.clear();
        this.cacheEnabled = false;
    }

    public String encodeURL(String url) {
        String absolute = this.toAbsolute(url, false);
        if (this.isEncodeable(absolute)) {
            if (url.equalsIgnoreCase("")) {
                url = absolute;
            }
            return this.toEncoded(url, this.request.getSession().getIdInternal());
        }
        return url;
    }

    protected boolean isEncodeable(String location) {
        if (location == null) {
            return false;
        }
        if (location.startsWith("#")) {
            return false;
        }
        Session session = this.request.getSession(false);
        if (session == null) {
            return false;
        }
        if (this.request.isRequestedSessionIdFromCookie()) {
            return false;
        }
        return this.doIsEncodeable(this.request, session, location);
    }

    private boolean doIsEncodeable(Request request, Session session, String location) {
        int urlPort;
        URL url;
        try {
            url = new URL(location);
        }
        catch (MalformedURLException e) {
            return false;
        }
        if (!request.getScheme().equalsIgnoreCase(url.getProtocol())) {
            return false;
        }
        if (!request.getServerName().equalsIgnoreCase(url.getHost())) {
            return false;
        }
        int serverPort = request.getServerPort();
        if (serverPort == -1) {
            serverPort = "https".equals(request.getScheme()) ? 443 : 80;
        }
        if ((urlPort = url.getPort()) == -1) {
            urlPort = "https".equals(url.getProtocol()) ? 443 : 80;
        }
        if (serverPort != urlPort) {
            return false;
        }
        String contextPath = "/";
        String file = url.getFile();
        if (file == null || !file.startsWith(contextPath)) {
            return false;
        }
        return file.indexOf(";jsessionid=" + session.getIdInternal()) < 0;
    }

    public String getInfo() {
        return info;
    }

    public void setError() {
        this.error = true;
    }

    public boolean isError() {
        return this.error;
    }

    public void setDetailMessage(String message) {
        this.detailErrorMsg = message;
    }

    public String getDetailMessage() {
        return this.detailErrorMsg;
    }

    public NIOOutputStream createOutputStream() throws IOException {
        if (this.outputStream == null) {
            this.outputStream = new NIOOutputStream(this.outputBuffer);
        }
        return this.outputStream;
    }

    public void finish() throws IOException {
        block4: {
            try {
                this.outputBuffer.endRequest();
            }
            catch (IOException e) {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.log(Level.FINEST, "ACTION_CLIENT_FLUSH", e);
                }
            }
            catch (Throwable t) {
                if (!LOGGER.isLoggable(Level.WARNING)) break block4;
                LOGGER.log(Level.WARNING, "ACTION_CLIENT_FLUSH", t);
            }
        }
    }

    public int getContentLength() {
        this.checkResponse();
        return (int)this.response.getContentLength();
    }

    public String getContentType() {
        this.checkResponse();
        return this.response.getContentType();
    }

    public int getBufferSize() {
        return this.outputBuffer.getBufferSize();
    }

    public String getCharacterEncoding() {
        this.checkResponse();
        return this.response.getCharacterEncoding();
    }

    public NIOOutputStream getOutputStream() throws IOException {
        if (this.usingWriter) {
            throw new IllegalStateException(sm.getString("response.getOutputStream.ise"));
        }
        this.usingOutputStream = true;
        if (this.outputStream == null) {
            this.outputStream = new NIOOutputStream(this.outputBuffer);
        }
        return this.outputStream;
    }

    public Locale getLocale() {
        this.checkResponse();
        return this.response.getLocale();
    }

    public NIOWriter getWriter() throws IOException {
        if (this.usingOutputStream) {
            throw new IllegalStateException(sm.getString("response.getWriter.ise"));
        }
        this.setCharacterEncoding(this.getCharacterEncoding());
        this.usingWriter = true;
        if (this.writer == null) {
            this.outputBuffer.processingChars();
            this.writer = new NIOWriter(this.outputBuffer);
        }
        return this.writer;
    }

    public boolean isCommitted() {
        this.checkResponse();
        return this.response.isCommitted();
    }

    public void flush() throws IOException {
        this.outputBuffer.flush();
    }

    public OutputBuffer getOutputBuffer() {
        return this.outputBuffer;
    }

    public void reset() {
        this.checkResponse();
        this.outputBuffer.reset();
    }

    public void resetBuffer() {
        this.resetBuffer(false);
    }

    public void resetBuffer(boolean resetWriterStreamFlags) {
        if (this.isCommitted()) {
            throw new IllegalStateException(sm.getString("response.resetBuffer.ise"));
        }
        this.outputBuffer.reset();
        if (resetWriterStreamFlags) {
            this.usingOutputStream = false;
            this.usingWriter = false;
        }
    }

    public void setBufferSize(int size) {
        if (this.isCommitted()) {
            throw new IllegalStateException("Unable to change buffer size as the response has been committed");
        }
        this.outputBuffer.setBufferSize(size);
    }

    public void setContentLengthLong(long length) {
        this.checkResponse();
        if (this.isCommitted()) {
            return;
        }
        if (this.usingWriter) {
            return;
        }
        this.response.setContentLength(length);
    }

    public void setContentLength(int length) {
        this.checkResponse();
        if (this.isCommitted()) {
            return;
        }
        if (this.usingWriter) {
            return;
        }
        this.response.setContentLength(length);
    }

    public void setContentType(String type) {
        int index;
        this.checkResponse();
        if (this.isCommitted()) {
            return;
        }
        if (this.usingWriter && type != null && (index = type.indexOf(";")) != -1) {
            type = type.substring(0, index);
        }
        this.response.setContentType(type);
        if (type != null && (index = type.indexOf(";")) != -1) {
            int len = type.length();
            ++index;
            while (index < len && Character.isSpaceChar(type.charAt(index))) {
                ++index;
            }
            if (index + 7 >= len || type.charAt(index) != 'c' || type.charAt(index + 1) != 'h' || type.charAt(index + 2) != 'a' || type.charAt(index + 3) != 'r' || type.charAt(index + 4) != 's' || type.charAt(index + 5) != 'e' || type.charAt(index + 6) != 't' || type.charAt(index + 7) == '=') {
                // empty if block
            }
        }
    }

    public void setCharacterEncoding(String charset) {
        this.checkResponse();
        if (this.isCommitted()) {
            return;
        }
        if (this.usingWriter) {
            return;
        }
        this.response.setCharacterEncoding(charset);
    }

    public void setLocale(Locale locale) {
        this.checkResponse();
        if (this.isCommitted()) {
            return;
        }
        this.response.setLocale(locale);
    }

    public Cookie[] getCookies() {
        return this.cookies.toArray(new Cookie[this.cookies.size()]);
    }

    public String getHeader(String name) {
        this.checkResponse();
        return this.response.getHeaders().getHeader(name);
    }

    public String[] getHeaderNames() {
        this.checkResponse();
        MimeHeaders headers = this.response.getHeaders();
        int n = headers.size();
        String[] result = new String[n];
        for (int i = 0; i < n; ++i) {
            result[i] = headers.getName(i).toString();
        }
        return result;
    }

    public String[] getHeaderValues(String name) {
        this.checkResponse();
        Enumeration e = this.response.getHeaders().values(name);
        LinkedList result = new LinkedList();
        while (e.hasMoreElements()) {
            result.add(e.nextElement());
        }
        return result.toArray(new String[result.size()]);
    }

    public String getMessage() {
        this.checkResponse();
        return this.response.getReasonPhrase();
    }

    public int getStatus() {
        this.checkResponse();
        return this.response.getStatus();
    }

    public void reset(int status, String message) {
        this.reset();
        this.setStatus(status, message);
    }

    public void addCookie(final Cookie cookie) {
        if (this.isCommitted()) {
            return;
        }
        final StringBuilder sb = new StringBuilder();
        if (System.getSecurityManager() != null) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    CookieSerializerUtils.serializeServerCookie((StringBuilder)sb, (Cookie)cookie);
                    return null;
                }
            });
        } else {
            CookieSerializerUtils.serializeServerCookie((StringBuilder)sb, (Cookie)cookie);
        }
        this.addHeader("Set-Cookie", sb.toString());
        this.cookies.add(cookie);
    }

    public void addDateHeader(String name, long value) {
        if (this.isCommitted()) {
            return;
        }
        if (this.format == null) {
            this.format = new SimpleDateFormat(HTTP_RESPONSE_DATE_HEADER, Locale.US);
            this.format.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
        this.addHeader(name, FastHttpDateFormat.formatDate((long)value, (DateFormat)this.format));
    }

    public void addHeader(String name, String value) {
        this.checkResponse();
        if (this.isCommitted()) {
            return;
        }
        this.response.addHeader(name, value);
    }

    public void addIntHeader(String name, int value) {
        if (this.isCommitted()) {
            return;
        }
        this.addHeader(name, "" + value);
    }

    public boolean containsHeader(String name) {
        this.checkResponse();
        return this.response.containsHeader(name);
    }

    public void sendAcknowledgement() throws IOException {
        this.checkResponse();
        if (this.isCommitted()) {
            return;
        }
        this.response.setAcknowledgement(true);
        this.outputBuffer.acknowledge();
    }

    public void sendError(int status) throws IOException {
        this.sendError(status, null);
    }

    public void sendError(int status, String message) throws IOException {
        this.checkResponse();
        if (this.isCommitted()) {
            throw new IllegalStateException(sm.getString("response.sendError.ise"));
        }
        this.setError();
        this.response.setStatus(status);
        this.response.setReasonPhrase(message);
        this.resetBuffer();
    }

    public void sendRedirect(String location) throws IOException {
        if (this.isCommitted()) {
            throw new IllegalStateException(sm.getString("response.sendRedirect.ise"));
        }
        this.resetBuffer();
        try {
            String absolute = this.toAbsolute(location, true);
            this.setStatus(HttpStatus.FOUND_302);
            this.setHeader("Location", absolute);
            this.setContentType("text/html");
            this.setLocale(Locale.getDefault());
            String filteredMsg = Response.filter(absolute);
            StringBuilder sb = new StringBuilder(150 + absolute.length());
            sb.append("<html>\r\n");
            sb.append("<head><title>Document moved</title></head>\r\n");
            sb.append("<body><h1>Document moved</h1>\r\n");
            sb.append("This document has moved <a href=\"");
            sb.append(filteredMsg);
            sb.append("\">here</a>.<p>\r\n");
            sb.append("</body>\r\n");
            sb.append("</html>\r\n");
            try {
                this.getWriter().write(sb.toString());
                this.getWriter().flush();
            }
            catch (IllegalStateException ise1) {
                try {
                    this.getOutputStream().write(sb.toString().getBytes());
                }
                catch (IllegalStateException ise2) {}
            }
        }
        catch (IllegalArgumentException e) {
            this.setStatus(HttpStatus.NOT_FOUND_404);
        }
    }

    public void setDateHeader(String name, long value) {
        if (this.isCommitted()) {
            return;
        }
        if (this.format == null) {
            this.format = new SimpleDateFormat(HTTP_RESPONSE_DATE_HEADER, Locale.US);
            this.format.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
        this.setHeader(name, FastHttpDateFormat.formatDate((long)value, (DateFormat)this.format));
    }

    public void setHeader(String name, String value) {
        this.checkResponse();
        if (this.isCommitted()) {
            return;
        }
        this.response.setHeader(name, value);
    }

    public void setIntHeader(String name, int value) {
        if (this.isCommitted()) {
            return;
        }
        this.setHeader(name, "" + value);
    }

    public void setStatus(int status) {
        this.setStatus(status, null);
    }

    public void setStatus(int status, String message) {
        this.checkResponse();
        if (this.isCommitted()) {
            return;
        }
        this.response.setStatus(status);
        this.response.setReasonPhrase(message);
    }

    public void setStatus(HttpStatus status) {
        this.checkResponse();
        if (this.isCommitted()) {
            return;
        }
        status.setValues(this.response);
    }

    protected String toAbsolute(String location, boolean normalize) {
        if (location == null) {
            return location;
        }
        boolean leadingSlash = location.startsWith("/");
        if (leadingSlash || !leadingSlash && location.indexOf("://") == -1) {
            this.redirectURLCC.recycle();
            String scheme = this.request.getScheme();
            String name = this.request.getServerName();
            int port = this.request.getServerPort();
            CharChunk cc = this.redirectURLCC.getCharChunk();
            try {
                cc.append(scheme, 0, scheme.length());
                cc.append("://", 0, 3);
                cc.append(name, 0, name.length());
                if (scheme.equals("http") && port != 80 || scheme.equals("https") && port != 443) {
                    cc.append(':');
                    String portS = port + "";
                    cc.append(portS, 0, portS.length());
                }
                if (!leadingSlash) {
                    String encodedURI;
                    String relativePath = this.request.getDecodedRequestURI();
                    int pos = relativePath.lastIndexOf(47);
                    final String frelativePath = relativePath = relativePath.substring(0, pos);
                    if (System.getSecurityManager() != null) {
                        try {
                            encodedURI = (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                                public Object run() throws IOException {
                                    return Response.this.urlEncoder.encodeURL(frelativePath);
                                }
                            });
                        }
                        catch (PrivilegedActionException pae) {
                            throw new IllegalArgumentException(location, pae.getCause());
                        }
                    } else {
                        encodedURI = this.urlEncoder.encodeURL(relativePath);
                    }
                    cc.append(encodedURI, 0, encodedURI.length());
                    cc.append('/');
                }
                cc.append(location, 0, location.length());
            }
            catch (IOException e) {
                throw new IllegalArgumentException(location, e);
            }
            if (normalize) {
                HttpRequestURIDecoder.normalize((MessageBytes)this.redirectURLCC);
            }
            return cc.toString();
        }
        return location;
    }

    public static String filter(String message) {
        if (message == null) {
            return null;
        }
        char[] content = new char[message.length()];
        message.getChars(0, message.length(), content, 0);
        StringBuilder result = new StringBuilder(content.length + 50);
        block6: for (int i = 0; i < content.length; ++i) {
            switch (content[i]) {
                case '<': {
                    result.append("&lt;");
                    continue block6;
                }
                case '>': {
                    result.append("&gt;");
                    continue block6;
                }
                case '&': {
                    result.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    result.append("&quot;");
                    continue block6;
                }
                default: {
                    result.append(content[i]);
                }
            }
        }
        return result.toString();
    }

    protected String toEncoded(String url, String sessionId) {
        String jrouteId;
        StringBuilder sb;
        int pound;
        if (url == null || sessionId == null) {
            return url;
        }
        String path = url;
        String query = "";
        String anchor = "";
        int question = url.indexOf(63);
        if (question >= 0) {
            path = url.substring(0, question);
            query = url.substring(question);
        }
        if ((pound = path.indexOf(35)) >= 0) {
            anchor = path.substring(pound);
            path = path.substring(0, pound);
        }
        if ((sb = new StringBuilder(path)).length() > 0) {
            sb.append(";jsessionid=");
            sb.append(sessionId);
        }
        if ((jrouteId = this.request.getHeader("proxy-jroute")) != null) {
            sb.append(":");
            sb.append(jrouteId);
        }
        sb.append(anchor);
        sb.append(query);
        return sb.toString();
    }

    public boolean isCacheEnabled() {
        return this.cacheEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSuspended() {
        this.checkResponse();
        Object object = this.suspendSync;
        synchronized (object) {
            return this.isSuspended;
        }
    }

    public void suspend() {
        this.suspend(-1L, TimeUnit.MILLISECONDS);
    }

    public void suspend(long timeout, TimeUnit timeunit) {
        this.suspend(timeout, timeunit, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend(long timeout, TimeUnit timeunit, CompletionHandler competionHandler) {
        this.checkResponse();
        Object object = this.suspendSync;
        synchronized (object) {
            if (this.isSuspended) {
                throw new IllegalStateException("Already Suspended");
            }
            this.suspendedRunnable.completionHandler = competionHandler;
            this.delayQueue.add((Object)this, timeout, timeunit);
            Connection connection = this.ctx.getConnection();
            HttpServerProbeNotifier.notifyRequestSuspend(this.request.httpServerFilter, connection, this.request);
            connection.addCloseListener((Connection.CloseListener)this.suspendedRunnable);
            this.suspendStatus.set();
            this.isSuspended = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        this.checkResponse();
        Object object = this.suspendSync;
        synchronized (object) {
            if (!this.isSuspended || this.suspendedRunnable.isResuming) {
                throw new IllegalStateException("Not Suspended");
            }
            Connection connection = this.ctx.getConnection();
            connection.removeCloseListener((Connection.CloseListener)this.suspendedRunnable);
            CompletionHandler completionHandler = this.suspendedRunnable.completionHandler;
            this.suspendedRunnable.isResuming = true;
            if (completionHandler != null) {
                completionHandler.completed((Object)this);
            }
            this.suspendedRunnable.reset();
            this.isSuspended = false;
            HttpServerProbeNotifier.notifyRequestResume(this.request.httpServerFilter, connection, this.request);
            this.ctx.resume();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        this.checkResponse();
        Object object = this.suspendSync;
        synchronized (object) {
            if (!this.isSuspended || this.suspendedRunnable.isResuming) {
                throw new IllegalStateException("Not Suspended");
            }
            Connection connection = this.ctx.getConnection();
            connection.removeCloseListener((Connection.CloseListener)this.suspendedRunnable);
            CompletionHandler completionHandler = this.suspendedRunnable.completionHandler;
            this.suspendedRunnable.isResuming = true;
            if (completionHandler != null) {
                completionHandler.cancelled();
            }
            this.isSuspended = false;
            this.suspendedRunnable.reset();
            HttpServerProbeNotifier.notifyRequestCancel(this.request.httpServerFilter, connection, this.request);
            this.ctx.resume();
        }
    }

    final void checkResponse() {
        if (this.response == null) {
            throw new IllegalStateException("Internal org.glassfish.grizzly.http.server.Response has not been set");
        }
    }

    private static class DelayQueueResolver
    implements DelayedExecutor.Resolver<Response> {
        private DelayQueueResolver() {
        }

        public boolean removeTimeout(Response element) {
            if (((Response)element).suspendedRunnable.timeoutTimeMillis != -1L) {
                ((Response)element).suspendedRunnable.timeoutTimeMillis = -1L;
                return true;
            }
            return false;
        }

        public Long getTimeoutMillis(Response element) {
            return ((Response)element).suspendedRunnable.timeoutTimeMillis;
        }

        public void setTimeoutMillis(Response element, long timeoutMillis) {
            ((Response)element).suspendedRunnable.timeoutTimeMillis = timeoutMillis;
        }
    }

    private static class DelayQueueWorker
    implements DelayedExecutor.Worker<Response> {
        private DelayQueueWorker() {
        }

        public void doWork(Response element) {
            element.suspendedRunnable.run();
        }
    }

    protected final class SuspendedRunnable
    implements Runnable,
    Connection.CloseListener {
        public CompletionHandler completionHandler;
        public boolean isResuming;
        public volatile long timeoutTimeMillis;

        protected SuspendedRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = Response.this.suspendSync;
            synchronized (object) {
                HttpServerProbeNotifier.notifyRequestTimeout(Response.this.request.httpServerFilter, Response.this.ctx.getConnection(), Response.this.request);
                Response.this.cancel();
            }
        }

        private void reset() {
            this.timeoutTimeMillis = -1L;
            this.completionHandler = null;
            this.isResuming = false;
        }

        public void onClosed(Connection connection) throws IOException {
            Response.this.cancel();
        }
    }
}

