/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.server.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.http.server.util.MappingData;
import org.glassfish.grizzly.http.util.BufferChunk;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.MemoryManager;

public class Mapper {
    private static final Logger logger = Grizzly.logger(Mapper.class);
    protected Host[] hosts = new Host[0];
    protected String defaultHostName = null;
    protected Context context = new Context();
    private HashMap<String, String> defaultContextPathsMap = new HashMap();
    private int port = 0;
    private static boolean allowReplacement = false;
    private final MemoryManager mm;

    public Mapper(MemoryManager mm) {
        this.mm = mm;
    }

    public static void setAllowReplacement(boolean ar) {
        allowReplacement = ar;
    }

    public static boolean allowReplacement() {
        return allowReplacement;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public String getDefaultHostName() {
        return this.defaultHostName;
    }

    public void setDefaultHostName(String defaultHostName) {
        this.defaultHostName = defaultHostName;
    }

    public synchronized void addHost(String name, String[] aliases, Object host) {
        MapElement[] newHosts = new Host[this.hosts.length + 1];
        Host newHost = new Host();
        ContextList contextList = new ContextList();
        Context[] defaultContexts = new Context[1];
        String[] defaultContextPaths = new String[1];
        newHost.name = name;
        newHost.contextList = contextList;
        newHost.object = host;
        newHost.defaultContexts = defaultContexts;
        newHost.defaultContextPaths = defaultContextPaths;
        Host oldElem = (Host)this.insertMapIgnoreCase(this.hosts, newHosts, newHost);
        if (oldElem == null) {
            this.hosts = newHosts;
        } else if (allowReplacement) {
            oldElem.object = host;
            contextList = oldElem.contextList;
        }
        for (String aliase : aliases) {
            newHosts = new Host[this.hosts.length + 1];
            newHost = new Host();
            newHost.name = aliase;
            newHost.contextList = contextList;
            newHost.defaultContexts = defaultContexts;
            newHost.defaultContextPaths = defaultContextPaths;
            newHost.object = host;
            if (this.insertMapIgnoreCase(this.hosts, newHosts, newHost) != null) continue;
            this.hosts = newHosts;
        }
        String defaultContextPath = this.defaultContextPathsMap.get(name);
        if (defaultContextPath != null) {
            newHost.defaultContextPaths[0] = defaultContextPath;
        }
    }

    public synchronized void removeHost(String name) {
        int pos = this.findIgnoreCase(this.hosts, name);
        if (pos < 0) {
            return;
        }
        Object host = this.hosts[pos].object;
        MapElement[] newHosts = new Host[this.hosts.length - 1];
        if (this.removeMapIgnoreCase(this.hosts, newHosts, name)) {
            this.hosts = newHosts;
        }
        for (MapElement newHost : newHosts) {
            MapElement[] newHosts2;
            if (((Host)newHost).object != host || !this.removeMapIgnoreCase(this.hosts, newHosts2 = new Host[this.hosts.length - 1], ((Host)newHost).name)) continue;
            this.hosts = newHosts2;
        }
        this.defaultContextPathsMap.remove(name);
    }

    public String[] getHosts() {
        String[] hostN = new String[this.hosts.length];
        for (int i = 0; i < this.hosts.length; ++i) {
            hostN[i] = this.hosts[i].name;
        }
        return hostN;
    }

    public void setContext(String path, String[] welcomeResources, javax.naming.Context resources) {
        this.context.name = path;
        this.context.welcomeResources = welcomeResources;
        this.context.resources = resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addContext(String hostName, String path, Object context, String[] welcomeResources, javax.naming.Context resources) {
        MapElement[] hosts = this.hosts;
        int pos = this.findIgnoreCase(hosts, hostName);
        if (pos < 0) {
            this.addHost(hostName, new String[0], "");
            hosts = this.hosts;
            pos = this.findIgnoreCase(hosts, hostName);
        }
        if (pos < 0) {
            logger.severe("No host found: " + hostName);
        }
        MapElement host = hosts[pos];
        if (((Host)host).name.equalsIgnoreCase(hostName)) {
            int slashCount = Mapper.slashCount(path);
            MapElement mapElement = host;
            synchronized (mapElement) {
                MapElement[] contexts = ((Host)host).contextList.contexts;
                if (slashCount > ((Host)host).contextList.nesting) {
                    ((Host)host).contextList.nesting = slashCount;
                }
                MapElement[] newContexts = new Context[contexts.length + 1];
                Context newContext = new Context();
                newContext.name = path;
                newContext.object = context;
                newContext.welcomeResources = welcomeResources;
                newContext.resources = resources;
                Context oldElem = (Context)Mapper.insertMap(contexts, newContexts, newContext);
                if (oldElem == null) {
                    ((Host)host).contextList.contexts = newContexts;
                    if (path.equals(((Host)host).defaultContextPaths[0])) {
                        ((Host)host).defaultContexts[0] = newContext;
                    }
                } else if (allowReplacement) {
                    oldElem.object = context;
                    oldElem.welcomeResources = welcomeResources;
                    oldElem.resources = resources;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeContext(String hostName, String path) {
        MapElement[] hosts = this.hosts;
        int pos = this.findIgnoreCase(hosts, hostName);
        if (pos < 0) {
            return;
        }
        MapElement host = hosts[pos];
        if (((Host)host).name.equalsIgnoreCase(hostName)) {
            MapElement mapElement = host;
            synchronized (mapElement) {
                MapElement[] contexts = ((Host)host).contextList.contexts;
                if (contexts.length == 0) {
                    return;
                }
                MapElement[] newContexts = new Context[contexts.length - 1];
                if (Mapper.removeMap(contexts, newContexts, path)) {
                    ((Host)host).contextList.contexts = newContexts;
                    ((Host)host).contextList.nesting = 0;
                    for (MapElement newContext : newContexts) {
                        int slashCount = Mapper.slashCount(((Context)newContext).name);
                        if (slashCount <= ((Host)host).contextList.nesting) continue;
                        ((Host)host).contextList.nesting = slashCount;
                    }
                }
            }
        }
    }

    public String[] getContextNames() {
        ArrayList<String> list = new ArrayList<String>();
        for (Host host : this.hosts) {
            for (int j = 0; j < host.contextList.contexts.length; ++j) {
                String cname = host.contextList.contexts[j].name;
                list.add("//" + host.name + (cname.startsWith("/") ? cname : "/"));
            }
        }
        String[] res = new String[list.size()];
        return list.toArray(res);
    }

    public void addWrapper(String hostName, String contextPath, String path, Object wrapper) {
        this.addWrapper(hostName, contextPath, path, wrapper, false);
    }

    public void addWrapper(String hostName, String contextPath, String path, Object wrapper, boolean jspWildCard) {
        MapElement[] hosts = this.hosts;
        int pos = this.findIgnoreCase(hosts, hostName);
        if (pos < 0) {
            return;
        }
        MapElement host = hosts[pos];
        if (((Host)host).name.equalsIgnoreCase(hostName)) {
            MapElement[] contexts = ((Host)host).contextList.contexts;
            int pos2 = Mapper.find(contexts, contextPath);
            if (pos2 < 0) {
                logger.severe("No context found: " + contextPath);
                return;
            }
            MapElement context = contexts[pos2];
            if (((Context)context).name.equals(contextPath)) {
                this.addWrapper((Context)context, path, wrapper, jspWildCard);
            }
        }
    }

    public void addWrapper(String path, Object wrapper) {
        this.addWrapper(this.context, path, wrapper);
    }

    public void addWrapper(String path, Object wrapper, boolean jspWildCard) {
        this.addWrapper(this.context, path, wrapper, jspWildCard);
    }

    protected void addWrapper(Context context, String path, Object wrapper) {
        this.addWrapper(context, path, wrapper, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addWrapper(Context context, String path, Object wrapper, boolean jspWildCard) {
        Context context2 = context;
        synchronized (context2) {
            Wrapper newWrapper = new Wrapper();
            newWrapper.object = wrapper;
            newWrapper.jspWildCard = jspWildCard;
            if (path.endsWith("/*")) {
                newWrapper.name = path.substring(0, path.length() - 2);
                MapElement[] oldWrappers = context.wildcardWrappers;
                MapElement[] newWrappers = new Wrapper[oldWrappers.length + 1];
                Wrapper oldElem = (Wrapper)Mapper.insertMap(oldWrappers, newWrappers, newWrapper);
                if (oldElem == null) {
                    context.wildcardWrappers = newWrappers;
                    int slashCount = Mapper.slashCount(newWrapper.name);
                    if (slashCount > context.nesting) {
                        context.nesting = slashCount;
                    }
                } else if (allowReplacement) {
                    oldElem.object = wrapper;
                    oldElem.jspWildCard = jspWildCard;
                }
            } else if (path.startsWith("*.")) {
                newWrapper.name = path.substring(2);
                MapElement[] oldWrappers = context.extensionWrappers;
                MapElement[] newWrappers = new Wrapper[oldWrappers.length + 1];
                Wrapper oldElem = (Wrapper)Mapper.insertMap(oldWrappers, newWrappers, newWrapper);
                if (oldElem == null) {
                    context.extensionWrappers = newWrappers;
                } else if (allowReplacement) {
                    oldElem.object = wrapper;
                    oldElem.jspWildCard = jspWildCard;
                }
            } else if (path.equals("/")) {
                newWrapper.name = "";
                context.defaultWrapper = newWrapper;
            } else {
                newWrapper.name = path;
                MapElement[] oldWrappers = context.exactWrappers;
                MapElement[] newWrappers = new Wrapper[oldWrappers.length + 1];
                Wrapper oldElem = (Wrapper)Mapper.insertMap(oldWrappers, newWrappers, newWrapper);
                if (oldElem == null) {
                    context.exactWrappers = newWrappers;
                } else if (allowReplacement) {
                    oldElem.object = wrapper;
                    oldElem.jspWildCard = jspWildCard;
                }
            }
        }
    }

    public void removeWrapper(String path) {
        this.removeWrapper(this.context, path);
    }

    public void removeWrapper(String hostName, String contextPath, String path) {
        MapElement[] hosts = this.hosts;
        int pos = this.findIgnoreCase(hosts, hostName);
        if (pos < 0) {
            return;
        }
        MapElement host = hosts[pos];
        if (((Host)host).name.equalsIgnoreCase(hostName)) {
            MapElement[] contexts = ((Host)host).contextList.contexts;
            int pos2 = Mapper.find(contexts, contextPath);
            if (pos2 < 0) {
                return;
            }
            MapElement context = contexts[pos2];
            if (((Context)context).name.equals(contextPath)) {
                this.removeWrapper((Context)context, path);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeWrapper(Context context, String path) {
        Context context2 = context;
        synchronized (context2) {
            if (path.endsWith("/*")) {
                MapElement[] oldWrappers = context.wildcardWrappers;
                MapElement[] newWrappers = new Wrapper[oldWrappers.length - 1];
                String name = path.substring(0, path.length() - 2);
                if (Mapper.removeMap(oldWrappers, newWrappers, name)) {
                    context.nesting = 0;
                    for (MapElement newWrapper : newWrappers) {
                        int slashCount = Mapper.slashCount(((Wrapper)newWrapper).name);
                        if (slashCount <= context.nesting) continue;
                        context.nesting = slashCount;
                    }
                    context.wildcardWrappers = newWrappers;
                }
            } else if (path.startsWith("*.")) {
                MapElement[] oldWrappers = context.extensionWrappers;
                MapElement[] newWrappers = new Wrapper[oldWrappers.length - 1];
                String name = path.substring(2);
                if (Mapper.removeMap(oldWrappers, newWrappers, name)) {
                    context.extensionWrappers = newWrappers;
                }
            } else if (path.equals("/")) {
                context.defaultWrapper = null;
            } else {
                MapElement[] oldWrappers = context.exactWrappers;
                MapElement[] newWrappers = new Wrapper[oldWrappers.length - 1];
                if (Mapper.removeMap(oldWrappers, newWrappers, path)) {
                    context.exactWrappers = newWrappers;
                }
            }
        }
    }

    public String getWrappersString(String host, String context) {
        String[] names = this.getWrapperNames(host, context);
        StringBuilder sb = new StringBuilder();
        for (String name : names) {
            sb.append(name).append(":");
        }
        return sb.toString();
    }

    public String[] getWrapperNames(String host, String context) {
        ArrayList<String> list = new ArrayList<String>();
        if (host == null) {
            host = "";
        }
        if (context == null) {
            context = "";
        }
        for (Host host1 : this.hosts) {
            if (!host.equals(host1.name)) continue;
            for (int j = 0; j < host1.contextList.contexts.length; ++j) {
                int k;
                if (!context.equals(host1.contextList.contexts[j].name)) continue;
                Context ctx = host1.contextList.contexts[j];
                list.add(ctx.defaultWrapper.path);
                for (k = 0; k < ctx.exactWrappers.length; ++k) {
                    list.add(ctx.exactWrappers[k].path);
                }
                for (k = 0; k < ctx.wildcardWrappers.length; ++k) {
                    list.add(ctx.wildcardWrappers[k].path + "*");
                }
                for (k = 0; k < ctx.extensionWrappers.length; ++k) {
                    list.add("*." + ctx.extensionWrappers[k].path);
                }
            }
        }
        String[] res = new String[list.size()];
        return list.toArray(res);
    }

    public void setDefaultContextPath(String hostName, String defaultContextPath) throws Exception {
        int pos;
        if (defaultContextPath != null) {
            this.defaultContextPathsMap.put(hostName, defaultContextPath);
        }
        if ((pos = this.findIgnoreCase(this.hosts, hostName)) < 0) {
            return;
        }
        this.hosts[pos].defaultContextPaths[0] = defaultContextPath;
        if (defaultContextPath != null) {
            this.addDefaultContext(this.hosts[pos], defaultContextPath);
        } else {
            this.hosts[pos].defaultContexts[0] = null;
            this.defaultContextPathsMap.remove(hostName);
        }
    }

    private void addDefaultContext(Host host, String defaultContextPath) throws Exception {
        boolean defaultContextFound = false;
        Context[] contexts = host.contextList.contexts;
        if (contexts != null) {
            for (Context context1 : contexts) {
                if (!context1.name.equals(defaultContextPath)) continue;
                host.defaultContexts[0] = context1;
                defaultContextFound = true;
                break;
            }
        }
        if (!defaultContextFound) {
            throw new Exception("No context matching " + defaultContextPath + " deployed on virtual server " + host.name);
        }
    }

    public void map(BufferChunk host, BufferChunk uri, MappingData mappingData) throws Exception {
        if (host.isNull()) {
            host.setBuffer(Buffers.wrap((MemoryManager)this.mm, (String)this.defaultHostName));
        }
        this.internalMap(host, uri, mappingData);
    }

    public void map(BufferChunk uri, MappingData mappingData) throws Exception {
        this.internalMapWrapper(this.context, uri, mappingData);
    }

    private void internalMap(BufferChunk host, BufferChunk uri, MappingData mappingData) throws Exception {
        int pos;
        MapElement[] contexts = null;
        Context context = null;
        int nesting = 0;
        int hostPos = -1;
        if (mappingData.host == null) {
            MapElement[] hosts = this.hosts;
            pos = Mapper.findIgnoreCase(hosts, host);
            if (pos != -1 && host.equalsIgnoreCase(((Host)hosts[pos]).name)) {
                mappingData.host = ((Host)hosts[pos]).object;
                hostPos = pos;
                contexts = ((Host)hosts[pos]).contextList.contexts;
                nesting = ((Host)hosts[pos]).contextList.nesting;
            } else {
                if (this.defaultHostName == null) {
                    return;
                }
                pos = this.findIgnoreCase(hosts, this.defaultHostName);
                if (pos != -1 && this.defaultHostName.equalsIgnoreCase(((Host)hosts[pos]).name)) {
                    mappingData.host = ((Host)hosts[pos]).object;
                    hostPos = pos;
                    contexts = ((Host)hosts[pos]).contextList.contexts;
                    nesting = ((Host)hosts[pos]).contextList.nesting;
                } else {
                    return;
                }
            }
        }
        if (mappingData.context == null) {
            boolean found = false;
            pos = Mapper.find(contexts, uri);
            if (pos == -1) {
                if (this.hosts[hostPos].defaultContexts[0] == null) {
                    return;
                }
                context = this.hosts[hostPos].defaultContexts[0];
                mappingData.context = context.object;
                mappingData.contextPath.setBuffer(Buffers.wrap((MemoryManager)this.mm, (String)context.name));
                found = true;
                mappingData.isDefaultContext = true;
            }
            if (!found) {
                int lastSlash = -1;
                int uriEnd = uri.getEnd();
                while (pos >= 0) {
                    assert (contexts != null);
                    if (uri.startsWith(contexts[pos].name, 0)) {
                        int length = contexts[pos].name.length();
                        if (uri.size() == length) {
                            found = true;
                            break;
                        }
                        if (uri.startsWithIgnoreCase("/", length)) {
                            found = true;
                            break;
                        }
                    }
                    lastSlash = lastSlash == -1 ? Mapper.nthSlash(uri, nesting + 1) : Mapper.lastSlash(uri);
                    uri.setEnd(lastSlash);
                    pos = Mapper.find(contexts, uri);
                }
                uri.setEnd(uriEnd);
                if (!found) {
                    assert (contexts != null);
                    if (contexts[0].name.equals("")) {
                        context = contexts[0];
                    } else if (this.hosts[hostPos].defaultContexts[0] != null) {
                        context = this.hosts[hostPos].defaultContexts[0];
                        mappingData.isDefaultContext = true;
                    }
                } else {
                    context = contexts[pos];
                }
                if (context != null) {
                    mappingData.context = context.object;
                    mappingData.contextPath.setBuffer(Buffers.wrap((MemoryManager)this.mm, (String)context.name));
                }
            }
        }
        if (context != null && mappingData.wrapper == null) {
            this.internalMapWrapper(context, uri, mappingData);
        }
    }

    private void internalMapWrapper(Context context, BufferChunk path, MappingData mappingData) throws Exception {
        int servletPath;
        int pathOffset = path.getStart();
        int pathEnd = path.getEnd();
        boolean noServletPath = false;
        if (mappingData.isDefaultContext) {
            servletPath = pathOffset;
        } else {
            int length = context.name.length();
            if (length != pathEnd - pathOffset) {
                servletPath = pathOffset + length;
            } else {
                noServletPath = true;
                Buffer b = path.getBuffer();
                b.putChar('/');
                path.setBuffer(b);
                pathOffset = path.getStart();
                pathEnd = path.getEnd();
                servletPath = pathOffset + length;
            }
        }
        path.setStart(servletPath);
        Wrapper[] exactWrappers = context.exactWrappers;
        this.internalMapExactWrapper(exactWrappers, path, mappingData);
        boolean checkJspWelcomeFiles = false;
        Wrapper[] wildcardWrappers = context.wildcardWrappers;
        if (mappingData.wrapper == null) {
            this.internalMapWildcardWrapper(wildcardWrappers, context.nesting, path, mappingData);
            if (mappingData.wrapper != null && mappingData.jspWildCard) {
                Buffer buf = path.getBuffer();
                if (buf.get(pathEnd - 1) == 47) {
                    mappingData.wrapper = null;
                    checkJspWelcomeFiles = true;
                } else {
                    mappingData.wrapperPath.setBuffer(buf, path.getStart(), path.size());
                    mappingData.pathInfo.recycle();
                }
            }
        }
        if (noServletPath) {
            boolean redirect;
            boolean bl = redirect = mappingData.wrapper == null;
            if (!redirect) {
                String wpath = mappingData.wrapperPath.toString();
                boolean bl2 = redirect = wpath != null && wpath.length() == 0;
            }
            if (redirect) {
                mappingData.redirectPath.setBuffer(path.getBuffer(), pathOffset, pathEnd);
                path.setEnd(pathEnd - 1);
                return;
            }
        }
        Wrapper[] extensionWrappers = context.extensionWrappers;
        if (mappingData.wrapper == null && !checkJspWelcomeFiles) {
            this.internalMapExtensionWrapper(extensionWrappers, path, mappingData);
        }
        if (mappingData.wrapper == null) {
            boolean checkWelcomeFiles = checkJspWelcomeFiles;
            if (!checkWelcomeFiles) {
                Buffer buf = path.getBuffer();
                boolean bl = checkWelcomeFiles = buf.get(pathEnd - 1) == 47;
            }
            if (checkWelcomeFiles) {
                for (int i = 0; i < context.welcomeResources.length && mappingData.wrapper == null; ++i) {
                    path.setStart(pathOffset);
                    path.setEnd(pathEnd);
                    Buffer b = path.getBuffer();
                    b.put(context.welcomeResources[0].getBytes(), 0, context.welcomeResources[i].length());
                    path.setBuffer(b);
                    path.setStart(servletPath);
                    this.internalMapExactWrapper(exactWrappers, path, mappingData);
                    if (mappingData.wrapper == null) {
                        this.internalMapWildcardWrapper(wildcardWrappers, context.nesting, path, mappingData);
                    }
                    if (mappingData.wrapper != null || context.resources == null) continue;
                    Object file = null;
                    String pathStr = path.toString();
                    try {
                        file = context.resources.lookup(pathStr);
                    }
                    catch (NamingException nex) {
                        // empty catch block
                    }
                    if (file == null || file instanceof DirContext) continue;
                    this.internalMapExtensionWrapper(extensionWrappers, path, mappingData);
                    if (mappingData.wrapper != null || context.defaultWrapper == null) continue;
                    mappingData.wrapper = context.defaultWrapper.object;
                    mappingData.requestPath.setBuffer(path.getBuffer(), path.getStart(), path.size());
                    mappingData.wrapperPath.setBuffer(path.getBuffer(), path.getStart(), path.size());
                    mappingData.requestPath.setBuffer(Buffers.wrap((MemoryManager)this.mm, (String)pathStr));
                    mappingData.wrapperPath.setBuffer(Buffers.wrap((MemoryManager)this.mm, (String)pathStr));
                }
                path.setStart(servletPath);
                path.setEnd(pathEnd);
            }
        }
        if (mappingData.wrapper == null && !checkJspWelcomeFiles) {
            if (context.defaultWrapper != null) {
                mappingData.wrapper = context.defaultWrapper.object;
                mappingData.requestPath.setBuffer(path.getBuffer(), path.getStart(), path.size());
                mappingData.wrapperPath.setBuffer(path.getBuffer(), path.getStart(), path.size());
            }
            Buffer buf = path.getBuffer();
            if (context.resources != null && buf.get(pathEnd - 1) != 47) {
                Object file = null;
                String pathStr = path.toString();
                try {
                    file = context.resources.lookup(pathStr);
                }
                catch (NamingException nex) {
                    // empty catch block
                }
                if (file != null && file instanceof DirContext) {
                    path.setStart(pathOffset);
                    Buffer b = path.getBuffer();
                    b.put((byte)47);
                    path.setBuffer(b);
                    mappingData.redirectPath.setBuffer(path.getBuffer(), path.getStart(), path.size());
                } else {
                    mappingData.requestPath.setBuffer(Buffers.wrap((MemoryManager)this.mm, (String)pathStr));
                    mappingData.wrapperPath.setBuffer(Buffers.wrap((MemoryManager)this.mm, (String)pathStr));
                }
            }
        }
        path.setStart(pathOffset);
        path.setEnd(pathEnd);
    }

    private void internalMapExactWrapper(Wrapper[] wrappers, BufferChunk path, MappingData mappingData) {
        int pos = Mapper.find((MapElement[])wrappers, path);
        if (pos != -1 && path.equals(wrappers[pos].name)) {
            mappingData.requestPath.setBuffer(Buffers.wrap((MemoryManager)this.mm, (String)wrappers[pos].name));
            mappingData.wrapperPath.setBuffer(Buffers.wrap((MemoryManager)this.mm, (String)wrappers[pos].name));
            mappingData.wrapper = wrappers[pos].object;
        }
    }

    private void internalMapWildcardWrapper(Wrapper[] wrappers, int nesting, BufferChunk path, MappingData mappingData) {
        int pathEnd = path.getEnd();
        int lastSlash = -1;
        int length = -1;
        int pos = Mapper.find((MapElement[])wrappers, path);
        if (pos != -1) {
            boolean found = false;
            while (pos >= 0) {
                if (path.startsWith(wrappers[pos].name, 0)) {
                    length = wrappers[pos].name.length();
                    if (path.size() == length) {
                        found = true;
                        break;
                    }
                    if (path.startsWithIgnoreCase("/", length)) {
                        found = true;
                        break;
                    }
                }
                lastSlash = lastSlash == -1 ? Mapper.nthSlash(path, nesting + 1) : Mapper.lastSlash(path);
                path.setEnd(lastSlash);
                pos = Mapper.find((MapElement[])wrappers, path);
            }
            path.setEnd(pathEnd);
            if (found) {
                mappingData.wrapperPath.setBuffer(Buffers.wrap((MemoryManager)this.mm, (String)wrappers[pos].name));
                if (path.size() > length) {
                    mappingData.pathInfo.setBuffer(path.getBuffer(), path.getStart() + length, path.getEnd());
                }
                mappingData.requestPath.setBuffer(path.getBuffer(), path.getStart(), path.size());
                mappingData.wrapper = wrappers[pos].object;
                mappingData.jspWildCard = wrappers[pos].jspWildCard;
            }
        }
    }

    private void internalMapExtensionWrapper(Wrapper[] wrappers, BufferChunk path, MappingData mappingData) {
        Buffer buf = path.getBuffer();
        int pathEnd = path.getEnd();
        int servletPath = path.getStart();
        int slash = -1;
        for (int i = pathEnd - 1; i >= servletPath; --i) {
            if (buf.get(i) != 47) continue;
            slash = i;
            break;
        }
        if (slash >= 0) {
            int period = -1;
            for (int i = pathEnd - 1; i > slash; --i) {
                if (buf.get(i) != 46) continue;
                period = i;
                break;
            }
            if (period >= 0) {
                path.setStart(period + 1);
                path.setEnd(pathEnd);
                int pos = Mapper.find((MapElement[])wrappers, path);
                if (pos != -1 && path.equals(wrappers[pos].name)) {
                    mappingData.wrapperPath.setBuffer(buf, servletPath, pathEnd - servletPath);
                    mappingData.requestPath.setBuffer(buf, servletPath, pathEnd - servletPath);
                    mappingData.wrapper = wrappers[pos].object;
                }
                path.setStart(servletPath);
                path.setEnd(pathEnd);
            }
        }
    }

    private static int find(MapElement[] map, BufferChunk name) {
        return Mapper.find(map, name, name.getStart(), name.getEnd());
    }

    private static int find(MapElement[] map, BufferChunk name, int start, int end) {
        int a = 0;
        int b = map.length - 1;
        if (b == -1) {
            return -1;
        }
        if (name.compare(start, end, map[0].name) < 0) {
            return -1;
        }
        if (b == 0) {
            return 0;
        }
        do {
            int i = b + a >>> 1;
            int result = name.compare(start, end, map[i].name);
            if (result == 1) {
                a = i;
                continue;
            }
            if (result == 0) {
                return i;
            }
            b = i;
        } while (b - a != 1);
        int result2 = name.compare(start, end, map[b].name);
        if (result2 < 0) {
            return a;
        }
        return b;
    }

    private int findIgnoreCase(MapElement[] map, String name) {
        BufferChunk chunk = BufferChunk.newInstance();
        chunk.setBuffer(Buffers.wrap((MemoryManager)this.mm, (String)name));
        return Mapper.findIgnoreCase(map, chunk);
    }

    private static int findIgnoreCase(MapElement[] map, BufferChunk name) {
        return Mapper.findIgnoreCase(map, name, name.getStart(), name.getEnd());
    }

    private static int findIgnoreCase(MapElement[] map, BufferChunk name, int start, int end) {
        int a = 0;
        int b = map.length - 1;
        if (b == -1) {
            return -1;
        }
        if (name.compareIgnoreCase(start, end, map[0].name) < 0) {
            return -1;
        }
        if (b == 0) {
            return 0;
        }
        do {
            int i = b + a >>> 1;
            int result = name.compareIgnoreCase(start, end, map[i].name);
            if (result == 1) {
                a = i;
                continue;
            }
            if (result == 0) {
                return i;
            }
            b = i;
        } while (b - a != 1);
        int result2 = name.compareIgnoreCase(start, end, map[b].name);
        if (result2 < 0) {
            return a;
        }
        return b;
    }

    private static int find(MapElement[] map, String name) {
        int a = 0;
        int b = map.length - 1;
        if (b == -1) {
            return -1;
        }
        if (name.compareTo(map[0].name) < 0) {
            return -1;
        }
        if (b == 0) {
            return 0;
        }
        do {
            int i = b + a >>> 1;
            int result = name.compareTo(map[i].name);
            if (result > 0) {
                a = i;
                continue;
            }
            if (result == 0) {
                return i;
            }
            b = i;
        } while (b - a != 1);
        int result2 = name.compareTo(map[b].name);
        if (result2 < 0) {
            return a;
        }
        return b;
    }

    private static int lastSlash(BufferChunk name) {
        Buffer b = name.getBuffer();
        int end = name.getEnd();
        int start = name.getStart();
        int pos = end;
        while (pos > start && b.get(--pos) != 47) {
        }
        return pos;
    }

    private static int nthSlash(BufferChunk name, int n) {
        Buffer b = name.getBuffer();
        int end = name.getEnd();
        int pos = name.getStart();
        int count = 0;
        while (pos < end) {
            if (b.get(pos++) != 47 || ++count != n) continue;
            --pos;
            break;
        }
        return pos;
    }

    private static int slashCount(String name) {
        int pos = -1;
        int count = 0;
        while ((pos = name.indexOf(47, pos + 1)) != -1) {
            ++count;
        }
        return count;
    }

    private static MapElement insertMap(MapElement[] oldMap, MapElement[] newMap, MapElement newElement) {
        int pos = Mapper.find(oldMap, newElement.name);
        if (pos != -1 && newElement.name.equals(oldMap[pos].name)) {
            return oldMap[pos];
        }
        System.arraycopy(oldMap, 0, newMap, 0, pos + 1);
        newMap[pos + 1] = newElement;
        System.arraycopy(oldMap, pos + 1, newMap, pos + 2, oldMap.length - pos - 1);
        return null;
    }

    private MapElement insertMapIgnoreCase(MapElement[] oldMap, MapElement[] newMap, MapElement newElement) {
        BufferChunk chunk = BufferChunk.newInstance();
        chunk.setBuffer(Buffers.wrap((MemoryManager)this.mm, (String)newElement.name));
        int pos = Mapper.findIgnoreCase(oldMap, chunk);
        if (pos != -1 && newElement.name.equalsIgnoreCase(oldMap[pos].name)) {
            return oldMap[pos];
        }
        System.arraycopy(oldMap, 0, newMap, 0, pos + 1);
        newMap[pos + 1] = newElement;
        System.arraycopy(oldMap, pos + 1, newMap, pos + 2, oldMap.length - pos - 1);
        return null;
    }

    private static boolean removeMap(MapElement[] oldMap, MapElement[] newMap, String name) {
        int pos = Mapper.find(oldMap, name);
        if (pos != -1 && name.equals(oldMap[pos].name)) {
            System.arraycopy(oldMap, 0, newMap, 0, pos);
            System.arraycopy(oldMap, pos + 1, newMap, pos, oldMap.length - pos - 1);
            return true;
        }
        return false;
    }

    private boolean removeMapIgnoreCase(MapElement[] oldMap, MapElement[] newMap, String name) {
        BufferChunk chunk = BufferChunk.newInstance();
        chunk.setBuffer(Buffers.wrap((MemoryManager)this.mm, (String)name));
        int pos = Mapper.findIgnoreCase(oldMap, chunk);
        if (pos != -1 && name.equalsIgnoreCase(oldMap[pos].name)) {
            System.arraycopy(oldMap, 0, newMap, 0, pos);
            System.arraycopy(oldMap, pos + 1, newMap, pos, oldMap.length - pos - 1);
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
    }

    protected static class Wrapper
    extends MapElement {
        public String path = null;
        public boolean jspWildCard = false;

        protected Wrapper() {
        }
    }

    protected static final class Context
    extends MapElement {
        public String path = null;
        public String[] welcomeResources = new String[0];
        public javax.naming.Context resources = null;
        public Wrapper defaultWrapper = null;
        public Wrapper[] exactWrappers = new Wrapper[0];
        public Wrapper[] wildcardWrappers = new Wrapper[0];
        public Wrapper[] extensionWrappers = new Wrapper[0];
        public int nesting = 0;

        protected Context() {
        }
    }

    protected static final class ContextList {
        public Context[] contexts = new Context[0];
        public int nesting = 0;

        protected ContextList() {
        }
    }

    protected static final class Host
    extends MapElement {
        public ContextList contextList = null;
        public String[] defaultContextPaths = null;
        public Context[] defaultContexts = null;

        protected Host() {
        }
    }

    protected static abstract class MapElement {
        public String name = null;
        public Object object = null;

        protected MapElement() {
        }
    }
}

