/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.server;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpPacket;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.server.HttpRequestProcessor;
import org.glassfish.grizzly.http.server.HttpServerProbe;
import org.glassfish.grizzly.http.server.HttpServerProbeNotifier;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Response;
import org.glassfish.grizzly.http.server.ServerFilterConfiguration;
import org.glassfish.grizzly.http.server.SuspendStatus;
import org.glassfish.grizzly.http.server.io.ReadHandler;
import org.glassfish.grizzly.http.server.util.HtmlHelper;
import org.glassfish.grizzly.http.util.HttpStatus;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.monitoring.jmx.AbstractJmxMonitoringConfig;
import org.glassfish.grizzly.monitoring.jmx.JmxMonitoringAware;
import org.glassfish.grizzly.monitoring.jmx.JmxMonitoringConfig;
import org.glassfish.grizzly.monitoring.jmx.JmxObject;
import org.glassfish.grizzly.utils.DelayedExecutor;

public class HttpServerFilter
extends BaseFilter
implements JmxMonitoringAware<HttpServerProbe> {
    private final Attribute<Request> httpRequestInProcessAttr;
    private final DelayedExecutor.DelayQueue<Response> suspendedResponseQueue;
    private volatile HttpRequestProcessor httpService;
    private final ServerFilterConfiguration config;
    protected final AbstractJmxMonitoringConfig<HttpServerProbe> monitoringConfig = new AbstractJmxMonitoringConfig<HttpServerProbe>(HttpServerProbe.class){

        public JmxObject createManagementObject() {
            return HttpServerFilter.this.createJmxManagementObject();
        }
    };

    public HttpServerFilter(ServerFilterConfiguration config, DelayedExecutor delayedExecutor) {
        this.config = config;
        this.suspendedResponseQueue = Response.createDelayQueue(delayedExecutor);
        this.httpRequestInProcessAttr = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute("HttpServerFilter.Request");
    }

    public HttpRequestProcessor getHttpService() {
        return this.httpService;
    }

    public void setHttpService(HttpRequestProcessor httpService) {
        this.httpService = httpService;
    }

    public ServerFilterConfiguration getConfiguration() {
        return this.config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        Object message = ctx.getMessage();
        Connection connection = ctx.getConnection();
        if (HttpPacket.isHttp((Object)message)) {
            HttpContent httpContent = (HttpContent)message;
            Request serviceRequest = (Request)this.httpRequestInProcessAttr.get((AttributeStorage)connection);
            if (serviceRequest == null) {
                HttpRequestPacket request = (HttpRequestPacket)httpContent.getHttpHeader();
                HttpResponsePacket response = request.getResponse();
                serviceRequest = Request.create();
                this.httpRequestInProcessAttr.set((AttributeStorage)connection, (Object)serviceRequest);
                Response serviceResponse = Response.create();
                serviceRequest.initialize(serviceResponse, request, ctx, this);
                SuspendStatus suspendStatus = new SuspendStatus();
                serviceResponse.initialize(serviceRequest, response, ctx, this.suspendedResponseQueue, suspendStatus);
                HttpServerProbeNotifier.notifyRequestReceive(this, connection, serviceRequest);
                try {
                    ctx.setMessage((Object)serviceResponse);
                    HttpRequestProcessor httpServiceLocal = this.httpService;
                    if (httpServiceLocal == null) return ctx.getStopAction();
                    httpServiceLocal.doService(serviceRequest, serviceResponse);
                    return ctx.getStopAction();
                }
                catch (Throwable t) {
                    serviceRequest.getRequest().getProcessingState().setError(true);
                    if (response.isCommitted()) return ctx.getStopAction();
                    ByteBuffer b = HtmlHelper.getExceptionErrorPage("Internal Server Error", "Grizzly/2.0", t);
                    serviceResponse.reset();
                    serviceResponse.setStatus(HttpStatus.INTERNAL_SERVER_ERROR_500);
                    serviceResponse.setContentType("text/html");
                    serviceResponse.setCharacterEncoding("UTF-8");
                    MemoryManager mm = ctx.getConnection().getTransport().getMemoryManager();
                    Buffer buf = Buffers.wrap((MemoryManager)mm, (ByteBuffer)b);
                    serviceResponse.getOutputBuffer().writeBuffer(buf);
                    return ctx.getStopAction();
                }
                finally {
                    if (suspendStatus.get()) {
                        if (!serviceRequest.asyncInput()) return ctx.getSuspendAction();
                        return ctx.getSuspendingStopAction();
                    }
                    this.afterService(connection, serviceRequest, serviceResponse);
                }
            } else {
                if (!serviceRequest.asyncInput()) return ctx.getStopAction();
                if (!serviceRequest.getInputBuffer().isFinished()) {
                    Buffer content = httpContent.getContent();
                    if (!(content.hasRemaining() && serviceRequest.getInputBuffer().append(content) || httpContent.isLast())) {
                        return ctx.getStopAction();
                    }
                    if (httpContent.isLast()) {
                        serviceRequest.getInputBuffer().finished();
                        NextAction action = ctx.getSuspendAction();
                        ctx.recycle();
                        return action;
                    }
                }
                httpContent.recycle();
            }
            return ctx.getStopAction();
        } else {
            Response response = (Response)message;
            Request request = response.getRequest();
            this.afterService(connection, request, response);
        }
        return ctx.getStopAction();
    }

    public void exceptionOccurred(FilterChainContext ctx, Throwable error) {
        ReadHandler handler;
        Connection c = ctx.getConnection();
        Request request = (Request)this.httpRequestInProcessAttr.get((AttributeStorage)c);
        if (request != null && (handler = request.getInputBuffer().getReadHandler()) != null) {
            handler.onError(error);
        }
    }

    public JmxMonitoringConfig<HttpServerProbe> getMonitoringConfig() {
        return this.monitoringConfig;
    }

    protected JmxObject createJmxManagementObject() {
        return new org.glassfish.grizzly.http.server.jmx.HttpServerFilter(this);
    }

    private void afterService(Connection connection, Request request, Response response) throws IOException {
        this.httpRequestInProcessAttr.remove((AttributeStorage)connection);
        response.finish();
        request.onAfterService();
        HttpServerProbeNotifier.notifyRequestComplete(this, connection, response);
        response.recycle();
        request.recycle();
    }
}

