/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.server.filecache.jmx;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.GmbalMBean;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;
import org.glassfish.grizzly.http.server.filecache.FileCacheEntry;
import org.glassfish.grizzly.http.server.filecache.FileCacheProbe;
import org.glassfish.grizzly.monitoring.jmx.GrizzlyJmxManager;
import org.glassfish.grizzly.monitoring.jmx.JmxObject;

@ManagedObject
@Description(value="Static file caching implementation.  There will be one FileCache instance per NetworkListener.")
public class FileCache
extends JmxObject {
    private final org.glassfish.grizzly.http.server.filecache.FileCache fileCache;
    private final AtomicInteger cachedEntryCount = new AtomicInteger();
    private final AtomicLong cacheHitCount = new AtomicLong();
    private final AtomicLong cacheMissCount = new AtomicLong();
    private final AtomicInteger cacheErrorCount = new AtomicInteger();
    private final JMXFileCacheProbe fileCacheProbe = new JMXFileCacheProbe();

    public FileCache(org.glassfish.grizzly.http.server.filecache.FileCache fileCache) {
        this.fileCache = fileCache;
    }

    public String getJmxName() {
        return "FileCache";
    }

    protected void onRegister(GrizzlyJmxManager mom, GmbalMBean bean) {
        this.fileCache.getMonitoringConfig().addProbes((Object[])new FileCacheProbe[]{this.fileCacheProbe});
    }

    protected void onUnregister(GrizzlyJmxManager mom) {
        this.fileCache.getMonitoringConfig().removeProbes((Object[])new FileCacheProbe[]{this.fileCacheProbe});
    }

    @ManagedAttribute(id="file-cache-enabled")
    @Description(value="Indicates whether or not the file cache is enabled.")
    public boolean isFileCacheEnabled() {
        return this.fileCache.isEnabled();
    }

    @ManagedAttribute(id="max-age-seconds")
    @Description(value="The maximum age, in seconds, a resource may be cached.")
    public int getSecondsMaxAge() {
        return this.fileCache.getSecondsMaxAge();
    }

    @ManagedAttribute(id="max-number-of-cache-entries")
    @Description(value="The maxumim number of entries that may exist in the cache.")
    public int getMaxCacheEntries() {
        return this.fileCache.getMaxCacheEntries();
    }

    @ManagedAttribute(id="min-entry-size")
    @Description(value="The maximum size, in bytes, a file must be in order to be cached in the heap cache.")
    public long getMinEntrySize() {
        return this.fileCache.getMinEntrySize();
    }

    @ManagedAttribute(id="max-entry-size")
    @Description(value="The maximum size, in bytes, a resource may be before it can no longer be considered cachable.")
    public long getMaxEntrySize() {
        return this.fileCache.getMaxEntrySize();
    }

    @ManagedAttribute(id="memory-mapped-file-cache-size")
    @Description(value="The maximum size, in bytes, of the memory mapped cache for large files.")
    public long getMaxLargeFileCacheSize() {
        return this.fileCache.getMaxLargeFileCacheSize();
    }

    @ManagedAttribute(id="heap-file-cache-size")
    @Description(value="The maximum size, in bytes, of the heap cache for files below the water mark set by min-entry-size.")
    public long getMaxSmallFileCacheSize() {
        return this.fileCache.getMaxSmallFileCacheSize();
    }

    @ManagedAttribute(id="cached-entries-count")
    @Description(value="The current cached entry count.")
    public int getCachedEntryCount() {
        return this.cachedEntryCount.get();
    }

    @ManagedAttribute(id="cache-hit-count")
    @Description(value="The total number of cache hits.")
    public long getCacheHitCount() {
        return this.cacheHitCount.get();
    }

    @ManagedAttribute(id="cache-miss-count")
    @Description(value="The total number of cache misses.")
    public long getCacheMissCount() {
        return this.cacheMissCount.get();
    }

    @ManagedAttribute(id="cache-error-count")
    @Description(value="The total number of cache errors.")
    public int getCacheErrorCount() {
        return this.cacheErrorCount.get();
    }

    @ManagedAttribute(id="heap-cache-size-in-bytes")
    @Description(value="The current size, in bytes, of the heap memory cache.")
    public long getHeapMemoryInBytes() {
        return this.fileCache.getHeapCacheSize();
    }

    @ManagedAttribute(id="mapped-memory-cache-size-in-bytes")
    @Description(value="The current size, in bytes, of the mapped memory cache.")
    public long getMappedMemorytInBytes() {
        return this.fileCache.getMappedCacheSize();
    }

    private final class JMXFileCacheProbe
    implements FileCacheProbe {
        private JMXFileCacheProbe() {
        }

        @Override
        public void onEntryAddedEvent(org.glassfish.grizzly.http.server.filecache.FileCache fileCache, FileCacheEntry entry) {
            FileCache.this.cachedEntryCount.incrementAndGet();
        }

        @Override
        public void onEntryRemovedEvent(org.glassfish.grizzly.http.server.filecache.FileCache fileCache, FileCacheEntry entry) {
            FileCache.this.cachedEntryCount.decrementAndGet();
        }

        @Override
        public void onEntryHitEvent(org.glassfish.grizzly.http.server.filecache.FileCache fileCache, FileCacheEntry entry) {
            FileCache.this.cacheHitCount.incrementAndGet();
        }

        @Override
        public void onEntryMissedEvent(org.glassfish.grizzly.http.server.filecache.FileCache fileCache, String host, String requestURI) {
            FileCache.this.cacheMissCount.incrementAndGet();
        }

        @Override
        public void onErrorEvent(org.glassfish.grizzly.http.server.filecache.FileCache fileCache, Throwable error) {
            FileCache.this.cacheErrorCount.incrementAndGet();
        }
    }
}

