/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.server.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.ReadResult;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.server.io.ReadHandler;
import org.glassfish.grizzly.http.util.Charsets;
import org.glassfish.grizzly.memory.CompositeBuffer;
import org.glassfish.grizzly.memory.MemoryManager;

public class InputBuffer {
    private HttpRequestPacket request;
    private FilterChainContext ctx;
    private boolean processingChars;
    private boolean closed;
    private CompositeBuffer compositeBuffer;
    private Connection connection;
    private int markPos = -1;
    private int readAheadLimit = -1;
    private int readCount = 0;
    private String encoding = "ISO-8859-1";
    private CharsetDecoder decoder;
    private ByteBuffer remainder;
    private boolean contentRead;
    private ReadHandler handler;
    private int requestedSize;
    private boolean asyncEnabled;
    private final CharBuffer singleCharBuf = CharBuffer.allocate(1);
    private float averageCharsPerByte = 1.0f;
    private final Object lock = new Object();

    public void initialize(HttpRequestPacket request, FilterChainContext ctx) {
        if (request == null) {
            throw new IllegalArgumentException("request cannot be null.");
        }
        if (ctx == null) {
            throw new IllegalArgumentException("ctx cannot be null.");
        }
        this.request = request;
        this.ctx = ctx;
        this.connection = ctx.getConnection();
        this.compositeBuffer = CompositeBuffer.newBuffer((MemoryManager)this.connection.getTransport().getMemoryManager());
        this.compositeBuffer.allowBufferDispose(true);
        this.compositeBuffer.allowInternalBuffersDispose(true);
        Object message = ctx.getMessage();
        if (message instanceof HttpContent) {
            HttpContent content = (HttpContent)message;
            if (content.getContent().hasRemaining()) {
                this.compositeBuffer.append((Object)content.getContent());
            }
            this.contentRead = content.isLast();
            content.recycle();
        }
    }

    public void recycle() {
        this.compositeBuffer.tryDispose();
        this.compositeBuffer = null;
        this.connection = null;
        this.decoder = null;
        this.remainder = null;
        this.ctx = null;
        this.handler = null;
        this.processingChars = false;
        this.closed = false;
        this.contentRead = false;
        this.markPos = -1;
        this.readAheadLimit = -1;
        this.requestedSize = -1;
        this.readCount = 0;
        this.averageCharsPerByte = 1.0f;
        this.encoding = "ISO-8859-1";
    }

    public void processingChars() throws IOException {
        this.processingChars = true;
        String enc = this.request.getCharacterEncoding();
        if (enc != null) {
            this.encoding = enc;
            CharsetDecoder localDecoder = this.getDecoder();
            this.averageCharsPerByte = localDecoder.averageCharsPerByte();
        }
    }

    public int readByte() throws IOException {
        if (this.closed) {
            throw new IOException();
        }
        if (!this.compositeBuffer.hasRemaining() && this.fill(1) == -1) {
            return -1;
        }
        if (this.readAheadLimit != -1) {
            ++this.readCount;
            if (this.readCount > this.readAheadLimit) {
                this.markPos = -1;
            }
        }
        return this.compositeBuffer.get();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException();
        }
        if (len == 0) {
            return 0;
        }
        if (!this.asyncEnabled && !this.compositeBuffer.hasRemaining()) {
            if (this.fill(len) == -1) {
                return -1;
            }
            if (this.compositeBuffer.remaining() < len) {
                this.fill(len);
            }
        }
        int nlen = Math.min(this.compositeBuffer.remaining(), len);
        if (this.readAheadLimit != -1) {
            this.readCount += nlen;
            if (this.readCount > this.readAheadLimit) {
                this.markPos = -1;
            }
        }
        this.compositeBuffer.get(b, off, nlen);
        this.compositeBuffer.shrink();
        return nlen;
    }

    public int available() {
        return this.closed ? 0 : this.compositeBuffer.remaining();
    }

    public Buffer getBuffer() {
        return this.compositeBuffer;
    }

    public ReadHandler getReadHandler() {
        return this.handler;
    }

    public int read(CharBuffer target) throws IOException {
        if (this.closed) {
            throw new IOException();
        }
        if (!this.processingChars) {
            throw new IllegalStateException();
        }
        if (target == null) {
            throw new IllegalArgumentException("target cannot be null.");
        }
        return this.fillChar(target.capacity(), target, !this.asyncEnabled, true);
    }

    public int readChar() throws IOException {
        if (this.closed) {
            throw new IOException();
        }
        if (!this.processingChars) {
            throw new IllegalStateException();
        }
        this.singleCharBuf.position(0);
        int read = this.read(this.singleCharBuf);
        if (read == -1) {
            return -1;
        }
        char c = this.singleCharBuf.get(0);
        this.singleCharBuf.position(0);
        return c;
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException();
        }
        if (!this.processingChars) {
            throw new IllegalStateException();
        }
        if (len == 0) {
            return 0;
        }
        CharBuffer buf = CharBuffer.wrap(cbuf, off, len);
        return this.read(buf);
    }

    public boolean ready() {
        if (this.closed) {
            return false;
        }
        if (!this.processingChars) {
            throw new IllegalStateException();
        }
        return this.remainder != null && this.remainder.hasRemaining() || this.compositeBuffer.hasRemaining() || this.request.isExpectContent();
    }

    public int availableChar() {
        float available = (float)this.compositeBuffer.remaining() * this.averageCharsPerByte;
        return Float.valueOf(available).intValue();
    }

    public void mark(int readAheadLimit) {
        if (this.processingChars) {
            throw new IllegalStateException();
        }
        if (readAheadLimit > 0) {
            this.markPos = this.compositeBuffer.position();
            this.readAheadLimit = readAheadLimit;
        }
    }

    public boolean markSupported() {
        if (this.processingChars) {
            throw new IllegalStateException();
        }
        return true;
    }

    public void reset() throws IOException {
        if (this.closed) {
            throw new IOException();
        }
        if (this.processingChars) {
            throw new IllegalStateException();
        }
        if (this.readAheadLimit == -1 && this.markPos == -1) {
            throw new IOException();
        }
        if (this.readAheadLimit != -1) {
            if (this.markPos == -1) {
                throw new IOException();
            }
            this.readCount = 0;
        }
        this.compositeBuffer.position(this.markPos);
    }

    public void close() throws IOException {
        this.closed = true;
    }

    public long skip(long n, boolean block) throws IOException {
        if (this.closed) {
            throw new IOException();
        }
        if (!block && n > (long)this.compositeBuffer.remaining()) {
            throw new IllegalStateException("Can not skip more bytes than available");
        }
        if (!this.processingChars) {
            if (n <= 0L) {
                return 0L;
            }
            if (block) {
                if (!this.compositeBuffer.hasRemaining() && this.fill((int)n) == -1) {
                    return -1L;
                }
                if ((long)this.compositeBuffer.remaining() < n) {
                    this.fill((int)n);
                }
            }
            long nlen = Math.min((long)this.compositeBuffer.remaining(), n);
            this.compositeBuffer.position(this.compositeBuffer.position() + (int)nlen);
            this.compositeBuffer.shrink();
            return nlen;
        }
        if (n < 0L) {
            throw new IllegalArgumentException();
        }
        if (n == 0L) {
            return 0L;
        }
        CharBuffer skipBuffer = CharBuffer.allocate((int)n);
        if (this.fillChar((int)n, skipBuffer, block, true) == -1) {
            return 0L;
        }
        return Math.min((long)skipBuffer.remaining(), n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finished() {
        if (!this.contentRead) {
            this.contentRead = true;
            Object object = this.lock;
            synchronized (object) {
                if (this.handler != null) {
                    this.handler.onAllDataRead();
                    this.handler = null;
                }
            }
        }
    }

    public boolean isFinished() {
        return this.contentRead;
    }

    public boolean notifyAvailable(ReadHandler handler) {
        return this.notifyAvailable(handler, 0);
    }

    public boolean notifyAvailable(ReadHandler handler, int size) {
        int available;
        if (handler == null) {
            throw new IllegalArgumentException("handler cannot be null.");
        }
        if (size < 0) {
            throw new IllegalArgumentException("size cannot be negative");
        }
        if (this.closed) {
            return false;
        }
        int n = available = this.processingChars ? this.availableChar() : this.available();
        if (size == 0 && available == 0 && !this.isFinished()) {
            this.requestedSize = size;
            this.handler = handler;
            return true;
        }
        if (available >= size) {
            return false;
        }
        this.requestedSize = size;
        this.handler = handler;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean append(Buffer buffer) throws IOException {
        if (buffer == null) {
            return false;
        }
        if (this.closed) {
            buffer.dispose();
        } else {
            int addSize = buffer.remaining();
            if (addSize > 0) {
                this.compositeBuffer.append((Object)buffer);
                Object object = this.lock;
                synchronized (object) {
                    if (this.handler != null) {
                        int available;
                        int n = available = this.processingChars ? this.availableChar() : this.available();
                        if (available > this.requestedSize) {
                            ReadHandler localHandler = this.handler;
                            this.handler = null;
                            localHandler.onDataAvailable();
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    public boolean isAsyncEnabled() {
        return this.asyncEnabled;
    }

    public void setAsyncEnabled(boolean asyncEnabled) {
        this.asyncEnabled = asyncEnabled;
    }

    private int fill(int requestedLen) throws IOException {
        if (this.request.isExpectContent()) {
            int read;
            Buffer b;
            for (read = 0; read < requestedLen && this.request.isExpectContent(); read += b.remaining()) {
                ReadResult rr = this.ctx.read();
                HttpContent c = (HttpContent)rr.getMessage();
                b = c.getContent();
                this.compositeBuffer.append((Object)b);
                rr.recycle();
                c.recycle();
            }
            return read;
        }
        return -1;
    }

    private int fillChar(int requestedLen, CharBuffer dst, boolean block, boolean flip) throws IOException {
        boolean hasRemainder;
        boolean bl = hasRemainder = this.remainder != null && this.remainder.hasRemaining();
        if (hasRemainder || this.compositeBuffer.hasRemaining() || !block) {
            CharsetDecoder decoderLocal = this.getDecoder();
            int charPos = dst.position();
            ByteBuffer bb = hasRemainder ? this.remainder : this.compositeBuffer.toByteBuffer();
            int bbPos = bb.position();
            CoderResult result = decoderLocal.decode(bb, dst, false);
            int readChars = dst.position() - charPos;
            int readBytes = bb.position() - bbPos;
            bb.position(bbPos);
            if (result == CoderResult.UNDERFLOW) {
                if (!hasRemainder) {
                    this.compositeBuffer.position(this.compositeBuffer.position() + readBytes);
                    this.compositeBuffer.shrink();
                } else {
                    this.remainder = null;
                }
            } else if (hasRemainder) {
                this.remainder.position(this.remainder.position() + readBytes);
            } else {
                this.compositeBuffer.position(this.compositeBuffer.position() + readBytes);
                this.compositeBuffer.shrink();
            }
            if (this.compositeBuffer.hasRemaining() && readChars < requestedLen) {
                readChars += this.fillChar(0, dst, false, false);
            }
            if (flip) {
                dst.flip();
            }
            return readChars;
        }
        if (this.request.isExpectContent()) {
            int read = 0;
            CharsetDecoder decoderLocal = this.getDecoder();
            boolean isNeedMoreInput = false;
            boolean last = false;
            while (read < requestedLen && this.request.isExpectContent()) {
                if (isNeedMoreInput || !this.compositeBuffer.hasRemaining()) {
                    ReadResult rr = this.ctx.read();
                    HttpContent c = (HttpContent)rr.getMessage();
                    this.compositeBuffer.append((Object)c.getContent());
                    last = c.isLast();
                    rr.recycle();
                    c.recycle();
                    isNeedMoreInput = false;
                }
                ByteBuffer bytes = this.compositeBuffer.toByteBuffer();
                int bytesPos = bytes.position();
                int dstPos = dst.position();
                CoderResult result = decoderLocal.decode(bytes, dst, false);
                int producesChars = dst.position() - dstPos;
                int consumedBytes = bytes.position() - bytesPos;
                read += producesChars;
                if (consumedBytes > 0) {
                    bytes.position(bytesPos);
                    this.compositeBuffer.position(this.compositeBuffer.position() + consumedBytes);
                    this.compositeBuffer.shrink();
                } else {
                    isNeedMoreInput = true;
                }
                if (!last && result != CoderResult.OVERFLOW) continue;
                break;
            }
            if (flip) {
                dst.flip();
            }
            if (last && read == 0) {
                read = -1;
            }
            return read;
        }
        return -1;
    }

    private CharsetDecoder getDecoder() {
        if (this.decoder == null) {
            Charset cs = Charsets.lookupCharset((String)this.encoding);
            this.decoder = cs.newDecoder();
            this.decoder.onMalformedInput(CodingErrorAction.REPLACE);
            this.decoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        }
        return this.decoder;
    }
}

