/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.server;

public final class SuspendStatus {
    private State state = State.NOT_SUSPENDED;
    private Thread initThread = Thread.currentThread();

    public void suspend() {
        if (this.state != State.NOT_SUSPENDED) {
            throw new IllegalStateException("Can not suspend. Expected suspend state='" + (Object)((Object)State.NOT_SUSPENDED) + "' but was '" + (Object)((Object)this.state) + "'");
        }
        if (this.initThread != Thread.currentThread()) {
            throw new IllegalStateException("Can not suspend. Processing can be suspended in the HttpHandler.service() thread only.");
        }
        this.state = State.SUSPENDED;
    }

    public boolean getAndInvalidate() {
        boolean wasSuspended = this.state == State.SUSPENDED;
        this.state = State.INVALIDATED;
        this.initThread = null;
        return wasSuspended;
    }

    private static enum State {
        NOT_SUSPENDED,
        SUSPENDED,
        INVALIDATED;

    }
}

