/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.server;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.PortRange;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.attributes.AttributeBuilder;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChain;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.http.ContentEncoding;
import org.glassfish.grizzly.http.EncodingFilter;
import org.glassfish.grizzly.http.GZipContentEncoding;
import org.glassfish.grizzly.http.HttpServerFilter;
import org.glassfish.grizzly.http.LZMAContentEncoding;
import org.glassfish.grizzly.http.server.AddOn;
import org.glassfish.grizzly.http.server.CompressionEncodingFilter;
import org.glassfish.grizzly.http.server.CompressionLevel;
import org.glassfish.grizzly.http.server.FileCacheFilter;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.HttpHandlerChain;
import org.glassfish.grizzly.http.server.NetworkListener;
import org.glassfish.grizzly.http.server.ServerConfiguration;
import org.glassfish.grizzly.http.server.ServerFilterConfiguration;
import org.glassfish.grizzly.http.server.StaticHttpHandler;
import org.glassfish.grizzly.http.server.filecache.FileCache;
import org.glassfish.grizzly.http.server.jmx.JmxEventListener;
import org.glassfish.grizzly.monitoring.MonitoringConfig;
import org.glassfish.grizzly.monitoring.jmx.GrizzlyJmxManager;
import org.glassfish.grizzly.monitoring.jmx.JmxMonitoringConfig;
import org.glassfish.grizzly.monitoring.jmx.JmxObject;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.rcm.ResourceAllocationFilter;
import org.glassfish.grizzly.ssl.SSLContextConfigurator;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.glassfish.grizzly.ssl.SSLFilter;
import org.glassfish.grizzly.threadpool.DefaultWorkerThread;
import org.glassfish.grizzly.utils.DelayedExecutor;
import org.glassfish.grizzly.utils.IdleTimeoutFilter;

public class HttpServer {
    private static final Logger LOGGER = Grizzly.logger(HttpServer.class);
    private final ServerConfiguration serverConfig = new ServerConfiguration(this);
    private boolean started;
    private final HttpHandlerChain httpHandlerChain = new HttpHandlerChain(this);
    private final Map<String, NetworkListener> listeners = new HashMap<String, NetworkListener>(2);
    private volatile ExecutorService auxExecutorService;
    private volatile DelayedExecutor delayedExecutor;
    protected volatile GrizzlyJmxManager jmxManager;
    protected volatile JmxObject managementObject;

    public final ServerConfiguration getServerConfiguration() {
        return this.serverConfig;
    }

    public void addListener(NetworkListener listener) {
        block5: {
            if (!this.started) {
                this.listeners.put(listener.getName(), listener);
            } else {
                this.configureListener(listener);
                if (!listener.isStarted()) {
                    try {
                        listener.start();
                    }
                    catch (IOException ioe) {
                        if (!LOGGER.isLoggable(Level.SEVERE)) break block5;
                        LOGGER.log(Level.SEVERE, "Failed to start listener [{0}] : {1}", new Object[]{listener.toString(), ioe.toString()});
                        LOGGER.log(Level.SEVERE, ioe.toString(), ioe);
                    }
                }
            }
        }
    }

    public NetworkListener getListener(String name) {
        return this.listeners.get(name);
    }

    public Collection<NetworkListener> getListeners() {
        return Collections.unmodifiableMap(this.listeners).values();
    }

    public NetworkListener removeListener(String name) {
        NetworkListener listener;
        block3: {
            listener = this.listeners.remove(name);
            if (listener != null && listener.isStarted()) {
                try {
                    listener.stop();
                }
                catch (IOException ioe) {
                    if (!LOGGER.isLoggable(Level.SEVERE)) break block3;
                    LOGGER.log(Level.SEVERE, "Failed to stop listener [{0}] : {1}", new Object[]{listener.toString(), ioe.toString()});
                    LOGGER.log(Level.SEVERE, ioe.toString(), ioe);
                }
            }
        }
        return listener;
    }

    DelayedExecutor getDelayedExecutor() {
        return this.delayedExecutor;
    }

    public synchronized void start() throws IOException {
        if (this.started) {
            return;
        }
        this.started = true;
        this.configureAuxThreadPool();
        this.delayedExecutor = new DelayedExecutor(this.auxExecutorService);
        this.delayedExecutor.start();
        for (NetworkListener listener : this.listeners.values()) {
            this.configureListener(listener);
            try {
                listener.start();
            }
            catch (IOException ioe) {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.log(Level.FINEST, "Failed to start listener [{0}] : {1}", new Object[]{listener.toString(), ioe.toString()});
                    LOGGER.log(Level.FINEST, ioe.toString(), ioe);
                }
                throw ioe;
            }
        }
        if (this.serverConfig.isJmxEnabled()) {
            this.enableJMX();
        }
        this.setupHttpHandler();
        if (this.serverConfig.isJmxEnabled()) {
            for (JmxEventListener l : this.serverConfig.getJmxEventListeners()) {
                l.jmxEnabled();
            }
        }
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.log(Level.INFO, "[{0}] Started.", this.getServerConfiguration().getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupHttpHandler() {
        this.serverConfig.addJmxEventListener(this.httpHandlerChain);
        Object object = this.serverConfig.handlersSync;
        synchronized (object) {
            for (HttpHandler httpHandler : this.serverConfig.orderedHandlers) {
                String[] mappings = this.serverConfig.handlers.get(httpHandler);
                this.httpHandlerChain.addHandler(httpHandler, mappings);
            }
        }
        this.httpHandlerChain.start();
    }

    private void tearDownHttpHandler() {
        this.httpHandlerChain.destroy();
    }

    public HttpHandler getHttpHandler() {
        return this.httpHandlerChain;
    }

    public boolean isStarted() {
        return this.started;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JmxObject getManagementObject(boolean clear) {
        Object object;
        if (!clear && this.managementObject == null) {
            object = this.serverConfig;
            synchronized (object) {
                if (this.managementObject == null) {
                    this.managementObject = new org.glassfish.grizzly.http.server.jmx.HttpServer(this);
                }
            }
        }
        try {
            object = this.managementObject;
            return object;
        }
        finally {
            if (clear) {
                this.managementObject = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() {
        if (!this.started) {
            return;
        }
        this.started = false;
        try {
            String[] names;
            if (this.serverConfig.isJmxEnabled()) {
                for (JmxEventListener l : this.serverConfig.getJmxEventListeners()) {
                    l.jmxDisabled();
                }
            }
            this.tearDownHttpHandler();
            for (String name : names = this.listeners.keySet().toArray(new String[this.listeners.size()])) {
                this.removeListener(name);
            }
            this.delayedExecutor.stop();
            this.delayedExecutor = null;
            this.stopAuxThreadPool();
            if (this.serverConfig.isJmxEnabled()) {
                this.disableJMX();
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, null, e);
        }
        finally {
            for (NetworkListener listener : this.listeners.values()) {
                Processor p = listener.getTransport().getProcessor();
                if (!(p instanceof FilterChain)) continue;
                ((FilterChain)p).clear();
            }
        }
        for (NetworkListener listener : this.listeners.values()) {
            Processor p = listener.getTransport().getProcessor();
            if (!(p instanceof FilterChain)) continue;
            ((FilterChain)p).clear();
        }
    }

    public static HttpServer createSimpleServer() {
        return HttpServer.createSimpleServer(".");
    }

    public static HttpServer createSimpleServer(String path) {
        return HttpServer.createSimpleServer(path, 8080);
    }

    public static HttpServer createSimpleServer(String path, int port) {
        return HttpServer.createSimpleServer(path, "0.0.0.0", port);
    }

    public static HttpServer createSimpleServer(String path, PortRange range) {
        return HttpServer.createSimpleServer(path, "0.0.0.0", range);
    }

    public static HttpServer createSimpleServer(String path, SocketAddress socketAddress) {
        InetSocketAddress inetAddr = (InetSocketAddress)socketAddress;
        return HttpServer.createSimpleServer(path, inetAddr.getHostName(), inetAddr.getPort());
    }

    public static HttpServer createSimpleServer(String path, String host, int port) {
        return HttpServer.createSimpleServer(path, host, new PortRange(port));
    }

    public static HttpServer createSimpleServer(String path, String host, PortRange range) {
        HttpServer server = new HttpServer();
        ServerConfiguration config = server.getServerConfiguration();
        if (path != null) {
            config.addHttpHandler(new StaticHttpHandler(new String[]{path}), "/");
        }
        NetworkListener listener = new NetworkListener("grizzly", host, range);
        server.addListener(listener);
        return server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enableJMX() {
        if (this.jmxManager == null) {
            ServerConfiguration serverConfiguration = this.serverConfig;
            synchronized (serverConfiguration) {
                if (this.jmxManager == null) {
                    this.jmxManager = GrizzlyJmxManager.instance();
                }
            }
        }
        this.jmxManager.registerAtRoot(this.getManagementObject(false), this.serverConfig.getName());
    }

    protected void disableJMX() {
        if (this.jmxManager != null) {
            this.jmxManager.deregister(this.getManagementObject(true));
        }
    }

    private void configureListener(NetworkListener listener) {
        FilterChain chain = listener.getFilterChain();
        if (chain == null) {
            FilterChainBuilder builder = FilterChainBuilder.stateless();
            builder.add((Filter)new TransportFilter());
            builder.add((Filter)new IdleTimeoutFilter(this.delayedExecutor, (long)listener.getKeepAlive().getIdleTimeoutInSeconds(), TimeUnit.SECONDS));
            if (listener.isSecure()) {
                SSLEngineConfigurator sslConfig = listener.getSslEngineConfig();
                if (sslConfig == null) {
                    sslConfig = new SSLEngineConfigurator(SSLContextConfigurator.DEFAULT_CONFIG, false, false, false);
                    listener.setSSLEngineConfig(sslConfig);
                }
                SSLFilter filter = new SSLFilter(sslConfig, null);
                builder.add((Filter)filter);
            }
            int maxHeaderSize = listener.getMaxHttpHeaderSize() == -1 ? 8192 : listener.getMaxHttpHeaderSize();
            HttpServerFilter httpServerFilter = new HttpServerFilter(listener.isChunkingEnabled(), maxHeaderSize, null, listener.getKeepAlive(), null, listener.getMaxRequestHeaders(), listener.getMaxResponseHeaders());
            Set<ContentEncoding> contentEncodings = this.configureCompressionEncodings(listener);
            for (ContentEncoding contentEncoding : contentEncodings) {
                httpServerFilter.addContentEncoding(contentEncoding);
            }
            if (listener.isRcmSupportEnabled()) {
                builder.add((Filter)new ResourceAllocationFilter());
            }
            httpServerFilter.getMonitoringConfig().addProbes(this.serverConfig.getMonitoringConfig().getHttpConfig().getProbes());
            builder.add((Filter)httpServerFilter);
            FileCache fileCache = listener.getFileCache();
            fileCache.initialize(listener.getTransport().getMemoryManager(), this.delayedExecutor);
            FileCacheFilter fileCacheFilter = new FileCacheFilter(fileCache);
            fileCache.getMonitoringConfig().addProbes(this.serverConfig.getMonitoringConfig().getFileCacheConfig().getProbes());
            builder.add((Filter)fileCacheFilter);
            ServerFilterConfiguration config = new ServerFilterConfiguration(this.serverConfig);
            org.glassfish.grizzly.http.server.HttpServerFilter webServerFilter = new org.glassfish.grizzly.http.server.HttpServerFilter(config, this.delayedExecutor);
            if (listener.isSendFileExplicitlyConfigured()) {
                config.setSendFileEnabled(listener.isSendFileEnabled());
            }
            if (listener.getScheme() != null) {
                config.setScheme(listener.getScheme());
            }
            config.setTraceEnabled(config.isTraceEnabled() || listener.isTraceEnabled());
            webServerFilter.setHttpHandler(this.httpHandlerChain);
            webServerFilter.getMonitoringConfig().addProbes(this.serverConfig.getMonitoringConfig().getWebServerConfig().getProbes());
            builder.add((Filter)webServerFilter);
            AddOn[] addons = (AddOn[])listener.getAddOnSet().getArray();
            if (addons != null) {
                for (AddOn addon : addons) {
                    addon.setup(listener, builder);
                }
            }
            chain = builder.build();
            listener.setFilterChain(chain);
        }
        this.configureMonitoring(listener);
    }

    protected Set<ContentEncoding> configureCompressionEncodings(NetworkListener listener) {
        CompressionLevel compressionLevel;
        String mode = listener.getCompression();
        int compressionMinSize = listener.getCompressionMinSize();
        try {
            compressionLevel = CompressionLevel.getCompressionLevel(mode);
        }
        catch (IllegalArgumentException e) {
            try {
                compressionLevel = CompressionLevel.ON;
                compressionMinSize = Integer.parseInt(mode);
            }
            catch (Exception ignore) {
                compressionLevel = CompressionLevel.OFF;
            }
        }
        String compressableMimeTypesString = listener.getCompressableMimeTypes();
        String noCompressionUserAgentsString = listener.getNoCompressionUserAgents();
        String[] compressableMimeTypes = compressableMimeTypesString != null ? compressableMimeTypesString.split(",") : new String[]{};
        String[] noCompressionUserAgents = noCompressionUserAgentsString != null ? noCompressionUserAgentsString.split(",") : new String[]{};
        GZipContentEncoding gzipContentEncoding = new GZipContentEncoding(512, 512, (EncodingFilter)new CompressionEncodingFilter(compressionLevel, compressionMinSize, compressableMimeTypes, noCompressionUserAgents, GZipContentEncoding.getGzipAliases()));
        LZMAContentEncoding lzmaEncoding = new LZMAContentEncoding((EncodingFilter)new CompressionEncodingFilter(compressionLevel, compressionMinSize, compressableMimeTypes, noCompressionUserAgents, LZMAContentEncoding.getLzmaAliases()));
        HashSet<ContentEncoding> set = new HashSet<ContentEncoding>(2);
        set.add((ContentEncoding)gzipContentEncoding);
        set.add((ContentEncoding)lzmaEncoding);
        return set;
    }

    private void configureMonitoring(NetworkListener listener) {
        TCPNIOTransport transport = listener.getTransport();
        JmxMonitoringConfig transportMonitoringCfg = transport.getMonitoringConfig();
        MonitoringConfig connectionMonitoringCfg = transport.getConnectionMonitoringConfig();
        JmxMonitoringConfig memoryMonitoringCfg = transport.getMemoryManager().getMonitoringConfig();
        MonitoringConfig threadPoolMonitoringCfg = transport.getThreadPoolMonitoringConfig();
        transportMonitoringCfg.clearProbes();
        connectionMonitoringCfg.clearProbes();
        memoryMonitoringCfg.clearProbes();
        threadPoolMonitoringCfg.clearProbes();
        transportMonitoringCfg.addProbes(this.serverConfig.getMonitoringConfig().getTransportConfig().getProbes());
        connectionMonitoringCfg.addProbes(this.serverConfig.getMonitoringConfig().getConnectionConfig().getProbes());
        memoryMonitoringCfg.addProbes(this.serverConfig.getMonitoringConfig().getMemoryConfig().getProbes());
        threadPoolMonitoringCfg.addProbes(this.serverConfig.getMonitoringConfig().getThreadPoolConfig().getProbes());
    }

    private void configureAuxThreadPool() {
        final AtomicInteger threadCounter = new AtomicInteger();
        this.auxExecutorService = Executors.newCachedThreadPool(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                DefaultWorkerThread newThread = new DefaultWorkerThread(AttributeBuilder.DEFAULT_ATTRIBUTE_BUILDER, HttpServer.this.serverConfig.getName() + "-" + threadCounter.getAndIncrement(), null, r);
                newThread.setDaemon(true);
                return newThread;
            }
        });
    }

    private void stopAuxThreadPool() {
        ExecutorService localThreadPool = this.auxExecutorService;
        this.auxExecutorService = null;
        if (localThreadPool != null) {
            localThreadPool.shutdownNow();
        }
    }

    synchronized void onAddHttpHandler(HttpHandler httpHandler, String[] mapping) {
        if (this.isStarted()) {
            this.httpHandlerChain.addHandler(httpHandler, mapping);
        }
    }

    synchronized void onRemoveHttpHandler(HttpHandler httpHandler) {
        if (this.isStarted()) {
            this.httpHandlerChain.removeHttpHandler(httpHandler);
        }
    }
}

