/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2010-2013 Oracle and/or its affiliates. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License.  You can
 * obtain a copy of the License at
 * https://glassfish.dev.java.net/public/CDDL+GPL_1_1.html
 * or packager/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at packager/legal/LICENSE.txt.
 *
 * GPL Classpath Exception:
 * Oracle designates this particular file as subject to the "Classpath"
 * exception as provided by Oracle in the GPL Version 2 section of the License
 * file that accompanied this code.
 *
 * Modifications:
 * If applicable, add the following below the License Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyright [year] [name of copyright owner]"
 *
 * Contributor(s):
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

package org.glassfish.grizzly.http.server.filecache;

import java.nio.ByteBuffer;

/**
 * The entry value in the file cache map.
 *
 * @author Alexey Stashok
 */
public final class FileCacheEntry implements Runnable {

    public FileCacheKey key;
    public String host;
    public String requestURI;
    public long lastModified = -1;
    public String contentType;
    public ByteBuffer bb;
    public String xPoweredBy;
    public FileCache.CacheType type;
    public String date;
    public String Etag;
    public String lastModifiedHeader;
    public long contentLength = -1;
    public long fileSize = -1;
    public String server;

    public volatile long timeoutMillis;

    private final FileCache fileCache;

    public FileCacheEntry(FileCache fileCache) {
        this.fileCache = fileCache;
    }

    @Override
    public void run() {
        fileCache.remove(this);
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder();
        sb.append("FileCacheEntry");
        sb.append("{host='").append(host).append('\'');
        sb.append(", requestURI='").append(requestURI).append('\'');
        sb.append(", lastModified=").append(lastModified);
        sb.append(", contentType='").append(contentType).append('\'');
        sb.append(", type=").append(type);
        sb.append(", contentLength=").append(contentLength);
        sb.append(", fileSize=").append(fileSize);
        sb.append(", timeoutMillis=").append(timeoutMillis);
        sb.append(", fileCache=").append(fileCache);
        sb.append(", server=").append(server);
        sb.append('}');
        return sb.toString();
    }
}
