/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.server;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.PortRange;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChain;
import org.glassfish.grizzly.http.HttpCodecFilter;
import org.glassfish.grizzly.http.KeepAlive;
import org.glassfish.grizzly.http.server.AddOn;
import org.glassfish.grizzly.http.server.HttpServerFilter;
import org.glassfish.grizzly.http.server.filecache.FileCache;
import org.glassfish.grizzly.monitoring.jmx.JmxObject;
import org.glassfish.grizzly.nio.transport.TCPNIOServerConnection;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.nio.transport.TCPNIOTransportBuilder;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.glassfish.grizzly.utils.ArraySet;

public class NetworkListener {
    private static final Logger LOGGER = Grizzly.logger(NetworkListener.class);
    public static final String DEFAULT_NETWORK_HOST = "0.0.0.0";
    public static final int DEFAULT_NETWORK_PORT = 8080;
    private String host = "0.0.0.0";
    private int port = 8080;
    private PortRange portRange;
    private final String name;
    private final KeepAlive keepAliveConfig = new KeepAlive();
    private FilterChain filterChain;
    private TCPNIOTransport transport = TCPNIOTransportBuilder.newInstance().build();
    private boolean secure;
    private final ArraySet<AddOn> addons = new ArraySet(AddOn.class);
    private boolean chunkingEnabled = true;
    private SSLEngineConfigurator sslEngineConfig;
    private int maxHttpHeaderSize = -1;
    private String compression;
    private final FileCache fileCache = new FileCache();
    private volatile int maxPendingBytes = -1;
    private boolean paused;
    private HttpServerFilter httpServerFilter;
    private HttpCodecFilter httpCodecFilter;
    private boolean rcmSupportEnabled;
    private boolean authPassthroughEnabled;
    private int maxPostSize;
    private String compressableMimeTypes;
    private String noCompressionUserAgents;
    private int compressionMinSize;
    private String restrictedUserAgents;
    private int uploadTimeout;
    private boolean disableUploadTimeout;
    private boolean traceEnabled;
    private String uriEncoding;
    private int transactionTimeout;
    private Boolean sendFileEnabled;

    public NetworkListener(String name) {
        NetworkListener.validateArg("name", name);
        this.name = name;
    }

    public NetworkListener(String name, String host) {
        this(name, host, 8080);
    }

    public NetworkListener(String name, String host, int port) {
        NetworkListener.validateArg("name", name);
        NetworkListener.validateArg("host", name);
        if (port < 0) {
            throw new IllegalArgumentException("Invalid port");
        }
        this.name = name;
        this.host = host;
        this.port = port;
    }

    public NetworkListener(String name, String host, PortRange portRange) {
        NetworkListener.validateArg("name", name);
        NetworkListener.validateArg("host", name);
        this.name = name;
        this.host = host;
        this.port = -1;
        this.portRange = portRange;
    }

    public String getName() {
        return this.name;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public PortRange getPortRange() {
        return this.portRange;
    }

    public KeepAlive getKeepAlive() {
        return this.keepAliveConfig;
    }

    public TCPNIOTransport getTransport() {
        return this.transport;
    }

    public void setTransport(TCPNIOTransport transport) {
        if (transport == null) {
            return;
        }
        if (!transport.isStopped()) {
            return;
        }
        this.transport = transport;
    }

    public AddOn[] getAddOns() {
        return (AddOn[])this.addons.obtainArrayCopy();
    }

    protected ArraySet<AddOn> getAddOnSet() {
        return this.addons;
    }

    public boolean registerAddOn(AddOn addon) {
        return this.addons.add((Object)addon);
    }

    public boolean deregisterAddOn(AddOn addon) {
        return this.addons.remove((Object)addon);
    }

    public boolean isChunkingEnabled() {
        return this.chunkingEnabled;
    }

    public void setChunkingEnabled(boolean chunkingEnabled) {
        this.chunkingEnabled = chunkingEnabled;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        if (!this.transport.isStopped()) {
            return;
        }
        this.secure = secure;
    }

    public SSLEngineConfigurator getSslEngineConfig() {
        return this.sslEngineConfig;
    }

    public void setSSLEngineConfig(SSLEngineConfigurator sslEngineConfig) {
        if (!this.transport.isStopped()) {
            return;
        }
        this.sslEngineConfig = sslEngineConfig;
    }

    public String getCompression() {
        return this.compression;
    }

    public void setCompression(String compression) {
        this.compression = compression;
    }

    public int getMaxHttpHeaderSize() {
        return this.maxHttpHeaderSize;
    }

    public void setMaxHttpHeaderSize(int maxHttpHeaderSize) {
        if (!this.transport.isStopped()) {
            return;
        }
        this.maxHttpHeaderSize = maxHttpHeaderSize;
    }

    public FilterChain getFilterChain() {
        return this.filterChain;
    }

    public void setFilterChain(FilterChain filterChain) {
        if (!this.transport.isStopped()) {
            return;
        }
        if (filterChain != null) {
            this.filterChain = filterChain;
        }
    }

    public FileCache getFileCache() {
        return this.fileCache;
    }

    public int getMaxPendingBytes() {
        return this.maxPendingBytes;
    }

    public void setMaxPendingBytes(int maxPendingBytes) {
        this.maxPendingBytes = maxPendingBytes;
        this.transport.getAsyncQueueIO().getWriter().setMaxPendingBytesPerConnection(maxPendingBytes);
    }

    public boolean isPaused() {
        return this.paused;
    }

    public boolean isStarted() {
        return !this.transport.isStopped();
    }

    public synchronized void start() throws IOException {
        if (!this.transport.isStopped()) {
            return;
        }
        if (this.filterChain == null) {
            throw new IllegalStateException("No FilterChain available.");
        }
        this.transport.setProcessor((Processor)this.filterChain);
        TCPNIOServerConnection serverConnection = this.port != -1 ? this.transport.bind(this.host, this.port) : this.transport.bind(this.host, this.portRange, this.transport.getServerConnectionBackLog());
        this.port = ((InetSocketAddress)serverConnection.getLocalAddress()).getPort();
        this.transport.start();
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.log(Level.INFO, "Started listener bound to [{0}]", this.host + ':' + this.port);
        }
    }

    public synchronized void stop() throws IOException {
        if (this.transport.isStopped()) {
            return;
        }
        this.transport.stop();
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.log(Level.INFO, "Stopped listener bound to [{0}]", this.host + ':' + this.port);
        }
    }

    public synchronized void pause() throws IOException {
        if (this.transport.isStopped() || this.transport.isPaused()) {
            return;
        }
        this.transport.pause();
        this.paused = true;
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.log(Level.INFO, "Paused listener bound to [{0}]", this.host + ':' + this.port);
        }
    }

    public synchronized void resume() throws IOException {
        if (this.transport.isStopped() || !this.transport.isPaused()) {
            return;
        }
        this.transport.resume();
        this.paused = false;
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.log(Level.INFO, "Resumed listener bound to [{0}]", this.host + ':' + this.port);
        }
    }

    public String toString() {
        return "NetworkListener{name='" + this.name + '\'' + ", host='" + this.host + '\'' + ", port=" + this.port + ", secure=" + this.secure + '}';
    }

    public JmxObject createManagementObject() {
        return new org.glassfish.grizzly.http.server.jmx.NetworkListener(this);
    }

    public HttpServerFilter getHttpServerFilter() {
        if (this.httpServerFilter == null) {
            for (Filter f : this.filterChain) {
                if (!(f instanceof HttpServerFilter)) continue;
                this.httpServerFilter = (HttpServerFilter)f;
                break;
            }
        }
        return this.httpServerFilter;
    }

    public HttpCodecFilter getHttpCodecFilter() {
        if (this.httpCodecFilter == null) {
            for (Filter f : this.filterChain) {
                if (!(f instanceof HttpCodecFilter)) continue;
                this.httpCodecFilter = (HttpCodecFilter)f;
                break;
            }
        }
        return this.httpCodecFilter;
    }

    private static void validateArg(String name, String value) {
        if (value == null || value.length() == 0) {
            throw new IllegalArgumentException("Argument " + name + " cannot be " + (value == null ? "null" : "have a zero length"));
        }
    }

    public boolean isRcmSupportEnabled() {
        return this.rcmSupportEnabled;
    }

    public void setRcmSupportEnabled(boolean enabled) {
        this.rcmSupportEnabled = enabled;
    }

    public boolean isAuthPassthroughEnabled() {
        return this.authPassthroughEnabled;
    }

    public void setAuthPassthroughEnabled(boolean authPassthroughEnabled) {
        this.authPassthroughEnabled = authPassthroughEnabled;
    }

    public String getCompressableMimeTypes() {
        return this.compressableMimeTypes;
    }

    public void setCompressableMimeTypes(String compressableMimeTypes) {
        this.compressableMimeTypes = compressableMimeTypes;
    }

    public int getCompressionMinSize() {
        return this.compressionMinSize;
    }

    public void setCompressionMinSize(int compressionMinSize) {
        this.compressionMinSize = compressionMinSize;
    }

    public boolean isDisableUploadTimeout() {
        return this.disableUploadTimeout;
    }

    public void setDisableUploadTimeout(boolean disableUploadTimeout) {
        this.disableUploadTimeout = disableUploadTimeout;
    }

    public int getMaxPostSize() {
        return this.maxPostSize;
    }

    public void setMaxPostSize(int maxPostSize) {
        this.maxPostSize = maxPostSize;
    }

    public String getNoCompressionUserAgents() {
        return this.noCompressionUserAgents;
    }

    public void setNoCompressionUserAgents(String noCompressionUserAgents) {
        this.noCompressionUserAgents = noCompressionUserAgents;
    }

    public String getRestrictedUserAgents() {
        return this.restrictedUserAgents;
    }

    public void setRestrictedUserAgents(String restrictedUserAgents) {
        this.restrictedUserAgents = restrictedUserAgents;
    }

    public boolean isTraceEnabled() {
        return this.traceEnabled;
    }

    public void setTraceEnabled(boolean traceEnabled) {
        this.traceEnabled = traceEnabled;
    }

    public int getUploadTimeout() {
        return this.uploadTimeout;
    }

    public void setUploadTimeout(int uploadTimeout) {
        this.uploadTimeout = uploadTimeout;
    }

    public String getUriEncoding() {
        return this.uriEncoding;
    }

    public void setUriEncoding(String uriEncoding) {
        this.uriEncoding = uriEncoding;
    }

    public int getTransactionTimeout() {
        return this.transactionTimeout;
    }

    public void setTransactionTimeout(int transactionTimeout) {
        this.transactionTimeout = transactionTimeout;
    }

    public boolean isSendFileEnabled() {
        return this.sendFileEnabled;
    }

    public void setSendFileEnabled(boolean sendFileEnabled) {
        this.sendFileEnabled = sendFileEnabled;
    }

    boolean isSendFileExplicitlyConfigured() {
        return this.sendFileEnabled != null;
    }
}

