/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.server;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.WriteHandler;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.http.Method;
import org.glassfish.grizzly.http.io.NIOOutputStream;
import org.glassfish.grizzly.http.server.FileCacheFilter;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Response;
import org.glassfish.grizzly.http.server.StaticHttpHandlerBase;
import org.glassfish.grizzly.http.server.filecache.FileCache;
import org.glassfish.grizzly.http.util.Header;
import org.glassfish.grizzly.http.util.HttpStatus;
import org.glassfish.grizzly.memory.BufferArray;
import org.glassfish.grizzly.memory.MemoryManager;

public class CLStaticHttpHandler
extends StaticHttpHandlerBase {
    private static final Logger LOGGER = Grizzly.logger(CLStaticHttpHandler.class);
    private final ClassLoader classLoader;

    public CLStaticHttpHandler(ClassLoader classLoader) {
        if (classLoader == null) {
            throw new IllegalArgumentException("ClassLoader can not be null");
        }
        this.classLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    protected boolean handle(String resourcePath, Request request, Response response) throws Exception {
        URL url;
        boolean found = false;
        File fileResource = null;
        if (resourcePath.startsWith("/")) {
            resourcePath = resourcePath.substring(1);
        }
        if ((url = this.classLoader.getResource(resourcePath)) == null) {
            url = this.classLoader.getResource(resourcePath + "/index.html");
            found = url != null;
        } else if ("file".equals(url.getProtocol())) {
            File file = new File(url.toURI());
            if (file.exists()) {
                if (file.isDirectory()) {
                    File welcomeFile = new File(file, "/index.html");
                    if (welcomeFile.exists() && welcomeFile.isFile()) {
                        fileResource = welcomeFile;
                        found = true;
                    }
                } else {
                    fileResource = file;
                    found = true;
                }
            }
        } else {
            found = true;
        }
        if (!found) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Resource not found {0}", resourcePath);
            }
            return false;
        }
        assert (url != null);
        if (!Method.GET.equals(request.getMethod())) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Resource found {0}, but HTTP method {1} is not allowed", new Object[]{resourcePath, request.getMethod()});
            }
            response.setStatus(HttpStatus.METHOD_NOT_ALLOWED_405);
            response.setHeader(Header.Allow, "GET");
            return true;
        }
        if (fileResource != null) {
            CLStaticHttpHandler.pickupContentType(response, fileResource.getPath());
            this.addToFileCache(request, response, fileResource);
            CLStaticHttpHandler.sendFile(response, fileResource);
        } else {
            CLStaticHttpHandler.pickupContentType(response, url.getPath());
            if ("jar".equals(url.getProtocol())) {
                File jarFile = this.getJarFile(url.getPath());
                this.addTimeStampEntryToFileCache(request, response, jarFile);
            }
            CLStaticHttpHandler.sendResource(response, url.openStream());
        }
        return true;
    }

    private static void sendResource(Response response, InputStream input) throws IOException {
        response.setStatus(HttpStatus.OK_200);
        response.addDateHeader(Header.Date, System.currentTimeMillis());
        int chunkSize = 8192;
        response.suspend();
        NIOOutputStream outputStream = response.getNIOOutputStream();
        outputStream.notifyCanWrite((WriteHandler)new NonBlockingDownloadHandler(response, outputStream, input, 8192));
    }

    private boolean addTimeStampEntryToFileCache(Request req, Response res, File archive) {
        FileCache fileCache;
        FilterChainContext fcContext;
        FileCacheFilter fileCacheFilter;
        if (this.isFileCacheEnabled() && (fileCacheFilter = this.lookupFileCache(fcContext = req.getContext())) != null && (fileCache = fileCacheFilter.getFileCache()).isEnabled()) {
            if (res != null) {
                CLStaticHttpHandler.addCachingHeaders(res, archive);
            }
            fileCache.add(req.getRequest(), archive.lastModified());
            return true;
        }
        return false;
    }

    private File getJarFile(String path) throws MalformedURLException, FileNotFoundException {
        int protocolIdx = path.indexOf(":");
        int jarDelimIdx = path.indexOf("!/");
        if (protocolIdx == -1 || jarDelimIdx == -1) {
            throw new MalformedURLException("Either protocol or jar file delimeter were not found");
        }
        File file = new File(path.substring(protocolIdx + 1, jarDelimIdx));
        if (!file.exists() || !file.isFile()) {
            throw new FileNotFoundException("Jar file was not found");
        }
        return file;
    }

    private static class NonBlockingDownloadHandler
    implements WriteHandler {
        private final Response response;
        private final NIOOutputStream outputStream;
        private final InputStream inputStream;
        private final MemoryManager mm;
        private final int chunkSize;

        NonBlockingDownloadHandler(Response response, NIOOutputStream outputStream, InputStream inputStream, int chunkSize) {
            this.response = response;
            this.outputStream = outputStream;
            this.inputStream = inputStream;
            this.mm = response.getRequest().getContext().getMemoryManager();
            this.chunkSize = chunkSize;
        }

        public void onWritePossible() throws Exception {
            LOGGER.log(Level.FINE, "[onWritePossible]");
            boolean isWriteMore = this.sendChunk();
            if (isWriteMore) {
                this.outputStream.notifyCanWrite((WriteHandler)this);
            }
        }

        public void onError(Throwable t) {
            LOGGER.log(Level.FINE, "[onError] ", t);
            this.response.setStatus(500, t.getMessage());
            this.complete(true);
        }

        private boolean sendChunk() throws IOException {
            Buffer buffer = null;
            if (!this.mm.willAllocateDirect(this.chunkSize)) {
                int len;
                buffer = this.mm.allocate(this.chunkSize);
                if (!buffer.isComposite()) {
                    len = this.inputStream.read(buffer.array(), buffer.position() + buffer.arrayOffset(), this.chunkSize);
                } else {
                    BufferArray bufferArray = buffer.toBufferArray();
                    int size = bufferArray.size();
                    Buffer[] buffers = (Buffer[])bufferArray.getArray();
                    int lenCounter = 0;
                    for (int i = 0; i < size; ++i) {
                        Buffer subBuffer = buffers[i];
                        int subBufferLen = subBuffer.remaining();
                        int justReadLen = this.inputStream.read(subBuffer.array(), subBuffer.position() + subBuffer.arrayOffset(), subBufferLen);
                        if (justReadLen > 0) {
                            lenCounter += justReadLen;
                        }
                        if (justReadLen < subBufferLen) break;
                    }
                    bufferArray.restore();
                    bufferArray.recycle();
                    int n = len = lenCounter > 0 ? lenCounter : -1;
                }
                if (len > 0) {
                    buffer.position(buffer.position() + len);
                } else {
                    buffer.dispose();
                    buffer = null;
                }
            } else {
                byte[] buf = new byte[this.chunkSize];
                int len = this.inputStream.read(buf);
                if (len > 0) {
                    buffer = this.mm.allocate(len);
                    buffer.put(buf);
                }
            }
            if (buffer == null) {
                this.complete(false);
                return false;
            }
            buffer.allowBufferDispose(true);
            buffer.trim();
            this.outputStream.write(buffer);
            return true;
        }

        private void complete(boolean isError) {
            block7: {
                block6: {
                    try {
                        this.inputStream.close();
                    }
                    catch (IOException e) {
                        if (isError) break block6;
                        this.response.setStatus(500, e.getMessage());
                    }
                }
                try {
                    this.outputStream.close();
                }
                catch (IOException e) {
                    if (isError) break block7;
                    this.response.setStatus(500, e.getMessage());
                }
            }
            if (this.response.isSuspended()) {
                this.response.resume();
            } else {
                this.response.finish();
            }
        }
    }
}

