/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.server.http2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.glassfish.grizzly.filterchain.FilterChainEvent;
import org.glassfish.grizzly.http.Cookie;
import org.glassfish.grizzly.http.Method;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Session;
import org.glassfish.grizzly.http.server.http2.PushEvent;
import org.glassfish.grizzly.http.util.Header;
import org.glassfish.grizzly.http.util.MimeHeaders;

public final class PushBuilder {
    private static final Header[] REMOVE_HEADERS = new Header[]{Header.Cookie, Header.ETag, Header.IfModifiedSince, Header.IfNoneMatch, Header.IfRange, Header.IfUnmodifiedSince, Header.IfMatch, Header.LastModified, Header.Referer, Header.AcceptRanges, Header.Range, Header.AcceptRanges, Header.ContentRange, Header.Authorization, Header.ProxyAuthenticate, Header.ProxyAuthorization, Header.WWWAuthenticate};
    private static final Header[] CONDITIONAL_HEADERS = new Header[]{Header.IfModifiedSince, Header.IfNoneMatch, Header.IfRange, Header.IfUnmodifiedSince, Header.IfMatch};
    Method method = Method.GET;
    String queryString;
    String sessionId;
    boolean conditional;
    MimeHeaders headers;
    String path;
    String eTag;
    String lastModified;
    Request request;
    boolean sessionFromURL;
    List<Cookie> cookies;

    public PushBuilder(Request request) {
        Cookie[] responseCookies;
        int i;
        this.request = request;
        this.headers = new MimeHeaders();
        this.headers.copyFrom(request.getRequest().getHeaders());
        int len = CONDITIONAL_HEADERS.length;
        for (i = 0; i < len; ++i) {
            if (!this.headers.contains(CONDITIONAL_HEADERS[i])) continue;
            this.conditional = true;
            break;
        }
        len = REMOVE_HEADERS.length;
        for (i = 0; i < len; ++i) {
            this.headers.removeHeader(REMOVE_HEADERS[i]);
        }
        this.headers.setValue(Header.Referer).setString(this.composeReferrerHeader(request));
        Session session = request.getSession(false);
        if (session != null) {
            this.sessionId = session.getIdInternal();
        }
        if (this.sessionId == null) {
            this.sessionId = request.getRequestedSessionId();
        }
        this.sessionFromURL = request.isRequestedSessionIdFromURL();
        Cookie[] requestCookies = request.getCookies();
        if (requestCookies != null) {
            this.cookies = new ArrayList<Cookie>(Arrays.asList(requestCookies));
        }
        if ((responseCookies = request.getResponse().getCookies()) != null) {
            if (this.cookies == null) {
                this.cookies = new ArrayList<Cookie>(responseCookies.length);
            }
            for (Cookie c : responseCookies) {
                if (c.getMaxAge() > 0) {
                    this.cookies.add(new Cookie(c.getName(), c.getValue()));
                    continue;
                }
                int jlen = this.cookies.size();
                for (int j = 0; j < jlen; ++j) {
                    if (!this.cookies.get(j).getName().equals(c.getName())) continue;
                    this.cookies.remove(j);
                }
            }
        }
        if (this.cookies != null && !this.cookies.isEmpty()) {
            int len2 = this.cookies.size();
            for (int i2 = 0; i2 < len2; ++i2) {
                Cookie c;
                c = this.cookies.get(i2);
                this.headers.addValue(Header.Cookie).setString(c.asClientCookieString());
            }
        }
    }

    public PushBuilder method(Method method) {
        if (method == null) {
            throw new NullPointerException();
        }
        if (!Method.GET.equals(method) && !Method.HEAD.equals(method)) {
            throw new IllegalArgumentException();
        }
        this.method = method;
        return this;
    }

    public PushBuilder queryString(String queryString) {
        this.queryString = PushBuilder.validate(queryString);
        return this;
    }

    public PushBuilder sessionId(String sessionId) {
        this.sessionId = PushBuilder.validate(sessionId);
        return this;
    }

    public PushBuilder conditional(boolean conditional) {
        this.conditional = conditional;
        return this;
    }

    public PushBuilder setHeader(String name, String value) {
        if (PushBuilder.nameAndValueValid(name, value)) {
            this.headers.setValue(name).setString(value);
        }
        return this;
    }

    public PushBuilder addHeader(String name, String value) {
        if (PushBuilder.nameAndValueValid(name, value)) {
            this.headers.addValue(name).setString(value);
        }
        return this;
    }

    public PushBuilder removeHeader(String name) {
        if (PushBuilder.validValue(name) && !Header.Referer.getLowerCase().equals(name.toLowerCase())) {
            this.headers.removeHeader(name);
        }
        return this;
    }

    public PushBuilder path(String path) {
        this.path = PushBuilder.validate(path);
        return this;
    }

    public PushBuilder eTag(String eTag) {
        this.eTag = PushBuilder.validate(eTag);
        return this;
    }

    public PushBuilder lastModified(String lastModified) {
        this.lastModified = PushBuilder.validate(lastModified);
        return this;
    }

    public void push() {
        String pathLocal;
        if (this.path == null) {
            throw new IllegalStateException();
        }
        if (!this.request.isPushEnabled()) {
            return;
        }
        String string = pathLocal = this.path.charAt(0) == '/' ? this.path : this.request.getContextPath() + '/' + this.path;
        if (this.queryString != null) {
            pathLocal = pathLocal + (pathLocal.indexOf(63) != -1 ? '&' + this.queryString : '?' + this.queryString);
        }
        if (this.sessionId != null) {
            if (this.sessionFromURL) {
                pathLocal = pathLocal + ';' + this.request.getSessionCookieName() + '=' + this.sessionId;
            } else {
                this.headers.addValue(Header.Cookie).setString(new Cookie(this.request.getSessionCookieName(), this.sessionId).asClientCookieString());
            }
        }
        this.path = pathLocal;
        if (this.conditional) {
            if (this.eTag != null) {
                this.headers.addValue(Header.IfNoneMatch).setString(this.eTag);
            } else if (this.lastModified != null) {
                this.headers.addValue(Header.IfModifiedSince).setString(this.lastModified);
            }
        }
        this.request.getContext().notifyDownstream((FilterChainEvent)PushEvent.create(this));
        this.eTag = null;
        this.lastModified = null;
        this.path = null;
        this.headers.removeHeader(Header.IfNoneMatch);
        this.headers.removeHeader(Header.IfModifiedSince);
    }

    public Method getMethod() {
        return this.method;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public boolean isConditional() {
        return this.conditional;
    }

    public Iterable<String> getHeaderNames() {
        return this.headers.names();
    }

    public String getHeader(String name) {
        return this.headers.getHeader(name);
    }

    public String getPath() {
        return this.path;
    }

    public String getETag() {
        return this.eTag;
    }

    public String getLastModified() {
        return this.lastModified;
    }

    private static boolean nameAndValueValid(String name, String value) {
        return PushBuilder.validValue(name) && PushBuilder.validValue(value);
    }

    private static boolean validValue(String value) {
        return value != null && !value.isEmpty();
    }

    private static String validate(String value) {
        return PushBuilder.validValue(value) ? value : null;
    }

    private String composeReferrerHeader(Request request) {
        StringBuilder sb = new StringBuilder(64);
        String queryString = request.getQueryString();
        sb.append((CharSequence)request.getRequestURL());
        if (queryString != null) {
            sb.append('?').append(queryString);
        }
        return sb.toString();
    }
}

