/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.server;

import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Response;
import org.glassfish.grizzly.http.server.jmxbase.JmxEventListener;
import org.glassfish.grizzly.http.server.jmxbase.Monitorable;
import org.glassfish.grizzly.http.server.util.DispatcherHelper;
import org.glassfish.grizzly.http.server.util.Mapper;
import org.glassfish.grizzly.http.server.util.MappingData;
import org.glassfish.grizzly.http.util.DataChunk;
import org.glassfish.grizzly.http.util.HttpStatus;
import org.glassfish.grizzly.http.util.RequestURIRef;
import org.glassfish.grizzly.utils.DataStructures;

public class HttpHandlerChain
extends HttpHandler
implements JmxEventListener {
    private static final Logger LOGGER = Grizzly.logger(HttpHandlerChain.class);
    private final ConcurrentMap<String, HttpHandler> handlersByName = DataStructures.getConcurrentMap();
    private final ReentrantReadWriteLock mapperUpdateLock = new ReentrantReadWriteLock();
    private final ConcurrentMap<HttpHandler, String[]> handlers = DataStructures.getConcurrentMap();
    private final ConcurrentMap<HttpHandler, Object> monitors = DataStructures.getConcurrentMap();
    private int handlersCount;
    private volatile HttpHandler rootHttpHandler;
    private final Mapper mapper;
    private final DispatcherHelper dispatchHelper;
    private static final String LOCAL_HOST = "localhost";
    private boolean started;
    private final HttpServer httpServer;
    private boolean isRootConfigured = false;

    public HttpHandlerChain(HttpServer httpServer) {
        this.httpServer = httpServer;
        this.mapper = new Mapper();
        this.mapper.setDefaultHostName(LOCAL_HOST);
        this.dispatchHelper = new DispatchHelperImpl();
        this.setDecodeUrl(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void jmxEnabled() {
        this.mapperUpdateLock.readLock().lock();
        try {
            for (Map.Entry entry : this.handlers.entrySet()) {
                HttpHandler httpHandler = (HttpHandler)entry.getKey();
                if (!(httpHandler instanceof Monitorable)) continue;
                this.registerJmxForHandler(httpHandler);
            }
        }
        finally {
            this.mapperUpdateLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void jmxDisabled() {
        this.mapperUpdateLock.readLock().lock();
        try {
            for (Map.Entry entry : this.handlers.entrySet()) {
                HttpHandler httpHandler = (HttpHandler)entry.getKey();
                if (!(httpHandler instanceof Monitorable)) continue;
                this.deregisterJmxForHandler(httpHandler);
            }
        }
        finally {
            this.mapperUpdateLock.readLock().unlock();
        }
    }

    @Override
    boolean doHandle(Request request, Response response) throws Exception {
        block7: {
            try {
                HttpHandler rootHttpHandlerLocal = this.rootHttpHandler;
                if (rootHttpHandlerLocal != null) {
                    return rootHttpHandlerLocal.doHandle(request, response);
                }
                RequestURIRef uriRef = request.getRequest().getRequestURIRef();
                uriRef.setDefaultURIEncoding(this.getRequestURIEncoding());
                DataChunk decodedURI = uriRef.getDecodedRequestURIBC(this.isAllowEncodedSlash());
                MappingData mappingData = request.obtainMappingData();
                this.mapper.mapUriWithSemicolon(request.getRequest().serverName(), decodedURI, mappingData, 0);
                if (mappingData.context != null && mappingData.context instanceof HttpHandler) {
                    HttpHandler httpHandler = mappingData.wrapper != null ? (HttpHandler)mappingData.wrapper : (HttpHandler)mappingData.context;
                    HttpHandlerChain.updatePaths(request, mappingData);
                    return httpHandler.doHandle(request, response);
                }
                response.setStatus(HttpStatus.NOT_FOUND_404);
                this.customizedErrorPage(request, response);
            }
            catch (Exception t) {
                try {
                    response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR_500);
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, "Internal server error", t);
                    }
                }
                catch (Exception ex2) {
                    if (!LOGGER.isLoggable(Level.WARNING)) break block7;
                    LOGGER.log(Level.WARNING, "Unable to error page", ex2);
                }
            }
        }
        return true;
    }

    @Override
    public void service(Request request, Response response) throws Exception {
        throw new IllegalStateException("Method doesn't have to be called");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHandler(HttpHandler httpHandler, String[] mappings) {
        this.mapperUpdateLock.writeLock().lock();
        try {
            if (mappings.length == 0) {
                this.addHandler(httpHandler, new String[]{""});
            } else {
                String name;
                if (this.started) {
                    httpHandler.start();
                    if (httpHandler instanceof Monitorable) {
                        this.registerJmxForHandler(httpHandler);
                    }
                }
                if (this.handlers.put(httpHandler, mappings) == null) {
                    ++this.handlersCount;
                }
                if ((name = httpHandler.getName()) != null) {
                    this.handlersByName.put(name, httpHandler);
                }
                httpHandler.setDispatcherHelper(this.dispatchHelper);
                for (String mapping : mappings) {
                    String ctx = this.getContextPath(mapping);
                    String wrapper = this.getWrapperPath(ctx, mapping);
                    if (ctx.length() != 0) {
                        this.mapper.addContext(LOCAL_HOST, ctx, httpHandler, new String[]{"index.html", "index.htm"}, null);
                    } else if (!this.isRootConfigured && wrapper.startsWith("*.")) {
                        this.isRootConfigured = true;
                        HttpHandler a = new HttpHandler(){

                            @Override
                            public void service(Request request, Response response) {
                                try {
                                    this.customizedErrorPage(request, response);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        };
                        this.mapper.addContext(LOCAL_HOST, ctx, a, new String[]{"index.html", "index.htm"}, null);
                    } else {
                        this.mapper.addContext(LOCAL_HOST, ctx, httpHandler, new String[]{"index.html", "index.htm"}, null);
                    }
                    this.mapper.addWrapper(LOCAL_HOST, ctx, wrapper, httpHandler);
                }
                this.rootHttpHandler = this.handlersCount == 1 && mappings.length == 1 && ("".equals(mappings[0]) || "/".equals(mappings[0])) ? httpHandler : null;
            }
        }
        finally {
            this.mapperUpdateLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeHttpHandler(HttpHandler httpHandler) {
        if (httpHandler == null) {
            throw new IllegalStateException();
        }
        this.mapperUpdateLock.writeLock().lock();
        try {
            String[] mappings;
            String name = httpHandler.getName();
            if (name != null) {
                this.handlersByName.remove(name);
            }
            if ((mappings = (String[])this.handlers.remove(httpHandler)) != null) {
                for (String mapping : mappings) {
                    String ctx = this.getContextPath(mapping);
                    this.mapper.removeContext(LOCAL_HOST, ctx);
                }
                this.deregisterJmxForHandler(httpHandler);
                httpHandler.destroy();
                --this.handlersCount;
                if (this.handlersCount == 1) {
                    Map.Entry entry = this.handlers.entrySet().iterator().next();
                    HttpHandler lastHttpHandler = (HttpHandler)entry.getKey();
                    String[] lastHttpHandlerMappings = (String[])entry.getValue();
                    this.rootHttpHandler = lastHttpHandlerMappings.length == 1 && ("".equals(lastHttpHandlerMappings[0]) || "/".equals(lastHttpHandlerMappings[0])) ? httpHandler : null;
                } else {
                    this.rootHttpHandler = null;
                }
            }
            boolean bl = mappings != null;
            return bl;
        }
        finally {
            this.mapperUpdateLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllHttpHandlers() {
        this.mapperUpdateLock.writeLock().lock();
        try {
            for (HttpHandler handler : this.handlers.keySet()) {
                this.removeHttpHandler(handler);
            }
        }
        finally {
            this.mapperUpdateLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void start() {
        this.mapperUpdateLock.readLock().lock();
        try {
            for (Map.Entry entry : this.handlers.entrySet()) {
                HttpHandler httpHandler = (HttpHandler)entry.getKey();
                httpHandler.start();
            }
        }
        finally {
            this.mapperUpdateLock.readLock().unlock();
        }
        this.started = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void destroy() {
        this.mapperUpdateLock.readLock().lock();
        try {
            for (Map.Entry handler : this.handlers.entrySet()) {
                HttpHandler a = (HttpHandler)handler.getKey();
                a.destroy();
            }
        }
        finally {
            this.mapperUpdateLock.readLock().unlock();
        }
        this.started = false;
    }

    private void registerJmxForHandler(HttpHandler httpHandler) {
        Monitorable monitorable = (Monitorable)((Object)httpHandler);
        Object jmx = monitorable.createManagementObject();
        if (this.monitors.putIfAbsent(httpHandler, jmx) == null) {
            this.httpServer.jmxManager.register(this.httpServer.managementObject, jmx);
        }
    }

    private void deregisterJmxForHandler(HttpHandler httpHandler) {
        Object jmx = this.monitors.remove(httpHandler);
        if (jmx != null) {
            this.httpServer.jmxManager.deregister(jmx);
        }
    }

    private String getWrapperPath(String ctx, String mapping) {
        if (mapping.indexOf("*.") > 0) {
            return mapping.substring(mapping.lastIndexOf("/") + 1);
        }
        if (ctx.length() != 0) {
            return mapping.substring(ctx.length());
        }
        if (mapping.startsWith("//")) {
            return mapping.substring(1);
        }
        return mapping;
    }

    private String getContextPath(String mapping) {
        String ctx = "";
        int slash = mapping.indexOf("/", 1);
        ctx = slash != -1 ? mapping.substring(0, slash) : mapping;
        if (ctx.startsWith("/*.") || ctx.startsWith("*.")) {
            ctx = ctx.indexOf("/") == ctx.lastIndexOf("/") ? "" : ctx.substring(1);
        }
        if (ctx.startsWith("/*") || ctx.startsWith("*")) {
            ctx = "";
        }
        if (ctx.equals("/")) {
            ctx = "";
        }
        return ctx;
    }

    private final class DispatchHelperImpl
    implements DispatcherHelper {
        private DispatchHelperImpl() {
        }

        @Override
        public void mapPath(DataChunk host, DataChunk path, MappingData mappingData) throws Exception {
            HttpHandlerChain.this.mapper.map(host, path, mappingData);
        }

        @Override
        public void mapName(DataChunk name, MappingData mappingData) {
            String nameStr = name.toString();
            HttpHandler handler = (HttpHandler)HttpHandlerChain.this.handlersByName.get(nameStr);
            if (handler != null) {
                mappingData.wrapper = handler;
                mappingData.servletName = nameStr;
            }
        }
    }
}

