/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.server.util;

import java.io.IOException;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Response;
import org.glassfish.grizzly.http.util.HttpStatus;

public class HtmlHelper {
    private static final int MAX_STACK_ELEMENTS = 10;
    private static final String CSS = "div.header {font-family:Tahoma,Arial,sans-serif;color:white;background-color:#003300;font-size:22px;-moz-border-radius-topleft: 10px;border-top-left-radius: 10px;-moz-border-radius-topright: 10px;border-top-right-radius: 10px;padding-left: 5px}div.body {font-family:Tahoma,Arial,sans-serif;color:black;background-color:#FFFFCC;font-size:16px;padding-top:10px;padding-bottom:10px;padding-left:10px}div.footer {font-family:Tahoma,Arial,sans-serif;color:white;background-color:#666633;font-size:14px;-moz-border-radius-bottomleft: 10px;border-bottom-left-radius: 10px;-moz-border-radius-bottomright: 10px;border-bottom-right-radius: 10px;padding-left: 5px}BODY {font-family:Tahoma,Arial,sans-serif;color:black;background-color:white;}B {font-family:Tahoma,Arial,sans-serif;color:black;}A {color : black;}HR {color : #999966;}";
    private static CharBuffer reponseBuffer = CharBuffer.allocate(4096);
    private static CharsetEncoder encoder = Charset.forName("UTF-8").newEncoder();

    public static synchronized ByteBuffer getErrorPage(String headerMessage, String message, String serverName) throws IOException {
        String body = HtmlHelper.prepareBody(headerMessage, message, serverName);
        reponseBuffer.clear();
        reponseBuffer.put(body);
        reponseBuffer.flip();
        return encoder.encode(reponseBuffer);
    }

    public static synchronized ByteBuffer getExceptionErrorPage(String message, String serverName, Throwable t) throws IOException {
        String body = HtmlHelper.prepareExceptionBody(message, serverName, t);
        reponseBuffer.clear();
        reponseBuffer.put(body);
        reponseBuffer.flip();
        return encoder.encode(reponseBuffer);
    }

    public static void writeTraceMessage(Request request, Response response) throws IOException {
        response.setStatus(HttpStatus.OK_200);
        response.setContentType("message/http");
        Writer writer = response.getWriter();
        writer.append(request.getMethod().toString()).append(' ').append(request.getRequest().getRequestURIRef().getOriginalRequestURIBC().toString()).append(' ').append(request.getProtocol().getProtocolString()).append("\r\n");
        for (String headerName : request.getHeaderNames()) {
            for (String headerValue : request.getHeaders(headerName)) {
                writer.append(headerName).append(": ").append(headerValue).append("\r\n");
            }
        }
    }

    private static String prepareBody(String headerMessage, String message, String serverName) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html><head><title>");
        sb.append(serverName);
        sb.append("</title>");
        sb.append("<style><!--");
        sb.append(CSS);
        sb.append("--></style> ");
        sb.append("</head><body>");
        sb.append("<div class=\"header\">");
        sb.append(headerMessage);
        sb.append("</div>");
        sb.append("<div class=\"body\">");
        sb.append(message != null ? message : "<HR size=\"1\" noshade>");
        sb.append("</div>");
        sb.append("<div class=\"footer\">").append(serverName).append("</div>");
        sb.append("</body></html>");
        return sb.toString();
    }

    private static String prepareExceptionBody(String message, String serverName, Throwable t) {
        String exMessage;
        if (t == null) {
            throw new IllegalArgumentException();
        }
        Throwable rootCause = HtmlHelper.getRootCause(t);
        StackTraceElement[] elements = t.getStackTrace();
        StackTraceElement[] rootCauseElements = null;
        if (rootCause != null) {
            rootCauseElements = rootCause.getStackTrace();
        }
        StringBuilder tBuilder = new StringBuilder();
        HtmlHelper.formatStackElements(elements, tBuilder);
        StringBuilder rootBuilder = new StringBuilder();
        if (rootCause != null) {
            HtmlHelper.formatStackElements(rootCauseElements, rootBuilder);
        }
        if ((exMessage = t.getMessage()) == null) {
            exMessage = t.toString();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<html><head><title>");
        sb.append(serverName);
        sb.append("</title>");
        sb.append("<style><!--");
        sb.append(CSS);
        sb.append("--></style> ");
        sb.append("</head><body>");
        sb.append("<div class=\"header\">");
        sb.append(message);
        sb.append("</div>");
        sb.append("<div class=\"body\">");
        sb.append("<b>").append(exMessage).append("</b>");
        sb.append("<pre>");
        sb.append(tBuilder.toString());
        sb.append("</pre>");
        if (rootCause != null) {
            sb.append("<b>Root Cause: ").append(rootCause.toString()).append("</b>");
            sb.append("<pre>");
            sb.append(rootBuilder.toString());
            sb.append("</pre>");
        }
        sb.append("Please see the log for more detail.");
        sb.append("</div>");
        sb.append("<div class=\"footer\">").append(serverName).append("</div>");
        sb.append("</body></html>");
        return sb.toString();
    }

    private static Throwable getRootCause(Throwable t) {
        Throwable rootCause = null;
        if (t.getCause() != null) {
            rootCause = t.getCause();
            while (rootCause.getCause() != null) {
                rootCause = rootCause.getCause();
            }
        }
        return rootCause;
    }

    private static void formatStackElements(StackTraceElement[] elements, StringBuilder builder) {
        boolean ellipse;
        int maxLines = HtmlHelper.getMaxStackElementsToDisplay(elements);
        for (int i = 0; i < maxLines; ++i) {
            builder.append(i + 1 > 9 ? "    " : "     ").append(i + 1).append(": ").append(elements[i].toString()).append('\n');
        }
        boolean bl = ellipse = elements.length > 10;
        if (ellipse) {
            builder.append("        ... ").append(elements.length - 10).append(" more");
        }
    }

    private static int getMaxStackElementsToDisplay(StackTraceElement[] elements) {
        return elements.length > 10 ? 10 : elements.length;
    }
}

