/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.servlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.DispatcherType;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.http.Note;
import org.glassfish.grizzly.http.server.AfterServiceListener;
import org.glassfish.grizzly.http.server.ErrorPageGenerator;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Response;
import org.glassfish.grizzly.http.server.SessionManager;
import org.glassfish.grizzly.http.server.util.ClassLoaderUtil;
import org.glassfish.grizzly.http.server.util.DispatcherHelper;
import org.glassfish.grizzly.http.server.util.HtmlHelper;
import org.glassfish.grizzly.http.server.util.MappingData;
import org.glassfish.grizzly.http.util.CharChunk;
import org.glassfish.grizzly.http.util.Header;
import org.glassfish.grizzly.http.util.HttpRequestURIDecoder;
import org.glassfish.grizzly.http.util.HttpStatus;
import org.glassfish.grizzly.servlet.ExpectationHandler;
import org.glassfish.grizzly.servlet.FilterChainFactory;
import org.glassfish.grizzly.servlet.FilterChainImpl;
import org.glassfish.grizzly.servlet.FilterChainInvoker;
import org.glassfish.grizzly.servlet.HttpServletRequestImpl;
import org.glassfish.grizzly.servlet.HttpServletResponseImpl;
import org.glassfish.grizzly.servlet.ServletConfigImpl;
import org.glassfish.grizzly.servlet.ServletSessionManager;
import org.glassfish.grizzly.servlet.WebappContext;

public class ServletHandler
extends HttpHandler {
    private static final Logger LOGGER = Grizzly.logger(ServletHandler.class);
    static final Note<HttpServletRequestImpl> SERVLET_REQUEST_NOTE = Request.createNote((String)HttpServletRequestImpl.class.getName());
    static final Note<HttpServletResponseImpl> SERVLET_RESPONSE_NOTE = Request.createNote((String)HttpServletResponseImpl.class.getName());
    static final ServletAfterServiceListener servletAfterServiceListener = new ServletAfterServiceListener();
    protected String servletClassName;
    protected Class<? extends Servlet> servletClass;
    protected volatile Servlet servletInstance = null;
    private String contextPath = "";
    private final Object lock = new Object();
    private final WebappContext servletCtx;
    private ServletConfigImpl servletConfig;
    private SessionManager sessionManager = ServletSessionManager.instance();
    protected final Map<String, Object> properties = new HashMap<String, Object>();
    protected boolean initialize = true;
    protected ClassLoader classLoader;
    protected ExpectationHandler expectationHandler;
    protected FilterChainFactory filterChainFactory;
    private List<Runnable> onDestroyListeners;

    protected ServletHandler(ServletConfigImpl servletConfig) {
        this.servletConfig = servletConfig;
        this.servletCtx = (WebappContext)servletConfig.getServletContext();
    }

    public void start() {
        try {
            this.configureServletEnv();
        }
        catch (Throwable t) {
            LOGGER.log(Level.SEVERE, "start", t);
        }
    }

    protected boolean sendAcknowledgment(Request request, Response response) throws IOException {
        return this.expectationHandler != null || super.sendAcknowledgment(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(Request request, Response response) throws Exception {
        if (this.classLoader != null) {
            ClassLoader prevClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.classLoader);
            try {
                this.doServletService(request, response);
            }
            finally {
                Thread.currentThread().setContextClassLoader(prevClassLoader);
            }
        } else {
            this.doServletService(request, response);
        }
    }

    protected void doServletService(Request request, Response response) {
        try {
            FilterChainInvoker filterChain;
            String uri = request.getRequestURI();
            if (this.contextPath.length() > 0 && !uri.startsWith(this.contextPath)) {
                this.customizeErrorPage(response, "Resource Not Found", 404, null);
                return;
            }
            HttpServletRequestImpl servletRequest = HttpServletRequestImpl.create();
            HttpServletResponseImpl servletResponse = HttpServletResponseImpl.create();
            this.setPathData(request, servletRequest);
            servletRequest.initialize(request, servletResponse, this.servletCtx);
            servletResponse.initialize(response, servletRequest);
            request.setNote(SERVLET_REQUEST_NOTE, (Object)servletRequest);
            request.setNote(SERVLET_RESPONSE_NOTE, (Object)servletResponse);
            request.addAfterServiceListener((AfterServiceListener)servletAfterServiceListener);
            this.loadServlet();
            this.setDispatcherPath(request, this.getCombinedPath(servletRequest));
            servletResponse.addHeader(Header.Server.toString(), "grizzly/" + Grizzly.getDotedVersion());
            if (this.expectationHandler != null) {
                AckActionImpl ackAction = new AckActionImpl(response);
                this.expectationHandler.onExpectAcknowledgement(servletRequest, servletResponse, ackAction);
                if (!ackAction.isAcknowledged()) {
                    ackAction.acknowledge();
                } else if (ackAction.isFailAcknowledgement()) {
                    return;
                }
            }
            if ((filterChain = this.getFilterChain(request)) != null) {
                filterChain.invokeFilterChain((ServletRequest)servletRequest, (ServletResponse)servletResponse);
            } else {
                this.servletInstance.service((ServletRequest)servletRequest, (ServletResponse)servletResponse);
            }
            servletRequest.onAfterService();
        }
        catch (Throwable ex) {
            LOGGER.log(Level.SEVERE, "service exception:", ex);
            this.customizeErrorPage(response, "Internal Error", 500, ex);
        }
    }

    protected FilterChainInvoker getFilterChain(Request request) {
        if (this.filterChainFactory != null) {
            return this.filterChainFactory.createFilterChain(request, this.servletInstance, DispatcherType.REQUEST);
        }
        return null;
    }

    private void setDispatcherPath(Request request, String path) {
        request.setAttribute("org.apache.catalina.core.DISPATCHER_REQUEST_PATH", (Object)path);
    }

    private String getCombinedPath(HttpServletRequest request) {
        if (request.getServletPath() == null) {
            return null;
        }
        if (request.getPathInfo() == null) {
            return request.getServletPath();
        }
        return request.getServletPath() + request.getPathInfo();
    }

    protected void setPathData(Request from, HttpServletRequestImpl to) {
        MappingData data = from.obtainMappingData();
        to.setServletPath(data.wrapperPath.toString());
        to.setPathInfo(data.pathInfo.toString());
        to.setContextPath(data.contextPath.toString());
    }

    void doServletService(ServletRequest servletRequest, ServletResponse servletResponse, DispatcherType dispatcherType) throws IOException, ServletException {
        try {
            this.loadServlet();
            FilterChainImpl filterChain = this.filterChainFactory.createFilterChain(servletRequest, this.servletInstance, dispatcherType);
            if (filterChain != null) {
                filterChain.invokeFilterChain(servletRequest, servletResponse);
            } else {
                this.servletInstance.service(servletRequest, servletResponse);
            }
        }
        catch (ServletException se) {
            LOGGER.log(Level.SEVERE, "service exception:", se);
            throw se;
        }
        catch (IOException ie) {
            LOGGER.log(Level.SEVERE, "service exception:", ie);
            throw ie;
        }
    }

    public void customizeErrorPage(Response response, String message, int errorCode, Throwable t) {
        if (!response.isCommitted()) {
            try {
                HtmlHelper.setErrorAndSendErrorPage((Request)response.getRequest(), (Response)response, (ErrorPageGenerator)response.getErrorPageGenerator(), (int)errorCode, (String)message, (String)message, (Throwable)t);
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadServlet() throws ServletException {
        if (this.servletInstance == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.servletInstance == null) {
                    Servlet newServletInstance;
                    if (this.servletClassName != null) {
                        newServletInstance = (Servlet)ClassLoaderUtil.load((String)this.servletClassName);
                    } else {
                        try {
                            newServletInstance = this.servletClass.newInstance();
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                    LOGGER.log(Level.INFO, "Loading Servlet: {0}", newServletInstance.getClass().getName());
                    newServletInstance.init((ServletConfig)this.servletConfig);
                    this.servletInstance = newServletInstance;
                }
            }
        }
    }

    protected void configureServletEnv() throws ServletException {
        if (this.contextPath.length() > 0) {
            CharChunk cc = new CharChunk();
            char[] ch = this.contextPath.toCharArray();
            cc.setChars(ch, 0, ch.length);
            HttpRequestURIDecoder.normalizeChars((CharChunk)cc);
            this.contextPath = cc.toString();
        }
        if ("".equals(this.contextPath)) {
            this.contextPath = "";
        }
    }

    public Servlet getServletInstance() {
        return this.servletInstance;
    }

    protected void setServletInstance(Servlet servletInstance) {
        this.servletInstance = servletInstance;
    }

    protected void setServletClassName(String servletClassName) {
        this.servletClassName = servletClassName;
    }

    protected void setServletClass(Class<? extends Servlet> servletClass) {
        this.servletClass = servletClass;
    }

    protected void setSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        block14: {
            try {
                if (this.classLoader != null) {
                    ClassLoader prevClassLoader = Thread.currentThread().getContextClassLoader();
                    Thread.currentThread().setContextClassLoader(this.classLoader);
                    try {
                        super.destroy();
                        if (this.servletInstance != null) {
                            this.servletInstance.destroy();
                            this.servletInstance = null;
                        }
                        break block14;
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(prevClassLoader);
                    }
                }
                super.destroy();
            }
            finally {
                if (this.onDestroyListeners != null) {
                    for (int i = 0; i < this.onDestroyListeners.size(); ++i) {
                        try {
                            this.onDestroyListeners.get(i).run();
                            continue;
                        }
                        catch (Throwable t) {
                            LOGGER.log(Level.WARNING, "onDestroyListener error", t);
                        }
                    }
                    this.onDestroyListeners = null;
                }
            }
        }
    }

    protected WebappContext getServletCtx() {
        return this.servletCtx;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ServletConfigImpl getServletConfig() {
        return this.servletConfig;
    }

    public String getName() {
        return this.servletConfig.getServletName();
    }

    public ExpectationHandler getExpectationHandler() {
        return this.expectationHandler;
    }

    public void setExpectationHandler(ExpectationHandler expectationHandler) {
        this.expectationHandler = expectationHandler;
    }

    protected void setDispatcherHelper(DispatcherHelper dispatcherHelper) {
        this.servletCtx.setDispatcherHelper(dispatcherHelper);
    }

    protected void setFilterChainFactory(FilterChainFactory filterChainFactory) {
        this.filterChainFactory = filterChainFactory;
    }

    protected String getSessionCookieName() {
        return this.servletCtx.getSessionCookieConfig().getName();
    }

    protected SessionManager getSessionManager(Request request) {
        SessionManager sm = request.getHttpFilter().getConfiguration().getSessionManager();
        return sm != null ? sm : this.sessionManager;
    }

    void addOnDestroyListener(Runnable r) {
        if (this.onDestroyListeners == null) {
            this.onDestroyListeners = new ArrayList<Runnable>(2);
        }
        this.onDestroyListeners.add(r);
    }

    static HttpServletRequestImpl getServletRequest(Request request) {
        return (HttpServletRequestImpl)request.getNote(SERVLET_REQUEST_NOTE);
    }

    static HttpServletResponseImpl getServletResponse(Request request) {
        return (HttpServletResponseImpl)request.getNote(SERVLET_RESPONSE_NOTE);
    }

    static final class AckActionImpl
    implements ExpectationHandler.AckAction {
        private boolean isAcknowledged;
        private boolean isFailAcknowledgement;
        private final Response response;

        private AckActionImpl(Response response) {
            this.response = response;
        }

        @Override
        public void acknowledge() throws IOException {
            if (this.isAcknowledged) {
                throw new IllegalStateException("Already acknowledged");
            }
            this.isAcknowledged = true;
            this.response.setStatus(HttpStatus.CONINTUE_100);
            this.response.sendAcknowledgement();
        }

        @Override
        public void fail() throws IOException {
            if (this.isAcknowledged) {
                throw new IllegalStateException("Already acknowledged");
            }
            this.isAcknowledged = true;
            this.isFailAcknowledgement = true;
            this.response.setStatus(HttpStatus.EXPECTATION_FAILED_417);
            this.response.finish();
        }

        public boolean isAcknowledged() {
            return this.isAcknowledged;
        }

        public boolean isFailAcknowledgement() {
            return this.isFailAcknowledgement;
        }
    }

    static final class ServletAfterServiceListener
    implements AfterServiceListener {
        ServletAfterServiceListener() {
        }

        public void onAfterService(Request request) {
            HttpServletRequestImpl servletRequest = ServletHandler.getServletRequest(request);
            HttpServletResponseImpl servletResponse = ServletHandler.getServletResponse(request);
            if (servletRequest != null) {
                servletRequest.recycle();
                servletResponse.recycle();
            }
        }
    }
}

