/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http;

import java.io.UnsupportedEncodingException;
import org.glassfish.grizzly.http.util.DataChunk;

public enum Protocol {
    HTTP_0_9("HTTP/0.9"),
    HTTP_1_0("HTTP/1.0"),
    HTTP_1_1("HTTP/1.1");

    private final String protocolString;
    private byte[] protocolBytes;

    public static Protocol parseDataChunk(DataChunk protocolC) {
        if (protocolC.isNull() || protocolC.getLength() == 0) {
            return HTTP_0_9;
        }
        if (protocolC.equals(HTTP_1_1.getProtocolString())) {
            return HTTP_1_1;
        }
        if (protocolC.equals(HTTP_1_0.getProtocolString())) {
            return HTTP_1_0;
        }
        if (protocolC.equals(HTTP_0_9.getProtocolString())) {
            return HTTP_0_9;
        }
        throw new IllegalStateException("Unknown protocol " + protocolC.toString());
    }

    private Protocol(String protocolString) {
        this.protocolString = protocolString;
        try {
            this.protocolBytes = protocolString.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException ignored) {
            this.protocolBytes = protocolString.getBytes();
        }
    }

    public String getProtocolString() {
        return this.protocolString;
    }

    public byte[] getProtocolBytes() {
        return this.protocolBytes;
    }
}

