/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.util;

import java.io.CharConversionException;
import java.nio.charset.Charset;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.http.util.Charsets;
import org.glassfish.grizzly.http.util.DataChunk;
import org.glassfish.grizzly.http.util.HttpRequestURIDecoder;
import org.glassfish.grizzly.memory.Buffers;

public class RequestURIRef {
    private boolean isDecoded;
    private Charset decodedURIEncoding;
    private boolean wasSlashAllowed = true;
    private Charset defaultURIEncoding = Charsets.UTF8_CHARSET;
    private final DataChunk originalRequestURIBC = DataChunk.newInstance();
    private final DataChunk decodedRequestURIBC = DataChunk.newInstance();
    private Buffer preallocatedDecodedURIBuffer;

    public final DataChunk getOriginalRequestURIBC() {
        return this.originalRequestURIBC;
    }

    public final DataChunk getDecodedRequestURIBC() throws CharConversionException {
        return this.getDecodedRequestURIBC(this.wasSlashAllowed, this.defaultURIEncoding);
    }

    public final DataChunk getRequestURIBC() {
        if (this.isDecoded) {
            return this.decodedRequestURIBC;
        }
        return this.originalRequestURIBC;
    }

    public DataChunk getDecodedRequestURIBC(boolean isSlashAllowed) throws CharConversionException {
        return this.getDecodedRequestURIBC(isSlashAllowed, this.defaultURIEncoding);
    }

    public DataChunk getDecodedRequestURIBC(boolean isSlashAllowed, Charset charset) throws CharConversionException {
        if (this.isDecoded && isSlashAllowed == this.wasSlashAllowed && charset == this.decodedURIEncoding) {
            return this.decodedRequestURIBC;
        }
        this.checkDecodedURICapacity(this.originalRequestURIBC.getLength());
        this.decodedRequestURIBC.setBuffer(this.preallocatedDecodedURIBuffer, 0, this.preallocatedDecodedURIBuffer.limit());
        HttpRequestURIDecoder.decode(this.originalRequestURIBC, this.decodedRequestURIBC, isSlashAllowed, charset);
        this.isDecoded = true;
        this.wasSlashAllowed = isSlashAllowed;
        this.decodedURIEncoding = charset;
        return this.decodedRequestURIBC;
    }

    public String getURI() {
        return this.getURI(null);
    }

    public String getURI(Charset encoding) {
        return this.getRequestURIBC().toString(encoding);
    }

    public void setURI(String uri) {
        this.getRequestURIBC().setString(uri);
    }

    public final String getDecodedURI() throws CharConversionException {
        return this.getDecodedURI(this.wasSlashAllowed);
    }

    public final String getDecodedURI(boolean isSlashAllowed) throws CharConversionException {
        return this.getDecodedURI(isSlashAllowed, null);
    }

    public String getDecodedURI(boolean isSlashAllowed, Charset encoding) throws CharConversionException {
        this.getDecodedRequestURIBC(isSlashAllowed, encoding);
        String strValue = this.decodedRequestURIBC.toString();
        return strValue;
    }

    public void setDecodedURI(String uri) {
        this.decodedRequestURIBC.setString(uri);
        this.isDecoded = true;
    }

    public boolean isDecoded() {
        return this.isDecoded;
    }

    public void setDecoded(boolean isDecoded) {
        this.isDecoded = isDecoded;
    }

    public Charset getDefaultURIEncoding() {
        return this.defaultURIEncoding;
    }

    public void setDefaultURIEncoding(Charset defaultURIEncoding) {
        this.defaultURIEncoding = defaultURIEncoding;
    }

    public void recycle() {
        this.originalRequestURIBC.recycle();
        this.decodedRequestURIBC.recycle();
        this.isDecoded = false;
        this.wasSlashAllowed = true;
        this.decodedURIEncoding = null;
        this.defaultURIEncoding = Charsets.UTF8_CHARSET;
    }

    private void checkDecodedURICapacity(int size) {
        if (this.preallocatedDecodedURIBuffer == null) {
            this.preallocatedDecodedURIBuffer = Buffers.wrap(null, (byte[])new byte[size]);
        } else if (this.preallocatedDecodedURIBuffer.clear().remaining() < size) {
            this.preallocatedDecodedURIBuffer.dispose();
            this.preallocatedDecodedURIBuffer = Buffers.wrap(null, (byte[])new byte[size]);
        }
    }
}

