/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.web.arp;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.filterchain.StopAction;
import org.glassfish.grizzly.filterchain.SuspendAction;
import org.glassfish.grizzly.web.FileCache;
import org.glassfish.grizzly.web.ProcessorTask;
import org.glassfish.grizzly.web.TaskEvent;
import org.glassfish.grizzly.web.TaskListener;
import org.glassfish.grizzly.web.WebFilter;
import org.glassfish.grizzly.web.arp.AsyncWebFilterConfig;
import org.glassfish.grizzly.web.container.Adapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncWebFilter
extends WebFilter<AsyncWebFilterConfig>
implements TaskListener {
    public AsyncWebFilter(String name) {
        this(name, new AsyncWebFilterConfig());
    }

    public AsyncWebFilter(String name, AsyncWebFilterConfig config) {
        super(name, config);
    }

    @Override
    public NextAction handleRead(FilterChainContext ctx, NextAction nextAction) throws IOException {
        if (((AsyncWebFilterConfig)this.config).isAsyncEnabled()) {
            ProcessorTask processor = this.getProcessorTask(ctx);
            this.configureProcessorTask(processor, ctx);
            try {
                ((AsyncWebFilterConfig)this.config).getAsyncHandler().handle(processor);
            }
            catch (Throwable ex) {
                logger.log(Level.INFO, "Processor exception", ex);
                ctx.getConnection().close();
                return new StopAction();
            }
            return new SuspendAction();
        }
        return super.handleRead(ctx, nextAction);
    }

    @Override
    public void taskEvent(TaskEvent event) {
        if (event.getStatus() == 2 || event.getStatus() == 1) {
            ProcessorTask processor = (ProcessorTask)event.attachement();
            Connection connection = processor.getConnection();
            if (connection == null) {
                logger.log(Level.WARNING, "AsyncProtocolFilter invalid state.");
                return;
            }
            if (processor.isKeepAlive() && !processor.isError()) {
                FilterChainContext context = processor.getFilterChainContext();
                try {
                    context.setCurrentFilterIdx(context.getCurrentFilterIdx() + 1);
                    context.getProcessorRunnable().run();
                }
                catch (Exception e) {
                    try {
                        connection.close();
                    }
                    catch (IOException ee) {}
                }
            } else {
                try {
                    connection.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            processor.recycle();
        }
    }

    @Override
    protected void configureProcessorTask(ProcessorTask processorTask, FilterChainContext context) {
        super.configureProcessorTask(processorTask, context);
        if (((AsyncWebFilterConfig)this.config).isAsyncEnabled()) {
            processorTask.setEnableAsyncExecution(true);
            processorTask.setTaskListener(this);
            processorTask.setInputStream(context.getStreamReader());
            processorTask.setOutputStream(context.getStreamWriter());
        } else {
            processorTask.setEnableAsyncExecution(false);
        }
    }

    @Override
    protected ProcessorTask initializeProcessorTask(ProcessorTask task) {
        task = super.initializeProcessorTask(task);
        if (((AsyncWebFilterConfig)this.config).isAsyncEnabled()) {
            task.setEnableAsyncExecution(true);
            task.setAsyncHandler(((AsyncWebFilterConfig)this.config).getAsyncHandler());
        }
        return task;
    }

    @Override
    protected void displayConfiguration() {
        if (((AsyncWebFilterConfig)this.config).isDisplayConfiguration()) {
            FileCache fileCache = ((AsyncWebFilterConfig)this.config).getFileCache();
            Adapter adapter = ((AsyncWebFilterConfig)this.config).getAdapter();
            boolean isAsyncEnabled = ((AsyncWebFilterConfig)this.config).isAsyncEnabled();
            logger.log(Level.INFO, "\n Grizzly configuration\n\t name: " + this.name + "\n\t maxHttpHeaderSize: " + ((AsyncWebFilterConfig)this.config).getMaxHttpHeaderSize() + "\n\t maxKeepAliveRequests: " + ((AsyncWebFilterConfig)this.config).getMaxKeepAliveRequests() + "\n\t keepAliveTimeoutInSeconds: " + ((AsyncWebFilterConfig)this.config).getKeepAliveTimeoutInSeconds() + "\n\t Static File Cache enabled: " + (fileCache != null && fileCache.isEnabled()) + "\n\t Static resources directory: " + new File(((AsyncWebFilterConfig)this.config).getRootFolder()).getAbsolutePath() + "\n\t Adapter : " + (adapter == null ? null : adapter.getClass().getName()) + "\n\t Processing mode: " + (isAsyncEnabled ? "asynchronous" : "synchronous"));
        }
    }
}

