/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.web.arp;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.glassfish.grizzly.web.ProcessorTask;
import org.glassfish.grizzly.web.arp.AsyncExecutor;
import org.glassfish.grizzly.web.arp.AsyncFilter;
import org.glassfish.grizzly.web.arp.AsyncHandler;
import org.glassfish.grizzly.web.arp.AsyncTask;
import org.glassfish.grizzly.web.container.util.ClassLoaderUtil;

public class DefaultAsyncExecutor
implements AsyncExecutor {
    private static final String ASYNC_FILTER = "org.glassfish.grizzly.web.asyncFilters";
    private static String[] sharedAsyncFilters = null;
    private AsyncTask asyncProcessorTask;
    private ProcessorTask processorTask;
    private ArrayList<AsyncFilter> asyncFilters = new ArrayList();
    private AsyncHandler asyncHandler;

    public DefaultAsyncExecutor() {
        this.init();
    }

    private void init() {
        DefaultAsyncExecutor.loadFilters();
        if (sharedAsyncFilters != null) {
            for (String filterName : sharedAsyncFilters) {
                this.asyncFilters.add((AsyncFilter)ClassLoaderUtil.load(filterName));
            }
        }
    }

    public boolean preExecute() throws Exception {
        this.processorTask.preProcess();
        if (this.processorTask.parseRequest()) {
            this.finishResponse();
            return false;
        }
        return true;
    }

    public boolean interrupt() throws Exception {
        if (this.asyncFilters == null || this.asyncFilters.size() == 0) {
            this.execute();
            return false;
        }
        return this.invokeFilters();
    }

    public boolean execute() throws Exception {
        this.processorTask.invokeAdapter();
        return true;
    }

    private boolean invokeFilters() {
        AsyncFilter asf;
        boolean continueExec = true;
        Iterator<AsyncFilter> i$ = this.asyncFilters.iterator();
        while (i$.hasNext() && (continueExec = (asf = i$.next()).doFilter(this))) {
        }
        return continueExec;
    }

    private void finishResponse() throws Exception {
        this.processorTask.postProcess();
        this.processorTask.terminateProcess();
        this.processorTask = null;
    }

    public boolean postExecute() throws Exception {
        if (this.processorTask == null) {
            return false;
        }
        this.processorTask.postResponse();
        this.finishResponse();
        return false;
    }

    public void setAsyncTask(AsyncTask asyncProcessorTask) {
        this.asyncProcessorTask = asyncProcessorTask;
    }

    public AsyncTask getAsyncTask() {
        return this.asyncProcessorTask;
    }

    public void addAsyncFilter(AsyncFilter asyncFilter) {
        this.asyncFilters.add(asyncFilter);
    }

    public boolean removeAsyncFilter(AsyncFilter asyncFilter) {
        return this.asyncFilters.remove(asyncFilter);
    }

    public AsyncHandler getAsyncHandler() {
        return this.asyncHandler;
    }

    public void setAsyncHandler(AsyncHandler asyncHandler) {
        this.asyncHandler = asyncHandler;
    }

    public void setProcessorTask(ProcessorTask task) {
        this.processorTask = task;
    }

    public ProcessorTask getProcessorTask() {
        return this.processorTask;
    }

    protected static void loadFilters() {
        if (System.getProperty(ASYNC_FILTER) != null) {
            StringTokenizer st = new StringTokenizer(System.getProperty(ASYNC_FILTER), ",");
            sharedAsyncFilters = new String[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                DefaultAsyncExecutor.sharedAsyncFilters[i++] = st.nextToken();
            }
        }
    }
}

