/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.web.arp;

import java.util.ArrayList;
import org.glassfish.grizzly.util.LinkedTransferQueue;
import org.glassfish.grizzly.web.ProcessorTask;
import org.glassfish.grizzly.web.Task;
import org.glassfish.grizzly.web.arp.AsyncExecutor;
import org.glassfish.grizzly.web.arp.AsyncFilter;
import org.glassfish.grizzly.web.arp.AsyncHandler;
import org.glassfish.grizzly.web.arp.AsyncProcessorTask;
import org.glassfish.grizzly.web.arp.AsyncTask;
import org.glassfish.grizzly.web.arp.DefaultAsyncExecutor;

public class DefaultAsyncHandler
implements AsyncHandler {
    private LinkedTransferQueue<AsyncTask> asyncProcessors = new LinkedTransferQueue();
    private ArrayList<AsyncFilter> asyncFilters = new ArrayList();

    private AsyncTask newAsyncProcessorTask() {
        AsyncProcessorTask asyncTask = new AsyncProcessorTask();
        asyncTask.setAsyncExecutor(this.newAsyncExecutor(asyncTask));
        return asyncTask;
    }

    protected AsyncExecutor newAsyncExecutor(AsyncTask asyncTask) {
        DefaultAsyncExecutor asyncExecutor = new DefaultAsyncExecutor();
        asyncExecutor.setAsyncTask(asyncTask);
        asyncExecutor.setAsyncHandler(this);
        for (AsyncFilter l : this.asyncFilters) {
            asyncExecutor.addAsyncFilter(l);
        }
        return asyncExecutor;
    }

    private AsyncTask getAsyncProcessorTask() {
        AsyncTask asyncTask = (AsyncTask)this.asyncProcessors.poll();
        if (asyncTask == null) {
            asyncTask = this.newAsyncProcessorTask();
        } else {
            asyncTask.recycle();
        }
        return asyncTask;
    }

    public void handle(Task task) {
        if (task instanceof ProcessorTask) {
            AsyncTask apt = this.getAsyncProcessorTask();
            apt.setThreadPool(task.getThreadPool());
            apt.getAsyncExecutor().setProcessorTask((ProcessorTask)task);
            apt.execute();
        } else {
            task.execute();
        }
    }

    public void returnTask(AsyncTask asyncTask) {
        this.asyncProcessors.offer((Object)asyncTask);
    }

    public void addAsyncFilter(AsyncFilter asyncFilter) {
        this.asyncFilters.add(asyncFilter);
    }

    public boolean removeAsyncFilter(AsyncFilter asyncFilter) {
        return this.asyncFilters.remove(asyncFilter);
    }
}

