/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.web.embed;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.glassfish.grizzly.Transport;
import org.glassfish.grizzly.TransportFactory;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.ssl.SSLContextConfigurator;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.glassfish.grizzly.ssl.SSLFilter;
import org.glassfish.grizzly.util.IdleTimeoutFilter;
import org.glassfish.grizzly.web.Management;
import org.glassfish.grizzly.web.WebFilter;
import org.glassfish.grizzly.web.arp.AsyncFilter;
import org.glassfish.grizzly.web.arp.AsyncWebFilter;
import org.glassfish.grizzly.web.arp.AsyncWebFilterConfig;
import org.glassfish.grizzly.web.arp.DefaultAsyncHandler;
import org.glassfish.grizzly.web.container.Adapter;
import org.glassfish.grizzly.web.container.http11.GrizzlyAdapter;
import org.glassfish.grizzly.web.container.http11.GrizzlyAdapterChain;
import org.glassfish.grizzly.web.container.http11.GrizzlyRequest;
import org.glassfish.grizzly.web.container.http11.GrizzlyResponse;
import org.glassfish.grizzly.web.embed.Statistics;

public class GrizzlyWebServer {
    private static final String DEFAULT_HOST = "0.0.0.0";
    private static final int DEFAULT_PORT = 8080;
    private static final String DEFAULT_WEB_RESOURCES_PATH = ".";
    private String host;
    private int port = 8080;
    private TCPNIOTransport transport;
    private AsyncWebFilter webFilter;
    private boolean isSecure;
    private SSLEngineConfigurator sslConfiguration;
    private ObjectInstance stMBean;
    private GrizzlyAdapterChain adapterChains = new GrizzlyAdapterChain();
    private HashMap<GrizzlyAdapter, String[]> adapters = new HashMap();
    private boolean isStarted = false;
    private ArrayList<AsyncFilter> asyncFilters = new ArrayList();
    private String webResourcesPath = ".";
    private String mBeanName = "org.glassfish.grizzly.web:type=GrizzlyWebServer,name=GrizzlyHttpEngine-8080";
    private Statistics statistics;

    public GrizzlyWebServer() {
        this(8080);
    }

    public GrizzlyWebServer(int port) {
        this(port, DEFAULT_WEB_RESOURCES_PATH);
    }

    public GrizzlyWebServer(String webResourcesPath) {
        this(8080, webResourcesPath);
    }

    public GrizzlyWebServer(int port, String webResourcesPath) {
        this(port, webResourcesPath, false);
    }

    public GrizzlyWebServer(int port, String webResourcesPath, boolean isSecure) {
        this.port = port;
        this.host = DEFAULT_HOST;
        this.webResourcesPath = webResourcesPath;
        this.isSecure = isSecure;
        this.webFilter = new AsyncWebFilter(Integer.toString(port));
        ((AsyncWebFilterConfig)this.webFilter.getConfig()).setAsyncEnabled(false);
        this.transport = TransportFactory.getInstance().createTCPTransport();
        this.sslConfiguration = new SSLEngineConfigurator(SSLContextConfigurator.DEFAULT_CONFIG.createSSLContext(), false, false, false);
    }

    public void addAsyncFilter(AsyncFilter asyncFilter) {
        this.asyncFilters.add(asyncFilter);
    }

    public void addGrizzlyAdapter(GrizzlyAdapter grizzlyAdapter, String[] mapping) {
        this.adapters.put(grizzlyAdapter, mapping);
        this.adapterChains.setHandleStaticResources(false);
        if (this.isStarted) {
            grizzlyAdapter.start();
            Adapter ga = ((AsyncWebFilterConfig)this.webFilter.getConfig()).getAdapter();
            if (ga instanceof GrizzlyAdapterChain) {
                ((GrizzlyAdapterChain)ga).addGrizzlyAdapter(grizzlyAdapter, mapping);
            } else {
                this.updateGrizzlyAdapters();
            }
        }
    }

    public boolean removeGrizzlyAdapter(GrizzlyAdapter grizzlyAdapter) {
        boolean removed;
        if (this.adapters.size() > 1) {
            this.adapterChains.removeAdapter(grizzlyAdapter);
        }
        boolean bl = removed = this.adapters.remove(grizzlyAdapter) != null;
        if (this.isStarted) {
            Adapter ga = ((AsyncWebFilterConfig)this.webFilter.getConfig()).getAdapter();
            if (ga instanceof GrizzlyAdapterChain) {
                ((GrizzlyAdapterChain)ga).removeAdapter(grizzlyAdapter);
            } else {
                this.updateGrizzlyAdapters();
            }
        }
        return removed;
    }

    public boolean isSecure() {
        return this.isSecure;
    }

    public void setSecure(boolean isSecure) {
        this.isSecure = isSecure;
    }

    public SSLEngineConfigurator getSSLConfiguration() {
        return this.sslConfiguration;
    }

    public void setSSLConfiguration(SSLEngineConfigurator sslConfiguration) {
        this.sslConfiguration = sslConfiguration;
    }

    public Transport getTransport() {
        return this.transport;
    }

    public void setTransport(Transport transport) {
        this.transport = (TCPNIOTransport)transport;
    }

    public AsyncWebFilterConfig getWebConfig() {
        return (AsyncWebFilterConfig)this.webFilter.getConfig();
    }

    public void setWebFilter(AsyncWebFilterConfig webConfig) {
        this.webFilter.setConfig(webConfig);
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void start() throws IOException {
        if (this.isStarted) {
            return;
        }
        this.isStarted = true;
        if (this.asyncFilters.size() > 0) {
            ((AsyncWebFilterConfig)this.webFilter.getConfig()).setAsyncEnabled(true);
            DefaultAsyncHandler asyncHandler = new DefaultAsyncHandler();
            for (AsyncFilter asyncFilter : this.asyncFilters) {
                asyncHandler.addAsyncFilter(asyncFilter);
            }
            ((AsyncWebFilterConfig)this.webFilter.getConfig()).setAsyncHandler(asyncHandler);
        }
        this.updateGrizzlyAdapters();
        this.transport.getFilterChain().add((Object)new TransportFilter());
        this.transport.getFilterChain().add((Object)new IdleTimeoutFilter((long)((AsyncWebFilterConfig)this.webFilter.getConfig()).getKeepAliveTimeoutInSeconds(), TimeUnit.SECONDS));
        if (this.isSecure) {
            this.transport.getFilterChain().add((Object)new SSLFilter(this.sslConfiguration));
        }
        this.transport.getFilterChain().add((Object)this.webFilter);
        this.webFilter.initialize();
        this.transport.bind(this.host, this.port);
        this.transport.start();
    }

    private void updateGrizzlyAdapters() {
        this.adapterChains = new GrizzlyAdapterChain();
        if (this.adapters.size() == 0) {
            this.adapterChains.setRootFolder(this.webResourcesPath);
            this.adapterChains.setHandleStaticResources(true);
            ((AsyncWebFilterConfig)this.webFilter.getConfig()).setAdapter(this.adapterChains);
        } else if (this.adapters.size() == 1) {
            ((AsyncWebFilterConfig)this.webFilter.getConfig()).setAdapter(this.adapters.keySet().iterator().next());
            this.adapters.keySet().iterator().next().setRootFolder(this.webResourcesPath);
        } else {
            for (Map.Entry<GrizzlyAdapter, String[]> entry : this.adapters.entrySet()) {
                if (entry.getValue().length == 0) {
                    this.adapterChains.addGrizzlyAdapter(entry.getKey());
                    continue;
                }
                this.adapterChains.addGrizzlyAdapter(entry.getKey(), entry.getValue());
            }
            ((AsyncWebFilterConfig)this.webFilter.getConfig()).setAdapter(this.adapterChains);
            this.adapterChains.setHandleStaticResources(true);
            this.adapterChains.setRootFolder(this.webResourcesPath);
        }
    }

    public void enableJMX(Management jmxManagement) {
        if (jmxManagement == null) {
            return;
        }
        this.webFilter.getJmxManager().setManagement(jmxManagement);
        try {
            ObjectName sname = new ObjectName(this.mBeanName);
            this.webFilter.getJmxManager().registerComponent(this.webFilter, sname, null);
        }
        catch (Exception ex) {
            WebFilter.logger().log(Level.SEVERE, "Enabling JMX failed", ex);
        }
    }

    public Statistics getStatistics() {
        if (this.statistics == null) {
            this.statistics = new Statistics(this.webFilter);
        }
        return this.statistics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (!this.isStarted) {
            return;
        }
        this.isStarted = false;
        try {
            this.webFilter.release();
            this.transport.stop();
            TransportFactory.getInstance().close();
        }
        catch (Exception e) {
            Logger.getLogger(GrizzlyWebServer.class.getName()).log(Level.WARNING, null, e);
        }
        finally {
            this.transport.getFilterChain().clear();
        }
    }

    public static final GrizzlyWebServer newConfiguredInstance(String path) {
        GrizzlyWebServer ws = new GrizzlyWebServer(8080);
        ws.addGrizzlyAdapter(new GrizzlyAdapter(path){
            {
                this.setHandleStaticResources(true);
            }

            public void service(GrizzlyRequest request, GrizzlyResponse response) {
                try {
                    response.setStatus(404);
                    response.flushBuffer();
                }
                catch (IOException e) {
                    Logger.getLogger(GrizzlyWebServer.class.getName()).log(Level.SEVERE, null, e);
                }
            }
        }, new String[0]);
        return ws;
    }
}

