/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.web.standalone;

import java.io.IOException;
import org.glassfish.grizzly.streams.StreamReader;
import org.glassfish.grizzly.streams.StreamWriter;
import org.glassfish.grizzly.web.Constants;
import org.glassfish.grizzly.web.FileCache;
import org.glassfish.grizzly.web.WebFilter;
import org.glassfish.grizzly.web.WebFilterConfig;
import org.glassfish.grizzly.web.container.Request;
import org.glassfish.grizzly.web.container.util.Interceptor;
import org.glassfish.grizzly.web.container.util.buf.Ascii;
import org.glassfish.grizzly.web.container.util.buf.ByteChunk;
import org.glassfish.grizzly.web.container.util.buf.MessageBytes;
import org.glassfish.grizzly.web.container.util.http.MimeHeaders;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaticHandler
implements Interceptor<Request> {
    private WebFilter webFilter;
    private StreamReader reader;
    private StreamWriter writer;
    protected FileCache fileCache;

    public StaticHandler(WebFilter webFilter) {
        this.webFilter = webFilter;
    }

    @Override
    public void attach(StreamReader reader, StreamWriter writer) {
        this.reader = reader;
        this.writer = writer;
        if (this.fileCache == null && writer != null) {
            this.fileCache = ((WebFilterConfig)this.webFilter.getConfig()).getFileCache();
        }
    }

    @Override
    public int handle(Request req, int handlerCode) throws IOException {
        ByteChunk requestURI;
        if (this.fileCache == null) {
            return 0;
        }
        if (handlerCode == 1 && this.fileCache.isEnabled()) {
            String docroot = ((WebFilterConfig)this.webFilter.getConfig()).getWebAppRootPath();
            MessageBytes mb = req.requestURI();
            String uri = req.requestURI().toString();
            this.fileCache.add("default", docroot, uri, req.getResponse().getMimeHeaders(), false);
        } else if (handlerCode == 0 && this.fileCache.sendCache((requestURI = req.requestURI().getByteChunk()).getBytes(), requestURI.getStart(), requestURI.getLength(), this.writer, this.keepAlive(req))) {
            return 1;
        }
        return 0;
    }

    private boolean keepAlive(Request request) {
        MimeHeaders headers = request.getMimeHeaders();
        MessageBytes connectionValueMB = headers.getValue("connection");
        if (connectionValueMB != null) {
            ByteChunk connectionValueBC = connectionValueMB.getByteChunk();
            if (this.findBytes(connectionValueBC, Constants.CLOSE_BYTES) != -1) {
                return false;
            }
            if (this.findBytes(connectionValueBC, Constants.KEEPALIVE_BYTES) != -1) {
                return true;
            }
        }
        return true;
    }

    protected int findBytes(ByteChunk bc, byte[] b) {
        byte first = b[0];
        byte[] buff = bc.getBuffer();
        int start = bc.getStart();
        int end = bc.getEnd();
        int srcEnd = b.length;
        for (int i = start; i <= end - srcEnd; ++i) {
            if (Ascii.toLower(buff[i]) != first) continue;
            int myPos = i + 1;
            int srcPos = 1;
            while (srcPos < srcEnd && Ascii.toLower(buff[myPos++]) == b[srcPos++]) {
                if (srcPos != srcEnd) continue;
                return i - start;
            }
        }
        return -1;
    }
}

