/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.web;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.WritableByteChannel;
import java.util.logging.Logger;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.TransportFactory;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.memory.MemoryUtils;
import org.glassfish.grizzly.nio.NIOConnection;
import org.glassfish.grizzly.streams.StreamWriter;
import org.glassfish.grizzly.web.container.FileOutputBuffer;
import org.glassfish.grizzly.web.container.Response;
import org.glassfish.grizzly.web.container.http11.InternalOutputBuffer;

public class SocketChannelOutputBuffer
extends InternalOutputBuffer
implements FileOutputBuffer {
    protected static Logger logger = Grizzly.logger;
    protected StreamWriter connectionStreamWriter;
    protected Buffer outputBuffer;
    protected static final Buffer ACK = MemoryUtils.wrap((MemoryManager)TransportFactory.getInstance().getDefaultMemoryManager(), (String)"HTTP/1.1 100 Continue\r\n\r\n");
    protected static final int MAX_BUFFERED_BYTES = 262144;
    protected static int maxBufferedBytes = 262144;

    public SocketChannelOutputBuffer(Response response, int headerBufferSize, boolean useSocketBuffer) {
        super(response, headerBufferSize, useSocketBuffer);
        if (!useSocketBuffer) {
            this.outputStream = new NIOOutputStream();
            this.outputBuffer = this.createBuffer(headerBufferSize * 16);
        }
    }

    protected Buffer createBuffer(int size) {
        if (this.connectionStreamWriter != null) {
            return this.connectionStreamWriter.getConnection().getTransport().getMemoryManager().allocate(size);
        }
        return TransportFactory.getInstance().getDefaultMemoryManager().allocate(size);
    }

    public void setStreamWriter(StreamWriter streamWriter) {
        this.connectionStreamWriter = streamWriter;
    }

    public StreamWriter getStreamWriter() {
        return this.connectionStreamWriter;
    }

    public boolean isAsyncHttpWriteEnabled() {
        return !this.connectionStreamWriter.isBlocking();
    }

    public void setAsyncHttpWriteEnabled(boolean isAsyncHttpWriteEnabled) {
        this.connectionStreamWriter.setBlocking(!isAsyncHttpWriteEnabled);
    }

    @Override
    public void sendAck() throws IOException {
        if (!this.committed) {
            this.flushChannel(ACK.slice());
        }
    }

    @Override
    public void realWriteBytes(byte[] cbuf, int off, int len) throws IOException {
        if (len > 0) {
            if (!this.useSocketBuffer) {
                int remaining = this.outputBuffer.remaining();
                if (len > remaining) {
                    if (this.outputBuffer.capacity() >= maxBufferedBytes) {
                        this.outputBuffer.put(cbuf, off, remaining);
                        this.flush();
                        this.realWriteBytes(cbuf, off + remaining, len - remaining);
                        return;
                    }
                    int size = Math.max(this.outputBuffer.capacity() * 2, len + this.outputBuffer.position());
                    Buffer tmp = this.createBuffer(size);
                    this.outputBuffer.flip();
                    tmp.put(this.outputBuffer);
                    this.outputBuffer = tmp;
                }
                this.outputBuffer.put(cbuf, off, len);
            } else {
                this.flushChannel(MemoryUtils.wrap((MemoryManager)this.connectionStreamWriter.getConnection().getTransport().getMemoryManager(), (byte[])this.buf, (int)off, (int)len));
            }
        }
    }

    public void flushChannel(Buffer bb) throws IOException {
        this.connectionStreamWriter.writeBuffer(bb);
        this.connectionStreamWriter.flush();
        bb.clear();
    }

    @Override
    public boolean isSupportFileSend() {
        return true;
    }

    @Override
    public long sendFile(FileChannel fileChannel, long position, long length) throws IOException {
        Connection connection = this.connectionStreamWriter.getConnection();
        SelectableChannel channel = ((NIOConnection)connection).getChannel();
        return fileChannel.transferTo(position, length, (WritableByteChannel)((Object)channel));
    }

    @Override
    public void flush() throws IOException {
        super.flush();
        this.flushBuffer();
    }

    @Override
    public void endRequest() throws IOException {
        super.endRequest();
        this.flushBuffer();
    }

    public void flushBuffer() throws IOException {
        if (!this.useSocketBuffer && this.outputBuffer.position() != 0) {
            this.outputBuffer.flip();
            this.flushChannel(this.outputBuffer);
            this.outputBuffer.clear();
        }
    }

    @Override
    public void recycle() {
        this.response.recycle();
        this.socketBuffer.recycle();
        this.pos = 0;
        this.lastActiveFilter = -1;
        this.committed = false;
        this.finished = false;
        if (this.outputBuffer != null) {
            this.outputBuffer.clear();
        }
        this.connectionStreamWriter = null;
    }

    @Override
    public void reset() {
        super.reset();
        this.outputBuffer.clear();
    }

    private final class NIOOutputStream
    extends OutputStream {
        private NIOOutputStream() {
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            SocketChannelOutputBuffer.this.realWriteBytes(b, off, len);
        }

        @Override
        public void write(int b) throws IOException {
            this.write((byte)b);
        }

        public void write(byte b) throws IOException {
            if (!SocketChannelOutputBuffer.this.outputBuffer.hasRemaining()) {
                Buffer tmp = SocketChannelOutputBuffer.this.createBuffer(SocketChannelOutputBuffer.this.outputBuffer.capacity() * 2);
                SocketChannelOutputBuffer.this.outputBuffer.flip();
                tmp.put(SocketChannelOutputBuffer.this.outputBuffer);
                SocketChannelOutputBuffer.this.outputBuffer = tmp;
            }
            SocketChannelOutputBuffer.this.outputBuffer.put(b);
        }
    }
}

