/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.web;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterAdapter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.ssl.SSLFilter;
import org.glassfish.grizzly.ssl.SSLStreamReader;
import org.glassfish.grizzly.ssl.SSLStreamWriter;
import org.glassfish.grizzly.threadpool.ExtendedThreadPool;
import org.glassfish.grizzly.util.LinkedTransferQueue;
import org.glassfish.grizzly.web.FileCache;
import org.glassfish.grizzly.web.KeepAliveStats;
import org.glassfish.grizzly.web.ProcessorTask;
import org.glassfish.grizzly.web.Task;
import org.glassfish.grizzly.web.ThreadPoolStatistic;
import org.glassfish.grizzly.web.WebFilterConfig;
import org.glassfish.grizzly.web.WebFilterJMXManager;
import org.glassfish.grizzly.web.container.Adapter;
import org.glassfish.grizzly.web.container.RequestGroupInfo;
import org.glassfish.grizzly.web.container.http11.GrizzlyAdapter;
import org.glassfish.grizzly.web.container.util.res.StringManager;

public class WebFilter<T extends WebFilterConfig>
extends FilterAdapter
implements MBeanRegistration {
    protected static Logger logger = Grizzly.logger;
    protected static final StringManager sm = StringManager.getManager("org.glassfish.grizzly.web.res");
    protected String name;
    protected T config;
    protected WebFilterJMXManager jmxManager;
    private KeepAliveStats keepAliveStats = null;
    private static Attribute<Integer> keepAliveCounterAttr = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute("connection-keepalive-counter", (Object)0);
    protected ThreadPoolStatistic threadPoolStat;
    protected LinkedTransferQueue<ProcessorTask> processorTasks = new LinkedTransferQueue();
    protected LinkedTransferQueue<ProcessorTask> activeProcessorTasks = new LinkedTransferQueue();
    protected RequestGroupInfo globalRequestProcessor = new RequestGroupInfo();
    protected ObjectName globalRequestProcessorName;
    protected ObjectName processorWorkerThreadName;
    private ObjectName keepAliveMbeanName;
    private ObjectName connectionQueueMbeanName;
    private ObjectName fileCacheMbeanName;

    public WebFilter() {
        this("webfilter");
    }

    public WebFilter(String name) {
        this(name, new WebFilterConfig());
    }

    public WebFilter(String name, T config) {
        this.name = name;
        this.config = config;
        this.jmxManager = new WebFilterJMXManager(this);
    }

    public NextAction handleRead(FilterChainContext ctx, NextAction nextAction) throws IOException {
        boolean keepAlive = false;
        ProcessorTask processorTask = this.getProcessorTask(ctx);
        Connection connection = ctx.getConnection();
        Integer keepAliveCounter = (Integer)keepAliveCounterAttr.get((AttributeStorage)connection);
        keepAliveCounter = keepAliveCounter + 1;
        keepAliveCounterAttr.set((AttributeStorage)connection, (Object)keepAliveCounter);
        if (keepAliveCounter > ((WebFilterConfig)this.config).getMaxKeepAliveRequests()) {
            if (this.keepAliveStats != null) {
                this.keepAliveStats.incrementCountRefusals();
            }
            processorTask.setDropConnection(true);
        } else {
            processorTask.setDropConnection(false);
        }
        if (this.keepAliveStats != null) {
            this.keepAliveStats.incrementCountHits();
        }
        this.configureProcessorTask(processorTask, ctx);
        try {
            keepAlive = processorTask.process(ctx.getStreamReader(), ctx.getStreamWriter());
        }
        catch (Throwable ex) {
            logger.log(Level.INFO, "ProcessorTask exception", ex);
            keepAlive = false;
        }
        boolean isSuspend = processorTask.getRequest().getResponse().isSuspended();
        if (isSuspend) {
            return ctx.getSuspendAction();
        }
        if (processorTask != null) {
            processorTask.recycle();
        }
        if (!keepAlive) {
            ctx.getConnection().close();
        }
        return nextAction;
    }

    public NextAction handleAccept(FilterChainContext ctx, NextAction nextAction) throws IOException {
        if (this.keepAliveStats != null) {
            this.keepAliveStats.incrementCountConnections();
        }
        this.getRequestGroupInfo().increaseCountOpenConnections();
        if (this.threadPoolStat != null) {
            this.threadPoolStat.incrementTotalAcceptCount();
            this.threadPoolStat.incrementOpenConnectionsCount(ctx.getConnection());
        }
        return nextAction;
    }

    public NextAction handleClose(FilterChainContext ctx, NextAction nextAction) throws IOException {
        if (this.keepAliveStats != null) {
            this.keepAliveStats.decrementCountConnections();
        }
        return nextAction;
    }

    protected void configureProcessorTask(ProcessorTask processorTask, FilterChainContext context) {
        processorTask.setConnection(context.getConnection());
        processorTask.setHandler(((WebFilterConfig)this.config).getInterceptor());
        processorTask.setAdapter(((WebFilterConfig)this.config).getAdapter());
        processorTask.setFilterChainContext(context);
        if (context.getStreamReader() instanceof SSLStreamReader) {
            for (Filter filter : context.getExecutedFilters()) {
                if (!(filter instanceof SSLFilter)) continue;
                SSLFilter sslFilter = (SSLFilter)filter;
                processorTask.setSSLSupport(sslFilter.createSSLSupport((SSLStreamReader)context.getStreamReader(), (SSLStreamWriter)context.getStreamWriter()));
                break;
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public T getConfig() {
        return this.config;
    }

    public void setConfig(T config) {
        this.config = config;
    }

    public WebFilterJMXManager getJmxManager() {
        return this.jmxManager;
    }

    public void setJmxManager(WebFilterJMXManager jmxManager) {
        this.jmxManager = jmxManager;
    }

    public ThreadPoolStatistic getThreadPoolStatistic() {
        return this.threadPoolStat;
    }

    protected void enableThreadPoolStats() {
        this.threadPoolStat.setThreadPool(((WebFilterConfig)this.config).getWorkerThreadPool());
        this.threadPoolStat.start();
        this.keepAliveStats = new KeepAliveStats();
    }

    protected void disableThreadPoolStats() {
        this.threadPoolStat.stop();
        this.threadPoolStat.setThreadPool(null);
        this.keepAliveStats = null;
    }

    protected void initProcessorTasks(int size) {
        for (int i = 0; i < size; ++i) {
            this.processorTasks.offer((Object)this.newProcessorTask(false));
        }
    }

    protected void rampUpProcessorTasks() {
        Iterator iterator = this.processorTasks.iterator();
        while (iterator.hasNext()) {
            ((ProcessorTask)iterator.next()).initialize();
        }
    }

    protected ProcessorTask newProcessorTask(boolean initialize) {
        ProcessorTask task = new ProcessorTask(initialize, ((WebFilterConfig)this.config).isBufferResponse());
        return this.initializeProcessorTask(task);
    }

    protected ProcessorTask initializeProcessorTask(ProcessorTask task) {
        task.setAdapter(((WebFilterConfig)this.config).getAdapter());
        task.setWebFilter(this);
        return ((WebFilterConfig)this.config).initializeProcessorTask(task);
    }

    public ProcessorTask getProcessorTask(FilterChainContext ctx) {
        ProcessorTask processorTask = null;
        processorTask = (ProcessorTask)this.processorTasks.poll();
        if (processorTask == null) {
            processorTask = this.newProcessorTask(false);
        }
        processorTask.setThreadPool(ctx.getConnection().getTransport().getWorkerThreadPool());
        if (((WebFilterConfig)this.config).isMonitoringEnabled()) {
            this.activeProcessorTasks.offer((Object)processorTask);
        }
        return processorTask;
    }

    public void initialize() throws IOException {
        this.rampUpProcessorTasks();
        this.registerComponents();
        this.displayConfiguration();
        this.initMonitoringLevel();
        ExecutorService workerThreadPool = ((WebFilterConfig)this.config).getWorkerThreadPool();
        int processorTasksToInit = workerThreadPool instanceof ExtendedThreadPool ? ((ExtendedThreadPool)workerThreadPool).getMaximumPoolSize() : 5;
        this.initProcessorTasks(processorTasksToInit);
        Adapter adapter = ((WebFilterConfig)this.config).getAdapter();
        if (adapter instanceof GrizzlyAdapter) {
            ((GrizzlyAdapter)adapter).start();
        }
    }

    public void release() {
        this.processorTasks.clear();
        Adapter adapter = ((WebFilterConfig)this.config).getAdapter();
        if (adapter instanceof GrizzlyAdapter) {
            ((GrizzlyAdapter)adapter).destroy();
        }
        this.unregisterComponents();
    }

    public void returnTask(Task task) {
        if (task != null) {
            if (((WebFilterConfig)this.config).isMonitoringEnabled()) {
                this.activeProcessorTasks.remove((Object)((ProcessorTask)task));
            }
            this.processorTasks.offer((Object)((ProcessorTask)task));
        }
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.jmxManager.setOname(name);
        this.jmxManager.setMserver(server);
        this.jmxManager.setDomain(name.getDomain());
        return name;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public void postDeregister() {
    }

    public void enableMonitoring() {
        if (this.threadPoolStat == null) {
            this.initMonitoringLevel();
        }
        ((WebFilterConfig)this.config).setMonitoringEnabled(true);
        this.enableThreadPoolStats();
        FileCache fileCache = ((WebFilterConfig)this.config).getFileCache();
        if (fileCache != null) {
            fileCache.setMonitoringEnabled(true);
        }
    }

    public void disableMonitoring() {
        this.disableThreadPoolStats();
        ((WebFilterConfig)this.config).setMonitoringEnabled(false);
        FileCache fileCache = ((WebFilterConfig)this.config).getFileCache();
        if (fileCache != null) {
            fileCache.setMonitoringEnabled(false);
        }
    }

    public KeepAliveStats getKeepAliveStats() {
        return this.keepAliveStats;
    }

    public void registerComponents() {
        if (this.jmxManager != null) {
            String domain = this.jmxManager.getDomain();
            try {
                this.globalRequestProcessorName = new ObjectName(domain + ":type=GlobalRequestProcessor,name=GrizzlyHttpEngine-" + this.name);
                this.jmxManager.registerComponent(this.globalRequestProcessor, this.globalRequestProcessorName, null);
                this.keepAliveMbeanName = new ObjectName(domain + ":type=KeepAlive,name=GrizzlyHttpEngine-" + this.name);
                this.jmxManager.registerComponent(this.keepAliveStats, this.keepAliveMbeanName, null);
                this.connectionQueueMbeanName = new ObjectName(domain + ":type=ConnectionQueue,name=GrizzlyHttpEngine-" + this.name);
                this.jmxManager.registerComponent(this.threadPoolStat, this.connectionQueueMbeanName, null);
                this.fileCacheMbeanName = new ObjectName(domain + ":type=FileCache,name=GrizzlyHttpEngine-" + this.name);
                this.jmxManager.registerComponent(((WebFilterConfig)this.config).getFileCache(), this.fileCacheMbeanName, null);
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, sm.getString("WebFilter.mbeanRegistrationException"), this.name);
                logger.log(Level.WARNING, "", ex);
            }
        }
    }

    protected void unregisterComponents() {
        if (this.jmxManager != null) {
            try {
                if (this.globalRequestProcessorName != null) {
                    this.jmxManager.unregisterComponent(this.globalRequestProcessorName);
                }
                if (this.keepAliveMbeanName != null) {
                    this.jmxManager.unregisterComponent(this.keepAliveMbeanName);
                }
                if (this.connectionQueueMbeanName != null) {
                    this.jmxManager.unregisterComponent(this.connectionQueueMbeanName);
                }
                if (this.fileCacheMbeanName != null) {
                    this.jmxManager.unregisterComponent(this.fileCacheMbeanName);
                }
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, sm.getString("WebFilter.mbeanDeregistrationException"), this.name);
                logger.log(Level.WARNING, "", ex);
            }
            Iterator iterator = this.activeProcessorTasks.iterator();
            ProcessorTask pt = null;
            while (iterator.hasNext()) {
                pt = (ProcessorTask)iterator.next();
                if (!(pt instanceof ProcessorTask)) continue;
                pt.unregisterMonitoring();
            }
            iterator = this.processorTasks.iterator();
            pt = null;
            while (iterator.hasNext()) {
                pt = (ProcessorTask)iterator.next();
                if (!(pt instanceof ProcessorTask)) continue;
                pt.unregisterMonitoring();
            }
        }
    }

    public RequestGroupInfo getRequestGroupInfo() {
        return this.globalRequestProcessor;
    }

    public void setRequestProcessor(RequestGroupInfo requestProcessor) {
        this.globalRequestProcessor = requestProcessor;
    }

    protected void initMonitoringLevel() {
        if (this.threadPoolStat != null) {
            return;
        }
        this.threadPoolStat = new ThreadPoolStatistic(this.name, ((WebFilterConfig)this.config).getScheduledThreadPool());
        this.threadPoolStat.setThreadPool(((WebFilterConfig)this.config).getWorkerThreadPool());
    }

    public static void setLogger(Logger l) {
        if (l != null) {
            logger = l;
        }
    }

    public static Logger logger() {
        return logger;
    }

    protected void displayConfiguration() {
        if (((WebFilterConfig)this.config).isDisplayConfiguration()) {
            FileCache fileCache = ((WebFilterConfig)this.config).getFileCache();
            Adapter adapter = ((WebFilterConfig)this.config).getAdapter();
            logger.log(Level.INFO, "\n Grizzly WebFilter configuration\n\t name: " + this.name + "\n\t maxHttpHeaderSize: " + ((WebFilterConfig)this.config).getMaxHttpHeaderSize() + "\n\t maxKeepAliveRequests: " + ((WebFilterConfig)this.config).getMaxKeepAliveRequests() + "\n\t keepAliveTimeoutInSeconds: " + ((WebFilterConfig)this.config).getKeepAliveTimeoutInSeconds() + "\n\t Static File Cache enabled: " + (fileCache != null && fileCache.isEnabled()) + "\n\t Static resources directory: " + new File(((WebFilterConfig)this.config).getRootFolder()).getAbsolutePath() + "\n\t Adapter : " + (adapter == null ? null : adapter.getClass().getName()) + "\n\t Processing mode: synchronous");
        }
    }

    public LinkedTransferQueue<ProcessorTask> getActiveProcessorTasks() {
        return this.activeProcessorTasks;
    }
}

