/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http;

import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.http.Constants;
import org.glassfish.grizzly.http.HttpCodecFilter;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpPacketParsing;
import org.glassfish.grizzly.http.HttpTrailer;
import org.glassfish.grizzly.http.ParsingResult;
import org.glassfish.grizzly.http.TransferEncoding;
import org.glassfish.grizzly.http.util.Ascii;
import org.glassfish.grizzly.http.util.HexUtils;
import org.glassfish.grizzly.http.util.MimeHeaders;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.MemoryManager;

public final class ChunkedTransferEncoding
implements TransferEncoding {
    private static final int MAX_HTTP_CHUNK_SIZE_LENGTH = 16;
    private final int maxHeadersSize;

    public ChunkedTransferEncoding(int maxHeadersSize) {
        this.maxHeadersSize = maxHeadersSize;
    }

    @Override
    public boolean wantDecode(HttpHeader httpPacket) {
        return httpPacket.isChunked();
    }

    @Override
    public boolean wantEncode(HttpHeader httpPacket) {
        return httpPacket.isChunked();
    }

    @Override
    public void prepareSerialize(HttpHeader httpHeader, HttpContent content) {
        httpHeader.makeTransferEncodingHeader("chunked");
    }

    @Override
    public ParsingResult parsePacket(Connection connection, HttpHeader httpPacket, Buffer input) {
        HttpPacketParsing httpPacketParsing = (HttpPacketParsing)((Object)httpPacket);
        HttpCodecFilter.ContentParsingState contentParsingState = httpPacketParsing.getContentParsingState();
        boolean isLastChunk = contentParsingState.isLastChunk;
        if (!isLastChunk && contentParsingState.chunkRemainder <= 0L) {
            if ((input = ChunkedTransferEncoding.parseTrailerCRLF(httpPacketParsing, input)) == null) {
                return ParsingResult.create(null, null);
            }
            if (!ChunkedTransferEncoding.parseHttpChunkLength(httpPacketParsing, input)) {
                return ParsingResult.create(null, input);
            }
        } else {
            contentParsingState.chunkContentStart = 0;
        }
        int chunkContentStart = contentParsingState.chunkContentStart;
        if (contentParsingState.chunkLength == 0L) {
            if (!isLastChunk) {
                contentParsingState.isLastChunk = true;
                isLastChunk = true;
                this.initTrailerParsing(httpPacketParsing);
            }
            if (!ChunkedTransferEncoding.parseLastChunkTrailer(httpPacketParsing, input)) {
                return ParsingResult.create(null, input);
            }
            chunkContentStart = httpPacketParsing.getHeaderParsingState().offset;
        }
        long thisPacketRemaining = contentParsingState.chunkRemainder;
        int contentAvailable = input.limit() - chunkContentStart;
        Buffer remainder = null;
        if ((long)contentAvailable > thisPacketRemaining) {
            remainder = input.split((int)((long)chunkContentStart + thisPacketRemaining));
            input.position(chunkContentStart);
        } else if (chunkContentStart > 0) {
            input.position(chunkContentStart);
        }
        input.shrink();
        if (input.hasRemaining()) {
            contentParsingState.chunkRemainder -= (long)input.remaining();
        } else {
            input.tryDispose();
            input = Buffers.EMPTY_BUFFER;
        }
        if (isLastChunk) {
            return ParsingResult.create(httpPacket.httpTrailerBuilder().headers(contentParsingState.trailerHeaders).build(), remainder);
        }
        return ParsingResult.create(((HttpContent.Builder)httpPacket.httpContentBuilder().content(input)).build(), remainder);
    }

    @Override
    public Buffer serializePacket(Connection connection, HttpContent httpContent) {
        MemoryManager memoryManager = connection.getTransport().getMemoryManager();
        return ChunkedTransferEncoding.encodeHttpChunk(memoryManager, httpContent, httpContent.isLast());
    }

    private void initTrailerParsing(HttpPacketParsing httpPacket) {
        int start;
        HttpCodecFilter.HeaderParsingState headerParsingState = httpPacket.getHeaderParsingState();
        HttpCodecFilter.ContentParsingState contentParsingState = httpPacket.getContentParsingState();
        headerParsingState.subState = 0;
        headerParsingState.start = start = contentParsingState.chunkContentStart;
        headerParsingState.offset = start;
        headerParsingState.packetLimit = start + this.maxHeadersSize;
    }

    private static boolean parseLastChunkTrailer(HttpPacketParsing httpPacket, Buffer input) {
        HttpCodecFilter.HeaderParsingState headerParsingState = httpPacket.getHeaderParsingState();
        HttpCodecFilter.ContentParsingState contentParsingState = httpPacket.getContentParsingState();
        return HttpCodecFilter.parseHeaders(null, contentParsingState.trailerHeaders, headerParsingState, input);
    }

    private static boolean parseHttpChunkLength(HttpPacketParsing httpPacket, Buffer input) {
        HttpCodecFilter.HeaderParsingState parsingState = httpPacket.getHeaderParsingState();
        while (true) {
            switch (parsingState.state) {
                case 0: {
                    int pos;
                    parsingState.start = pos = input.position();
                    parsingState.offset = pos;
                    parsingState.packetLimit = pos + 16;
                    parsingState.state = 1;
                }
                case 1: {
                    int offset;
                    int limit = Math.min(parsingState.packetLimit, input.limit());
                    long value = parsingState.parsingNumericValue;
                    for (offset = parsingState.offset; offset < limit; ++offset) {
                        byte b = input.get(offset);
                        if (b == 13 || b == 59) {
                            parsingState.checkpoint = offset;
                            continue;
                        }
                        if (b == 10) {
                            HttpCodecFilter.ContentParsingState contentParsingState = httpPacket.getContentParsingState();
                            contentParsingState.chunkContentStart = offset + 1;
                            contentParsingState.chunkLength = value;
                            contentParsingState.chunkRemainder = value;
                            parsingState.state = 2;
                            return true;
                        }
                        if (parsingState.checkpoint == -1) {
                            value = value * 16L + (long)HexUtils.DEC[b];
                            continue;
                        }
                        throw new IllegalStateException("Unexpected HTTP chunk header");
                    }
                    parsingState.parsingNumericValue = value;
                    parsingState.offset = offset;
                    parsingState.checkOverflow();
                    return false;
                }
            }
        }
    }

    private static Buffer parseTrailerCRLF(HttpPacketParsing httpPacket, Buffer input) {
        HttpCodecFilter.HeaderParsingState parsingState = httpPacket.getHeaderParsingState();
        if (parsingState.state == 2) {
            while (input.hasRemaining()) {
                if (input.get() != 10) continue;
                parsingState.recycle();
                if (input.hasRemaining()) {
                    return input.slice();
                }
                return null;
            }
            return null;
        }
        return input;
    }

    private static Buffer encodeHttpChunk(MemoryManager memoryManager, HttpContent httpContent, boolean isLastChunk) {
        boolean hasContent;
        Buffer content = httpContent.getContent();
        Buffer httpChunkBuffer = memoryManager.allocate(16);
        int chunkSize = content.remaining();
        Ascii.intToHexString(httpChunkBuffer, chunkSize);
        httpChunkBuffer = HttpCodecFilter.put(memoryManager, httpChunkBuffer, Constants.CRLF_BYTES);
        httpChunkBuffer.trim();
        httpChunkBuffer.allowBufferDispose(true);
        boolean bl = hasContent = chunkSize > 0;
        if (hasContent) {
            httpChunkBuffer = Buffers.appendBuffers((MemoryManager)memoryManager, (Buffer)httpChunkBuffer, (Buffer)content);
        }
        Buffer httpChunkTrailer = memoryManager.allocate(256);
        if (!isLastChunk) {
            httpChunkTrailer = HttpCodecFilter.put(memoryManager, httpChunkTrailer, Constants.CRLF_BYTES);
        } else {
            if (hasContent) {
                httpChunkTrailer = HttpCodecFilter.put(memoryManager, httpChunkTrailer, Constants.CRLF_BYTES);
                httpChunkTrailer = HttpCodecFilter.put(memoryManager, httpChunkTrailer, Constants.LAST_CHUNK_CRLF_BYTES);
            }
            if (httpContent instanceof HttpTrailer) {
                HttpTrailer httpTrailer = (HttpTrailer)httpContent;
                MimeHeaders mimeHeaders = httpTrailer.getHeaders();
                httpChunkTrailer = HttpCodecFilter.encodeMimeHeaders(memoryManager, httpChunkTrailer, mimeHeaders);
            }
            httpChunkTrailer = HttpCodecFilter.put(memoryManager, httpChunkTrailer, Constants.CRLF_BYTES);
        }
        httpChunkTrailer.trim();
        httpChunkTrailer.allowBufferDispose(true);
        return Buffers.appendBuffers((MemoryManager)memoryManager, (Buffer)httpChunkBuffer, (Buffer)httpChunkTrailer);
    }
}

