/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http;

import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.http.Cookie;
import org.glassfish.grizzly.http.util.BufferChunk;
import org.glassfish.grizzly.http.util.CookieParserUtils;
import org.glassfish.grizzly.http.util.MimeHeaders;

public final class Cookies {
    private static final Logger logger;
    private static final int INITIAL_SIZE = 4;
    private final Collection<Cookie> cookies = new ArrayList<Cookie>(4);
    private boolean isProcessed;
    private final MimeHeaders headers;
    public static final char[] SEPARATORS;
    protected static final boolean[] separators;

    public Cookies(MimeHeaders headers) {
        this.headers = headers;
    }

    public Collection<Cookie> get() {
        if (this.isProcessed) {
            this.isProcessed = true;
            this.processCookies();
        }
        return this.cookies;
    }

    public void recycle() {
        this.cookies.clear();
        this.isProcessed = false;
    }

    private void processCookies() {
        if (this.headers == null) {
            return;
        }
        int pos = 0;
        while (pos >= 0 && (pos = this.headers.indexOf("Cookie", pos)) >= 0) {
            BufferChunk cookieValue = this.headers.getValue(pos);
            if (cookieValue == null || cookieValue.isNull()) {
                ++pos;
                continue;
            }
            if (cookieValue.hasBuffer()) {
                if (logger.isLoggable(Level.FINE)) {
                    Cookies.log("Parsing b[]: " + cookieValue.toString());
                }
            } else {
                throw new IllegalStateException("Not implemented");
            }
            CookieParserUtils.parseClientCookies(this.cookies, cookieValue.getBuffer(), cookieValue.getStart(), cookieValue.size());
            ++pos;
        }
    }

    public String toString() {
        return this.cookies.toString();
    }

    private static void log(String s) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Cookies: {0}", s);
        }
    }

    public Cookie findByName(String cookieName) {
        Collection<Cookie> parsedCookies = this.get();
        for (Cookie cookie : parsedCookies) {
            if (!cookie.lazyNameEquals(cookieName)) continue;
            return cookie;
        }
        return null;
    }

    static {
        int i;
        logger = Grizzly.logger(Cookies.class);
        SEPARATORS = new char[]{'\t', ' ', '\"', '\'', '(', ')', ',', ':', ';', '<', '=', '>', '?', '@', '[', '\\', ']', '{', '}'};
        separators = new boolean[128];
        for (i = 0; i < 128; ++i) {
            Cookies.separators[i] = false;
        }
        for (i = 0; i < SEPARATORS.length; ++i) {
            Cookies.separators[Cookies.SEPARATORS[i]] = true;
        }
    }
}

