/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.attributes.AttributeHolder;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.attributes.IndexedAttributeHolder;
import org.glassfish.grizzly.http.ContentEncoding;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpPacket;
import org.glassfish.grizzly.http.HttpTrailer;
import org.glassfish.grizzly.http.MimeHeadersPacket;
import org.glassfish.grizzly.http.ProcessingState;
import org.glassfish.grizzly.http.Protocol;
import org.glassfish.grizzly.http.TransferEncoding;
import org.glassfish.grizzly.http.util.Ascii;
import org.glassfish.grizzly.http.util.BufferChunk;
import org.glassfish.grizzly.http.util.ContentType;
import org.glassfish.grizzly.http.util.MimeHeaders;

public abstract class HttpHeader
implements HttpPacket,
MimeHeadersPacket,
AttributeStorage {
    protected boolean isCommitted;
    protected final MimeHeaders headers = new MimeHeaders();
    protected final BufferChunk protocolBC = BufferChunk.newInstance();
    protected Protocol parsedProtocol;
    protected boolean isChunked;
    protected long contentLength = -1L;
    protected String charEncoding;
    protected boolean charEncodingParsed;
    protected boolean contentTypeParsed;
    protected String contentType;
    protected boolean isExpectContent = true;
    protected boolean isSkipRemainder;
    protected boolean secure;
    protected final BufferChunk upgrade = BufferChunk.newInstance();
    private TransferEncoding transferEncoding;
    private final List<ContentEncoding> contentEncodings = new ArrayList<ContentEncoding>();
    private final AttributeHolder attributes = new IndexedAttributeHolder(Grizzly.DEFAULT_ATTRIBUTE_BUILDER);

    public AttributeHolder getAttributes() {
        return this.attributes;
    }

    public abstract boolean isRequest();

    @Override
    public final boolean isHeader() {
        return true;
    }

    public abstract ProcessingState getProcessingState();

    protected void addContentEncoding(ContentEncoding contentEncoding) {
        this.contentEncodings.add(contentEncoding);
    }

    protected List<ContentEncoding> getContentEncodings(boolean isModifiable) {
        if (isModifiable) {
            return this.contentEncodings;
        }
        return Collections.unmodifiableList(this.contentEncodings);
    }

    public List<ContentEncoding> getContentEncodings() {
        return this.getContentEncodings(false);
    }

    public TransferEncoding getTransferEncoding() {
        return this.transferEncoding;
    }

    protected void setTransferEncoding(TransferEncoding transferEncoding) {
        this.transferEncoding = transferEncoding;
    }

    public boolean isChunked() {
        return this.isChunked;
    }

    public void setChunked(boolean isChunked) {
        this.isChunked = isChunked;
    }

    public boolean isExpectContent() {
        return this.isExpectContent;
    }

    protected void setExpectContent(boolean isExpectContent) {
        this.isExpectContent = isExpectContent;
    }

    public boolean isSkipRemainder() {
        return this.isSkipRemainder;
    }

    public void setSkipRemainder(boolean isSkipRemainder) {
        this.isSkipRemainder = isSkipRemainder;
    }

    public String getUpgrade() {
        if (!this.upgrade.isNull()) {
            return this.upgrade.toString();
        }
        String upgradeStr = this.headers.getHeader("upgrade");
        if (upgradeStr != null) {
            this.upgrade.setString(upgradeStr);
        }
        return upgradeStr;
    }

    public BufferChunk getUpgradeBC() {
        return this.upgrade;
    }

    public void setUpgrade(String upgrade) {
        this.upgrade.setString(upgrade);
    }

    protected void makeUpgradeHeader() {
        if (!this.upgrade.isNull()) {
            this.headers.setValue("upgrade").set(this.upgrade);
        }
    }

    protected void makeContentLengthHeader(long defaultLength) {
        if (this.contentLength != -1L) {
            this.headers.setValue("content-length").setString(Long.toString(this.contentLength));
        } else if (defaultLength != -1L) {
            int idx = this.headers.indexOf("content-length", 0);
            if (idx == -1) {
                this.headers.addValue("content-length").setString(Long.toString(defaultLength));
            } else if (this.headers.getValue(idx).isNull()) {
                this.headers.getValue(idx).setString(Long.toString(defaultLength));
            }
        }
    }

    public long getContentLength() {
        BufferChunk contentLengthChunk;
        if (this.contentLength == -1L && (contentLengthChunk = this.headers.getValue("content-length")) != null) {
            this.contentLength = Ascii.parseLong(contentLengthChunk);
        }
        return this.contentLength;
    }

    public void setContentLength(int len) {
        this.contentLength = len;
    }

    public void setContentLength(long contentLength) {
        this.contentLength = contentLength;
    }

    public boolean isCommitted() {
        return this.isCommitted;
    }

    public void setCommitted(boolean isCommited) {
        this.isCommitted = isCommited;
    }

    protected void makeTransferEncodingHeader(String defaultValue) {
        int idx = this.headers.indexOf("transfer-encoding", 0);
        if (idx == -1) {
            this.headers.addValue("transfer-encoding").setString("chunked");
        }
    }

    protected void extractContentEncoding(BufferChunk value) {
        int idx = this.headers.indexOf("content-encoding", 0);
        if (idx != -1) {
            this.headers.getAndSetSerialized(idx, true);
            value.set(this.headers.getValue(idx));
        }
    }

    public String getCharacterEncoding() {
        if (this.charEncoding != null || this.charEncodingParsed) {
            return this.charEncoding;
        }
        this.charEncoding = ContentType.getCharsetFromContentType(this.getContentType());
        this.charEncodingParsed = true;
        return this.charEncoding;
    }

    public void setCharacterEncoding(String enc) {
        this.charEncoding = enc;
    }

    protected void extractContentType(BufferChunk bc) {
        if (!this.contentTypeParsed) {
            BufferChunk value;
            int idx;
            this.contentTypeParsed = true;
            if (this.contentType == null && (idx = this.headers.indexOf("content-type", 0)) != -1 && !(value = this.headers.getValue(idx)).isNull()) {
                this.contentType = value.toString();
                this.headers.getAndSetSerialized(idx, true);
            }
        }
        bc.setString(this.contentType);
    }

    public String getContentType() {
        if (!this.contentTypeParsed) {
            BufferChunk bc;
            this.contentTypeParsed = true;
            if (this.contentType == null && (bc = this.headers.getValue("content-type")) != null && !bc.isNull()) {
                this.contentType = bc.toString();
            }
        }
        return this.contentType;
    }

    public void setContentType(String type) {
        this.contentType = type;
    }

    @Override
    public MimeHeaders getHeaders() {
        return this.headers;
    }

    @Override
    public String getHeader(String name) {
        return this.headers.getHeader(name);
    }

    @Override
    public void setHeader(String name, String value) {
        this.headers.setValue(name).setString(value);
    }

    @Override
    public void addHeader(String name, String value) {
        this.headers.addValue(name).setString(value);
    }

    @Override
    public boolean containsHeader(String name) {
        return this.headers.getHeader(name) != null;
    }

    public BufferChunk getProtocolBC() {
        return this.protocolBC;
    }

    public String getProtocolString() {
        if (this.parsedProtocol == null) {
            return this.getProtocolBC().toString();
        }
        return this.parsedProtocol.getProtocolString();
    }

    public Protocol getProtocol() {
        if (this.parsedProtocol != null) {
            return this.parsedProtocol;
        }
        if (this.protocolBC.isNull() || this.protocolBC.size() == 0) {
            this.parsedProtocol = Protocol.HTTP_0_9;
        } else if (this.protocolBC.equals(Protocol.HTTP_1_1.getProtocolString())) {
            this.parsedProtocol = Protocol.HTTP_1_1;
        } else if (this.protocolBC.equals(Protocol.HTTP_1_0.getProtocolString())) {
            this.parsedProtocol = Protocol.HTTP_1_0;
        } else if (this.protocolBC.equals(Protocol.HTTP_0_9.getProtocolString())) {
            this.parsedProtocol = Protocol.HTTP_0_9;
        } else {
            throw new IllegalStateException("Unknown protocol " + this.protocolBC.toString());
        }
        return this.parsedProtocol;
    }

    public void setProtocol(Protocol protocol) {
        this.parsedProtocol = protocol;
    }

    public boolean isSecure() {
        return this.secure;
    }

    protected void setSecure(boolean secure) {
        this.secure = secure;
    }

    public final HttpContent.Builder httpContentBuilder() {
        return HttpContent.builder(this);
    }

    public HttpTrailer.Builder httpTrailerBuilder() {
        return HttpTrailer.builder(this);
    }

    protected void reset() {
        this.secure = false;
        this.attributes.recycle();
        this.protocolBC.recycle();
        this.parsedProtocol = null;
        this.contentEncodings.clear();
        this.headers.clear();
        this.isCommitted = false;
        this.isChunked = false;
        this.contentLength = -1L;
        this.charEncoding = null;
        this.charEncodingParsed = false;
        this.contentType = null;
        this.contentTypeParsed = false;
        this.transferEncoding = null;
        this.isExpectContent = true;
        this.upgrade.recycle();
    }

    public void recycle() {
        this.reset();
    }

    public static abstract class Builder<T extends Builder> {
        protected HttpHeader packet;

        public final T protocol(Protocol protocol) {
            this.packet.setProtocol(protocol);
            return (T)this;
        }

        public final T protocol(String protocol) {
            this.packet.getProtocolBC().setString(protocol);
            return (T)this;
        }

        public final T chunked(boolean isChunked) {
            this.packet.setChunked(isChunked);
            return (T)this;
        }

        public final T contentLength(long contentLength) {
            this.packet.setContentLength(contentLength);
            return (T)this;
        }

        public final T contentType(String contentType) {
            this.packet.setContentType(contentType);
            return (T)this;
        }

        public final T upgrade(String upgrade) {
            this.packet.setUpgrade(upgrade);
            return (T)this;
        }

        public final T header(String name, String value) {
            this.packet.addHeader(name, value);
            return (T)this;
        }
    }
}

