/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Enumeration;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpRequestPacketImpl;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.util.BufferChunk;
import org.glassfish.grizzly.http.util.MimeHeaders;
import org.glassfish.grizzly.http.util.RequestURIRef;

public abstract class HttpRequestPacket
extends HttpHeader {
    private Connection connection;
    private HttpResponsePacket response;
    private int serverPort = -1;
    private int remotePort = -1;
    private int localPort = -1;
    private RequestURIRef requestURIRef = new RequestURIRef();
    private String localHost;
    private final BufferChunk methodBC = BufferChunk.newInstance();
    private final BufferChunk queryBC = BufferChunk.newInstance();
    private final BufferChunk remoteAddressBC = BufferChunk.newInstance();
    private final BufferChunk remoteHostBC = BufferChunk.newInstance();
    private final BufferChunk localNameBC = BufferChunk.newInstance();
    private final BufferChunk localAddressBC = BufferChunk.newInstance();
    private final BufferChunk serverNameBC = BufferChunk.newInstance();
    private boolean requiresAcknowledgement;

    public static Builder builder() {
        return new Builder();
    }

    protected HttpRequestPacket() {
        this.methodBC.setString("GET");
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public HttpResponsePacket getResponse() {
        return this.response;
    }

    public BufferChunk getMethodBC() {
        return this.methodBC;
    }

    public String getMethod() {
        return this.methodBC.toString();
    }

    public void setMethod(String method) {
        this.methodBC.setString(method);
    }

    public RequestURIRef getRequestURIRef() {
        return this.requestURIRef;
    }

    public String getRequestURI() {
        return this.requestURIRef.getURI();
    }

    public void setRequestURI(String requestURI) {
        this.requestURIRef.setURI(requestURI);
    }

    public BufferChunk getQueryStringBC() {
        return this.queryBC;
    }

    public String getQueryString() {
        return this.queryBC.isNull() ? null : this.queryBC.toString();
    }

    public void setQueryString(String query) {
        this.queryBC.setString(query);
    }

    public BufferChunk serverName() {
        return this.serverNameBC;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    public BufferChunk remoteAddr() {
        if (this.remoteAddressBC.isNull()) {
            this.remoteAddressBC.setString(((InetSocketAddress)this.connection.getPeerAddress()).getAddress().getHostAddress());
        }
        return this.remoteAddressBC;
    }

    public String getRemoteAddress() {
        return this.remoteAddr().toString();
    }

    public BufferChunk remoteHost() {
        if (this.remoteHostBC.isNull()) {
            String remoteHost = null;
            InetAddress inetAddr = ((InetSocketAddress)this.connection.getPeerAddress()).getAddress();
            if (inetAddr != null) {
                remoteHost = inetAddr.getHostName();
            }
            if (remoteHost == null) {
                if (!this.remoteAddressBC.isNull()) {
                    remoteHost = this.remoteAddressBC.toString();
                } else {
                    this.remoteHostBC.recycle();
                }
            }
            this.remoteHostBC.setString(remoteHost);
        }
        return this.remoteHostBC;
    }

    public String getRemoteHost() {
        return this.remoteHost().toString();
    }

    protected void requiresAcknowledgement(boolean requiresAcknowledgement) {
        this.requiresAcknowledgement = requiresAcknowledgement;
    }

    public boolean requiresAcknowledgement() {
        return this.requiresAcknowledgement;
    }

    public BufferChunk localName() {
        if (this.localNameBC.isNull()) {
            InetAddress inetAddr = ((InetSocketAddress)this.connection.getLocalAddress()).getAddress();
            this.localNameBC.setString(inetAddr.getHostName());
        }
        return this.localNameBC;
    }

    public String getLocalName() {
        return this.localName().toString();
    }

    public BufferChunk localAddr() {
        if (this.localAddressBC.isNull()) {
            InetAddress inetAddr = ((InetSocketAddress)this.connection.getLocalAddress()).getAddress();
            this.localAddressBC.setString(inetAddr.getHostAddress());
        }
        return this.localAddressBC;
    }

    public String getLocalAddress() {
        return this.localAddr().toString();
    }

    public int getRemotePort() {
        if (this.remotePort == -1) {
            this.remotePort = ((InetSocketAddress)this.connection.getPeerAddress()).getPort();
        }
        return this.remotePort;
    }

    public void setRemotePort(int port) {
        this.remotePort = port;
    }

    public int getLocalPort() {
        if (this.localPort == -1) {
            this.localPort = ((InetSocketAddress)this.connection.getLocalAddress()).getPort();
        }
        return this.localPort;
    }

    public void setLocalPort(int port) {
        this.localPort = port;
    }

    public String getLocalHost() {
        return this.localHost;
    }

    public void setLocalHost(String host) {
        this.localHost = host;
    }

    @Override
    protected void reset() {
        this.requestURIRef.recycle();
        this.queryBC.recycle();
        this.methodBC.recycle();
        this.remoteAddressBC.recycle();
        this.remoteHostBC.recycle();
        this.localAddressBC.recycle();
        this.localNameBC.recycle();
        this.serverNameBC.recycle();
        this.requiresAcknowledgement = false;
        this.remotePort = -1;
        this.localPort = -1;
        this.serverPort = -1;
        this.connection = null;
        this.localHost = null;
        this.response = null;
        this.methodBC.setString("GET");
        this.protocolBC.setString("HTTP/1.0");
        super.reset();
    }

    @Override
    public final boolean isRequest() {
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(256);
        sb.append("HttpRequestPacket (\n   method=").append(this.getMethod()).append("\n   url=").append(this.getRequestURI()).append("\n   query=").append(this.getQueryString()).append("\n   protocol=").append((Object)this.getProtocol()).append("\n   content-length=").append(this.getContentLength()).append("\n   headers=[");
        MimeHeaders headersLocal = this.getHeaders();
        Enumeration<String> e = headersLocal.names();
        while (e.hasMoreElements()) {
            String n = e.nextElement();
            sb.append("\n      ").append(n).append('=').append(headersLocal.getHeader(n));
        }
        sb.append("]\n)");
        return sb.toString();
    }

    void setResponse(HttpResponsePacket response) {
        this.response = response;
    }

    public static class Builder
    extends HttpHeader.Builder<Builder> {
        protected Builder() {
            this.packet = HttpRequestPacketImpl.create();
        }

        public Builder method(String method) {
            ((HttpRequestPacket)this.packet).setMethod(method);
            return this;
        }

        public Builder uri(String uri) {
            ((HttpRequestPacket)this.packet).setRequestURI(uri);
            return this;
        }

        public Builder query(String query) {
            ((HttpRequestPacket)this.packet).setQueryString(query);
            return this;
        }

        public final HttpRequestPacket build() {
            return (HttpRequestPacket)this.packet;
        }
    }
}

