/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http;

import java.util.Locale;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacketImpl;
import org.glassfish.grizzly.http.util.BufferChunk;
import org.glassfish.grizzly.http.util.Utils;

public abstract class HttpResponsePacket
extends HttpHeader {
    public static final int NON_PARSED_STATUS = Integer.MIN_VALUE;
    private HttpRequestPacket request;
    private Locale locale;
    private String contentLanguage;
    protected int parsedStatusInt = Integer.MIN_VALUE;
    protected final BufferChunk statusBC = new StatusBufferChunk();
    private final BufferChunk reasonPhraseBC = BufferChunk.newInstance();
    private boolean acknowledgment;

    public static Builder builder(HttpRequestPacket request) {
        return new Builder(request);
    }

    protected HttpResponsePacket() {
    }

    public BufferChunk getStatusBC() {
        return this.statusBC;
    }

    public int getStatus() {
        if (this.parsedStatusInt == Integer.MIN_VALUE) {
            this.parsedStatusInt = Integer.parseInt(this.statusBC.toString());
        }
        return this.parsedStatusInt;
    }

    public void setStatus(int status) {
        this.statusBC.setString(Integer.toString(status));
        this.parsedStatusInt = status;
    }

    public BufferChunk getReasonPhraseBC(boolean useDefault) {
        if (useDefault && this.reasonPhraseBC.isNull()) {
            return Utils.getHttpStatusMessage(this.getStatus());
        }
        return this.reasonPhraseBC;
    }

    public String getReasonPhrase() {
        return this.reasonPhraseBC.toString();
    }

    public void setReasonPhrase(String message) {
        this.reasonPhraseBC.setString(message);
    }

    public HttpRequestPacket getRequest() {
        return this.request;
    }

    public boolean isAcknowledgement() {
        return this.acknowledgment;
    }

    public void setAcknowledgement(boolean acknowledgement) {
        this.acknowledgment = acknowledgement;
    }

    public void acknowledged() {
        this.acknowledgment = false;
        this.parsedStatusInt = Integer.MIN_VALUE;
        this.reasonPhraseBC.recycle();
    }

    @Override
    protected void reset() {
        this.statusBC.recycle();
        this.parsedStatusInt = Integer.MIN_VALUE;
        this.acknowledgment = false;
        this.reasonPhraseBC.recycle();
        this.locale = null;
        this.contentLanguage = null;
        this.request = null;
        super.reset();
    }

    @Override
    public final boolean isRequest() {
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(256);
        sb.append("HttpResponsePacket (status=").append(this.getStatus()).append(" reason=").append(this.getReasonPhrase()).append(" protocol=").append((Object)this.getProtocol()).append(" content-length=").append(this.getContentLength()).append(" headers=").append(this.getHeaders()).append(" committed=").append(this.isCommitted()).append(')');
        return sb.toString();
    }

    @Override
    public void setHeader(String name, String value) {
        char c = name.charAt(0);
        if ((c == 'C' || c == 'c') && this.checkSpecialHeader(name, value)) {
            return;
        }
        super.setHeader(name, value);
    }

    @Override
    public void addHeader(String name, String value) {
        char c = name.charAt(0);
        if ((c == 'C' || c == 'c') && this.checkSpecialHeader(name, value)) {
            return;
        }
        super.addHeader(name, value);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        if (locale == null) {
            return;
        }
        this.locale = locale;
        this.contentLanguage = locale.getLanguage();
        if (this.contentLanguage != null && this.contentLanguage.length() > 0) {
            String country = locale.getCountry();
            StringBuilder value = new StringBuilder(this.contentLanguage);
            if (country != null && country.length() > 0) {
                value.append('-');
                value.append(country);
            }
            this.contentLanguage = value.toString();
        }
    }

    public String getContentLanguage() {
        return this.contentLanguage;
    }

    public void setContentLanguage(String contentLanguage) {
        this.contentLanguage = contentLanguage;
    }

    public void setRequest(HttpRequestPacket request) {
        this.request = request;
    }

    private boolean checkSpecialHeader(String name, String value) {
        if (name.equalsIgnoreCase("Content-Type")) {
            this.setContentType(value);
            return true;
        }
        if (name.equalsIgnoreCase("Content-Length")) {
            try {
                int cL = Integer.parseInt(value);
                this.setContentLength(cL);
                return true;
            }
            catch (NumberFormatException ex) {
                return false;
            }
        }
        if (name.equalsIgnoreCase("Content-Language")) {
            // empty if block
        }
        return false;
    }

    public static class Builder
    extends HttpHeader.Builder<Builder> {
        protected Builder(HttpRequestPacket request) {
            this.packet = request.getResponse();
            if (this.packet == null) {
                this.packet = HttpResponsePacketImpl.create();
                ((HttpResponsePacket)this.packet).setRequest(request);
                this.packet.setSecure(request.isSecure());
            }
        }

        public Builder status(int status) {
            ((HttpResponsePacket)this.packet).setStatus(status);
            return this;
        }

        public Builder reasonPhrase(String reasonPhrase) {
            ((HttpResponsePacket)this.packet).setReasonPhrase(reasonPhrase);
            return this;
        }

        public final HttpResponsePacket build() {
            return (HttpResponsePacket)this.packet;
        }
    }

    private class StatusBufferChunk
    extends BufferChunk {
        private StatusBufferChunk() {
        }

        @Override
        protected void onContentChanged() {
            HttpResponsePacket.this.parsedStatusInt = Integer.MIN_VALUE;
        }
    }
}

