/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http;

import org.glassfish.grizzly.ThreadCache;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.MimeHeadersPacket;
import org.glassfish.grizzly.http.util.MimeHeaders;

public class HttpTrailer
extends HttpContent
implements MimeHeadersPacket {
    private static final ThreadCache.CachedTypeIndex<HttpTrailer> CACHE_IDX = ThreadCache.obtainIndex(HttpTrailer.class, (int)2);
    private MimeHeaders headers = new MimeHeaders();

    public static HttpTrailer create() {
        return HttpTrailer.create(null);
    }

    public static HttpTrailer create(HttpHeader httpHeader) {
        HttpTrailer httpTrailer = (HttpTrailer)ThreadCache.takeFromCache(CACHE_IDX);
        if (httpTrailer != null) {
            httpTrailer.httpHeader = httpHeader;
            return httpTrailer;
        }
        return new HttpTrailer(httpHeader);
    }

    public static Builder builder(HttpHeader httpHeader) {
        return new Builder(httpHeader);
    }

    protected HttpTrailer() {
        this(null);
    }

    protected HttpTrailer(HttpHeader httpHeader) {
        super(httpHeader);
    }

    @Override
    public final boolean isLast() {
        return true;
    }

    @Override
    public MimeHeaders getHeaders() {
        return this.headers;
    }

    @Override
    public String getHeader(String name) {
        return this.headers.getHeader(name);
    }

    @Override
    public void setHeader(String name, String value) {
        this.headers.setValue(name).setString(value);
    }

    @Override
    public void addHeader(String name, String value) {
        this.headers.addValue(name).setString(value);
    }

    @Override
    public boolean containsHeader(String name) {
        return this.headers.getHeader(name) != null;
    }

    protected void setHeaders(MimeHeaders mimeHeaders) {
        this.headers = mimeHeaders;
    }

    @Override
    protected void reset() {
        this.headers.recycle();
        super.reset();
    }

    @Override
    public void recycle() {
        this.reset();
        ThreadCache.putToCache(CACHE_IDX, (Object)this);
    }

    public static final class Builder
    extends HttpContent.Builder<Builder> {
        protected Builder(HttpHeader httpHeader) {
            this.packet = HttpTrailer.create(httpHeader);
        }

        public final Builder headers(MimeHeaders mimeHeaders) {
            ((HttpTrailer)this.packet).setHeaders(mimeHeaders);
            return this;
        }

        public final Builder header(String name, String value) {
            ((HttpTrailer)this.packet).setHeader(name, value);
            return this;
        }

        @Override
        public final HttpTrailer build() {
            return (HttpTrailer)this.packet;
        }
    }
}

