/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.util;

import java.nio.charset.Charset;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.http.util.Ascii;

public class BufferChunk {
    private static final Charset UTF8_CHARSET = Charset.forName("UTF-8");
    private Buffer buffer;
    private int start;
    private int end;
    private String cachedString;
    private Charset cachedStringCharset;
    private String stringValue;
    private boolean locked;

    public static BufferChunk newInstance() {
        return new BufferChunk();
    }

    protected BufferChunk() {
    }

    public void set(BufferChunk value) {
        if (this.locked) {
            return;
        }
        this.reset();
        if (value.hasBuffer()) {
            this.setBuffer(value.buffer, value.start, value.end);
            this.cachedString = value.cachedString;
            this.cachedStringCharset = value.cachedStringCharset;
        } else if (value.hasString()) {
            this.stringValue = value.stringValue;
        }
        this.onContentChanged();
    }

    public Buffer getBuffer() {
        return this.buffer;
    }

    public void setBuffer(Buffer buffer) {
        this.setBuffer(buffer, buffer.position(), buffer.limit());
    }

    public void setBuffer(Buffer buffer, int start, int end) {
        if (this.locked) {
            return;
        }
        this.buffer = buffer;
        this.start = start;
        this.end = end;
        this.resetString();
        this.resetStringCache();
        this.onContentChanged();
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        if (this.locked) {
            return;
        }
        this.start = start;
        this.resetStringCache();
        this.onContentChanged();
    }

    public int getEnd() {
        return this.end;
    }

    public void setEnd(int end) {
        if (this.locked) {
            return;
        }
        this.end = end;
        this.resetStringCache();
        this.onContentChanged();
    }

    public void setString(String string) {
        if (this.locked) {
            return;
        }
        this.stringValue = string;
        this.resetBuffer();
        this.onContentChanged();
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(Charset charset) {
        if (this.isNull()) {
            return null;
        }
        if (this.hasString()) {
            return this.stringValue;
        }
        if (charset == null) {
            charset = UTF8_CHARSET;
        }
        if (this.cachedString != null && charset.equals(this.cachedStringCharset)) {
            return this.cachedString;
        }
        this.cachedString = this.buffer.toStringContent(charset, this.start, this.end);
        this.cachedStringCharset = charset;
        return this.cachedString;
    }

    protected void onContentChanged() {
    }

    public int size() {
        if (this.hasBuffer()) {
            return this.end - this.start;
        }
        if (this.hasString()) {
            return this.stringValue.length();
        }
        return 0;
    }

    public int findBytesAscii(byte[] b) {
        byte first = b[0];
        int from = this.getStart();
        int to = this.getEnd();
        int srcEnd = b.length;
        for (int i = from; i <= to - srcEnd; ++i) {
            if (Ascii.toLower(this.buffer.get(i)) != first) continue;
            int myPos = i + 1;
            int srcPos = 1;
            while (srcPos < srcEnd && Ascii.toLower(this.buffer.get(myPos++)) == b[srcPos++]) {
                if (srcPos != srcEnd) continue;
                return i - from;
            }
        }
        return -1;
    }

    public int indexOf(char c, int fromIndex) {
        if (this.hasBuffer()) {
            int ret = BufferChunk.indexOf(this.buffer, this.start + fromIndex, this.end, c);
            return ret >= this.start ? ret - this.start : -1;
        }
        if (this.hasString()) {
            return this.stringValue.indexOf(c, fromIndex);
        }
        return -1;
    }

    public int indexOf(String s, int fromIndex) {
        if (this.hasBuffer()) {
            int ret = BufferChunk.indexOf(this.buffer, this.start + fromIndex, this.end, s);
            return ret >= this.start ? ret - this.start : -1;
        }
        if (this.hasString()) {
            return this.stringValue.indexOf(s, fromIndex);
        }
        return -1;
    }

    private static int indexOf(Buffer buffer, int off, int end, char qq) {
        while (off < end) {
            byte b = buffer.get(off);
            if (b == qq) {
                return off;
            }
            ++off;
        }
        return -1;
    }

    private static int indexOf(Buffer buffer, int off, int end, CharSequence s) {
        int strLen = s.length();
        if (strLen == 0) {
            return off;
        }
        if (strLen > end - off) {
            return -1;
        }
        int strOffs = 0;
        int lastOffs = end - strLen;
        while (off <= lastOffs + strOffs) {
            byte b = buffer.get(off);
            if (b == s.charAt(strOffs)) {
                if (++strOffs == strLen) {
                    return off - strLen + 1;
                }
            } else {
                strOffs = 0;
            }
            ++off;
        }
        return -1;
    }

    public boolean equals(String s) {
        if (!this.hasString()) {
            if (this.end - this.start != s.length()) {
                return false;
            }
            for (int i = this.start; i < this.end; ++i) {
                if (this.buffer.get(i) == s.charAt(i - this.start)) continue;
                return false;
            }
            return true;
        }
        return this.stringValue.equals(s);
    }

    public boolean equalsIgnoreCase(String s) {
        if (!this.hasString()) {
            if (this.end - this.start != s.length()) {
                return false;
            }
            for (int i = this.start; i < this.end; ++i) {
                if (Ascii.toLower(this.buffer.get(i)) == Ascii.toLower(s.charAt(i - this.start))) continue;
                return false;
            }
            return true;
        }
        return this.stringValue.equalsIgnoreCase(s);
    }

    public int compareIgnoreCase(int start, int end, String compareTo) {
        int result = 0;
        int len = compareTo.length();
        if (end - start < len) {
            len = end - start;
        }
        for (int i = 0; i < len && result == 0; ++i) {
            if (Ascii.toLower(this.buffer.get(i + start)) > Ascii.toLower(compareTo.charAt(i))) {
                result = 1;
                continue;
            }
            if (Ascii.toLower(this.buffer.get(i + start)) >= Ascii.toLower(compareTo.charAt(i))) continue;
            result = -1;
        }
        if (result == 0) {
            if (compareTo.length() > end - start) {
                result = -1;
            } else if (compareTo.length() < end - start) {
                result = 1;
            }
        }
        return result;
    }

    public int compare(int start, int end, String compareTo) {
        int result = 0;
        int len = compareTo.length();
        if (end - start < len) {
            len = end - start;
        }
        for (int i = 0; i < len && result == 0; ++i) {
            if (this.buffer.get(i + start) > compareTo.charAt(i)) {
                result = 1;
                continue;
            }
            if (this.buffer.get(i + start) >= compareTo.charAt(i)) continue;
            result = -1;
        }
        if (result == 0) {
            if (compareTo.length() > end - start) {
                result = -1;
            } else if (compareTo.length() < end - start) {
                result = 1;
            }
        }
        return result;
    }

    public boolean startsWithIgnoreCase(String s, int pos) {
        if (!this.hasString()) {
            int len = s.length();
            if (len > this.end - this.start - pos) {
                return false;
            }
            int off = this.start + pos;
            for (int i = 0; i < len; ++i) {
                if (Ascii.toLower(this.buffer.get(off++)) == Ascii.toLower(s.charAt(i))) continue;
                return false;
            }
            return true;
        }
        if (this.stringValue.length() < pos + s.length()) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (Ascii.toLower(s.charAt(i)) == Ascii.toLower(this.stringValue.charAt(pos + i))) continue;
            return false;
        }
        return true;
    }

    public boolean startsWith(String s, int pos) {
        if (!this.hasString()) {
            int len = s.length();
            if (len > this.end - this.start - pos) {
                return false;
            }
            int off = this.start + pos;
            for (int i = 0; i < len; ++i) {
                if (this.buffer.get(off++) == s.charAt(i)) continue;
                return false;
            }
            return true;
        }
        if (this.stringValue.length() < pos + s.length()) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == this.stringValue.charAt(pos + i)) continue;
            return false;
        }
        return true;
    }

    public final boolean hasBuffer() {
        return this.buffer != null;
    }

    public final boolean hasString() {
        return this.stringValue != null;
    }

    public final boolean isNull() {
        return !this.hasBuffer() && !this.hasString();
    }

    protected final void resetBuffer() {
        if (this.locked) {
            return;
        }
        this.start = -1;
        this.end = -1;
        this.buffer = null;
    }

    protected final void resetString() {
        if (this.locked) {
            return;
        }
        this.stringValue = null;
    }

    protected final void resetStringCache() {
        if (this.locked) {
            return;
        }
        this.cachedString = null;
        this.cachedStringCharset = null;
    }

    protected void reset() {
        if (this.locked) {
            return;
        }
        this.start = -1;
        this.end = -1;
        this.buffer = null;
        this.cachedString = null;
        this.cachedStringCharset = null;
        this.stringValue = null;
    }

    protected void lock() {
        this.locked = true;
    }

    protected void unlock() {
        this.locked = false;
    }

    public void recycle() {
        if (this.locked) {
            return;
        }
        this.reset();
    }
}

