/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.util;

import java.nio.BufferOverflowException;
import java.util.Date;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.http.Cookie;
import org.glassfish.grizzly.http.util.CookieUtils;
import org.glassfish.grizzly.http.util.UEncoder;

public class CookieSerializerUtils {
    public static void serializeServerCookie(StringBuilder buf, Cookie cookie) {
        CookieSerializerUtils.serializeServerCookie(buf, CookieUtils.COOKIE_VERSION_ONE_STRICT_COMPLIANCE, CookieUtils.ALWAYS_ADD_EXPIRES, cookie);
    }

    public static void serializeServerCookie(StringBuilder buf, boolean versionOneStrictCompliance, boolean alwaysAddExpires, Cookie cookie) {
        String path;
        int maxAge;
        String domain;
        buf.append(cookie.getName());
        buf.append("=");
        int version = CookieSerializerUtils.maybeQuote2(cookie.getVersion(), buf, cookie.getValue(), true);
        if (version == 1) {
            buf.append("; Version=1");
            String comment = cookie.getComment();
            if (comment != null) {
                buf.append("; Comment=");
                CookieSerializerUtils.maybeQuote2(version, buf, comment, versionOneStrictCompliance);
            }
        }
        if ((domain = cookie.getDomain()) != null) {
            buf.append("; Domain=");
            CookieSerializerUtils.maybeQuote2(version, buf, domain, versionOneStrictCompliance);
        }
        if ((maxAge = cookie.getMaxAge()) >= 0) {
            if (version > 0) {
                buf.append("; Max-Age=");
                buf.append(maxAge);
            }
            if (version == 0 || alwaysAddExpires) {
                buf.append("; Expires=");
                if (maxAge == 0) {
                    buf.append(CookieUtils.ancientDate);
                } else {
                    buf.append(CookieUtils.OLD_COOKIE_FORMAT.get().format(new Date(System.currentTimeMillis() + (long)maxAge * 1000L)));
                }
            }
        }
        if ((path = cookie.getPath()) != null) {
            buf.append("; Path=");
            UEncoder encoder = new UEncoder();
            encoder.addSafeCharacter('/');
            encoder.addSafeCharacter('\"');
            path = encoder.encodeURL(path, true);
            if (version == 0) {
                CookieSerializerUtils.maybeQuote2(version, buf, path, versionOneStrictCompliance);
            } else {
                CookieSerializerUtils.maybeQuote2(version, buf, path, "()<>@,;:\\\"[]?={} \t", false, versionOneStrictCompliance);
            }
        }
        if (cookie.isSecure()) {
            buf.append("; Secure");
        }
        if (cookie.isHttpOnly()) {
            buf.append("; HttpOnly");
        }
    }

    public static void serializeServerCookie(Buffer buf, Cookie cookie) {
        CookieSerializerUtils.serializeServerCookie(buf, CookieUtils.COOKIE_VERSION_ONE_STRICT_COMPLIANCE, CookieUtils.ALWAYS_ADD_EXPIRES, cookie);
    }

    public static void serializeServerCookie(Buffer buf, boolean versionOneStrictCompliance, boolean alwaysAddExpires, Cookie cookie) {
        String path;
        int maxAge;
        String domain;
        CookieSerializerUtils.put(buf, cookie.getName());
        CookieSerializerUtils.put(buf, 61);
        int version = CookieSerializerUtils.maybeQuote2(cookie.getVersion(), buf, cookie.getValue(), true);
        if (version == 1) {
            CookieSerializerUtils.put(buf, "; Version=1");
            String comment = cookie.getComment();
            if (comment != null) {
                CookieSerializerUtils.put(buf, "; Comment=");
                CookieSerializerUtils.maybeQuote2(version, buf, comment, versionOneStrictCompliance);
            }
        }
        if ((domain = cookie.getDomain()) != null) {
            CookieSerializerUtils.put(buf, "; Domain=");
            CookieSerializerUtils.maybeQuote2(version, buf, domain, versionOneStrictCompliance);
        }
        if ((maxAge = cookie.getMaxAge()) >= 0) {
            if (version > 0) {
                CookieSerializerUtils.put(buf, "; Max-Age=");
                CookieSerializerUtils.putInt(buf, maxAge);
            }
            if (version == 0 || alwaysAddExpires) {
                CookieSerializerUtils.put(buf, "; Expires=");
                if (maxAge == 0) {
                    CookieSerializerUtils.put(buf, CookieUtils.ancientDate);
                } else {
                    CookieSerializerUtils.put(buf, CookieUtils.OLD_COOKIE_FORMAT.get().format(new Date(System.currentTimeMillis() + (long)maxAge * 1000L)));
                }
            }
        }
        if ((path = cookie.getPath()) != null) {
            CookieSerializerUtils.put(buf, "; Path=");
            UEncoder encoder = new UEncoder();
            encoder.addSafeCharacter('/');
            encoder.addSafeCharacter('\"');
            path = encoder.encodeURL(path, true);
            if (version == 0) {
                CookieSerializerUtils.maybeQuote2(version, buf, path, versionOneStrictCompliance);
            } else {
                CookieSerializerUtils.maybeQuote2(version, buf, path, "()<>@,;:\\\"[]?={} \t", false, versionOneStrictCompliance);
            }
        }
        if (cookie.isSecure()) {
            CookieSerializerUtils.put(buf, "; Secure");
        }
        if (cookie.isHttpOnly()) {
            CookieSerializerUtils.put(buf, "; HttpOnly");
        }
    }

    public static void serializeClientCookies(StringBuilder buf, Cookie ... cookies) {
        CookieSerializerUtils.serializeClientCookies(buf, CookieUtils.COOKIE_VERSION_ONE_STRICT_COMPLIANCE, cookies);
    }

    public static void serializeClientCookies(StringBuilder buf, boolean versionOneStrictCompliance, Cookie ... cookies) {
        if (cookies.length == 0) {
            return;
        }
        int version = cookies[0].getVersion();
        if (version == 1) {
            buf.append("$Version=\"1\"; ");
        }
        for (int i = 0; i < cookies.length; ++i) {
            Cookie cookie = cookies[i];
            buf.append(cookie.getName());
            buf.append("=");
            CookieSerializerUtils.maybeQuote2(version, buf, cookie.getValue(), true);
            if (version == 1) {
                String path;
                String domain = cookie.getDomain();
                if (domain != null) {
                    buf.append("; $Domain=");
                    CookieSerializerUtils.maybeQuote2(version, buf, domain, versionOneStrictCompliance);
                }
                if ((path = cookie.getPath()) != null) {
                    buf.append("; $Path=");
                    UEncoder encoder = new UEncoder();
                    encoder.addSafeCharacter('/');
                    encoder.addSafeCharacter('\"');
                    path = encoder.encodeURL(path, true);
                    CookieSerializerUtils.maybeQuote2(version, buf, path, "()<>@,;:\\\"[]?={} \t", false, versionOneStrictCompliance);
                }
            }
            if (i >= cookies.length - 1) continue;
            buf.append("; ");
        }
    }

    public static void serializeClientCookies(Buffer buf, Cookie ... cookies) {
        CookieSerializerUtils.serializeClientCookies(buf, CookieUtils.COOKIE_VERSION_ONE_STRICT_COMPLIANCE, cookies);
    }

    public static void serializeClientCookies(Buffer buf, boolean versionOneStrictCompliance, Cookie ... cookies) {
        if (cookies.length == 0) {
            return;
        }
        int version = cookies[0].getVersion();
        if (version == 1) {
            CookieSerializerUtils.put(buf, "$Version=\"1\"; ");
        }
        for (int i = 0; i < cookies.length; ++i) {
            Cookie cookie = cookies[i];
            CookieSerializerUtils.put(buf, cookie.getName());
            CookieSerializerUtils.put(buf, "=");
            CookieSerializerUtils.maybeQuote2(version, buf, cookie.getValue(), true);
            if (version == 1) {
                String path;
                String domain = cookie.getDomain();
                if (domain != null) {
                    CookieSerializerUtils.put(buf, "; $Domain=");
                    CookieSerializerUtils.maybeQuote2(version, buf, domain, versionOneStrictCompliance);
                }
                if ((path = cookie.getPath()) != null) {
                    CookieSerializerUtils.put(buf, "; $Path=");
                    UEncoder encoder = new UEncoder();
                    encoder.addSafeCharacter('/');
                    encoder.addSafeCharacter('\"');
                    path = encoder.encodeURL(path, true);
                    CookieSerializerUtils.maybeQuote2(version, buf, path, "()<>@,;:\\\"[]?={} \t", false, versionOneStrictCompliance);
                }
            }
            if (i >= cookies.length - 1) continue;
            CookieSerializerUtils.put(buf, "; ");
        }
    }

    public static int maybeQuote2(int version, StringBuilder buf, String value, boolean versionOneStrictCompliance) {
        return CookieSerializerUtils.maybeQuote2(version, buf, value, false, versionOneStrictCompliance);
    }

    public static int maybeQuote2(int version, StringBuilder buf, String value, boolean allowVersionSwitch, boolean versionOneStrictCompliance) {
        return CookieSerializerUtils.maybeQuote2(version, buf, value, null, allowVersionSwitch, versionOneStrictCompliance);
    }

    public static int maybeQuote2(int version, StringBuilder buf, String value, String literals, boolean allowVersionSwitch, boolean versionOneStrictCompliance) {
        if (value == null || value.length() == 0) {
            buf.append("\"\"");
        } else {
            if (CookieUtils.containsCTL(value, version)) {
                throw new IllegalArgumentException("Control character in cookie value, consider BASE64 encoding your value");
            }
            if (CookieSerializerUtils.alreadyQuoted(value)) {
                buf.append('\"');
                buf.append(CookieSerializerUtils.escapeDoubleQuotes(value, 1, value.length() - 1));
                buf.append('\"');
            } else if (allowVersionSwitch && versionOneStrictCompliance && version == 0 && !CookieUtils.isToken2(value, literals)) {
                buf.append('\"');
                buf.append(CookieSerializerUtils.escapeDoubleQuotes(value, 0, value.length()));
                buf.append('\"');
                version = 1;
            } else if (version == 0 && !CookieUtils.isToken(value, literals)) {
                buf.append('\"');
                buf.append(CookieSerializerUtils.escapeDoubleQuotes(value, 0, value.length()));
                buf.append('\"');
            } else if (version == 1 && !CookieUtils.isToken2(value, literals)) {
                buf.append('\"');
                buf.append(CookieSerializerUtils.escapeDoubleQuotes(value, 0, value.length()));
                buf.append('\"');
            } else {
                buf.append(value);
            }
        }
        return version;
    }

    public static int maybeQuote2(int version, Buffer buf, String value, boolean versionOneStrictCompliance) {
        return CookieSerializerUtils.maybeQuote2(version, buf, value, false, versionOneStrictCompliance);
    }

    public static int maybeQuote2(int version, Buffer buf, String value, boolean allowVersionSwitch, boolean versionOneStrictCompliance) {
        return CookieSerializerUtils.maybeQuote2(version, buf, value, null, allowVersionSwitch, versionOneStrictCompliance);
    }

    public static int maybeQuote2(int version, Buffer buf, String value, String literals, boolean allowVersionSwitch, boolean versionOneStrictCompliance) {
        if (value == null || value.length() == 0) {
            CookieSerializerUtils.put(buf, "\"\"");
        } else {
            if (CookieUtils.containsCTL(value, version)) {
                throw new IllegalArgumentException("Control character in cookie value, consider BASE64 encoding your value");
            }
            if (CookieSerializerUtils.alreadyQuoted(value)) {
                CookieSerializerUtils.put(buf, 34);
                CookieSerializerUtils.put(buf, CookieSerializerUtils.escapeDoubleQuotes(value, 1, value.length() - 1));
                CookieSerializerUtils.put(buf, 34);
            } else if (allowVersionSwitch && versionOneStrictCompliance && version == 0 && !CookieUtils.isToken2(value, literals)) {
                CookieSerializerUtils.put(buf, 34);
                CookieSerializerUtils.put(buf, CookieSerializerUtils.escapeDoubleQuotes(value, 0, value.length()));
                CookieSerializerUtils.put(buf, 34);
                version = 1;
            } else if (version == 0 && !CookieUtils.isToken(value, literals)) {
                CookieSerializerUtils.put(buf, 34);
                CookieSerializerUtils.put(buf, CookieSerializerUtils.escapeDoubleQuotes(value, 0, value.length()));
                CookieSerializerUtils.put(buf, 34);
            } else if (version == 1 && !CookieUtils.isToken2(value, literals)) {
                CookieSerializerUtils.put(buf, 34);
                CookieSerializerUtils.put(buf, CookieSerializerUtils.escapeDoubleQuotes(value, 0, value.length()));
                CookieSerializerUtils.put(buf, 34);
            } else {
                CookieSerializerUtils.put(buf, value);
            }
        }
        return version;
    }

    private static String escapeDoubleQuotes(String s, int beginIndex, int endIndex) {
        if (s == null || s.length() == 0 || s.indexOf(34) == -1) {
            return s;
        }
        StringBuilder b = new StringBuilder();
        for (int i = beginIndex; i < endIndex; ++i) {
            char c = s.charAt(i);
            if (c == '\\') {
                b.append(c);
                if (++i >= endIndex) {
                    throw new IllegalArgumentException("Invalid escape character in cookie value.");
                }
                b.append(s.charAt(i));
                continue;
            }
            if (c == '\"') {
                b.append('\\').append('\"');
                continue;
            }
            b.append(c);
        }
        return b.toString();
    }

    public static boolean alreadyQuoted(String value) {
        return value != null && value.length() != 0 && value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"';
    }

    static void put(Buffer dstBuffer, int c) {
        dstBuffer.put((byte)c);
    }

    static void putInt(Buffer dstBuffer, int intValue) {
        CookieSerializerUtils.put(dstBuffer, Integer.toString(intValue));
    }

    static void put(Buffer dstBuffer, String s) {
        int size = s.length();
        if (dstBuffer.remaining() < size) {
            throw new BufferOverflowException();
        }
        for (int i = 0; i < size; ++i) {
            dstBuffer.put((byte)s.charAt(i));
        }
    }

    static void put(StringBuilder dstBuffer, int c) {
        dstBuffer.append((char)c);
    }

    static void putInt(StringBuilder dstBuffer, int intValue) {
        dstBuffer.append(intValue);
    }

    static void put(StringBuilder dstBuffer, String s) {
        dstBuffer.append(s);
    }
}

