/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.util;

import java.io.CharConversionException;
import java.nio.charset.Charset;
import org.glassfish.grizzly.http.util.BufferChunk;
import org.glassfish.grizzly.http.util.URLDecoder;

public class RequestURIRef {
    private static final Charset UTF8_CHARSET = Charset.forName("UTF-8");
    private final BufferChunk requestURIBC = BufferChunk.newInstance();
    private boolean isDecoded;
    private boolean wasSlashAllowed = true;

    public final BufferChunk getRequestURIBC() {
        return this.requestURIBC;
    }

    public final BufferChunk getDecodedRequestURIBC() throws CharConversionException {
        return this.getDecodedRequestURIBC(this.wasSlashAllowed);
    }

    public BufferChunk getDecodedRequestURIBC(boolean isSlashAllowed) throws CharConversionException {
        if (this.isDecoded) {
            if (isSlashAllowed != this.wasSlashAllowed) {
                throw new IllegalStateException("URI was already decoded with isSlashAllowed=" + this.wasSlashAllowed);
            }
            return this.requestURIBC;
        }
        URLDecoder.decode(this.requestURIBC, isSlashAllowed);
        this.wasSlashAllowed = isSlashAllowed;
        this.isDecoded = true;
        return this.requestURIBC;
    }

    public String getURI() {
        return this.getURI(null);
    }

    public String getURI(Charset charset) {
        return this.requestURIBC.toString(charset);
    }

    public void setURI(String uri) {
        this.requestURIBC.setString(uri);
    }

    public final String getDecodedURI() throws CharConversionException {
        return this.getDecodedURI(this.wasSlashAllowed);
    }

    public final String getDecodedURI(boolean isSlashAllowed) throws CharConversionException {
        return this.getDecodedURI(isSlashAllowed, null);
    }

    public String getDecodedURI(boolean isSlashAllowed, Charset charset) throws CharConversionException {
        if (this.isDecoded) {
            if (isSlashAllowed != this.wasSlashAllowed) {
                throw new IllegalStateException("URI was already decoded with isSlashAllowed=" + this.wasSlashAllowed);
            }
            return this.requestURIBC.toString(charset);
        }
        if (!this.requestURIBC.hasString()) {
            URLDecoder.decode(this.requestURIBC, isSlashAllowed);
        } else {
            if (charset == null) {
                charset = UTF8_CHARSET;
            }
            this.requestURIBC.setString(URLDecoder.decode(this.requestURIBC.toString(charset), isSlashAllowed));
        }
        this.wasSlashAllowed = isSlashAllowed;
        this.isDecoded = true;
        return this.requestURIBC.toString(charset);
    }

    public void setDecodedURI(String uri) {
        this.requestURIBC.setString(uri);
        this.isDecoded = true;
    }

    public boolean isDecoded() {
        return this.isDecoded;
    }

    public void setDecoded(boolean isDecoded) {
        this.isDecoded = isDecoded;
    }

    public void recycle() {
        this.requestURIBC.recycle();
        this.isDecoded = false;
        this.wasSlashAllowed = true;
    }
}

