/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.util;

import java.io.CharConversionException;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.http.util.BufferChunk;
import org.glassfish.grizzly.http.util.HexUtils;

public class URLDecoder {
    public static void decode(BufferChunk bufferChunk) throws CharConversionException {
        URLDecoder.decode(bufferChunk, true);
    }

    public static void decode(BufferChunk bufferChunk, boolean allowEncodedSlash) throws CharConversionException {
        Buffer buffer = bufferChunk.getBuffer();
        int start = bufferChunk.getStart();
        int end = bufferChunk.getEnd();
        int idx = start;
        int j = start;
        while (j < end) {
            byte b = buffer.get(j);
            if (b == 43) {
                buffer.put(idx, (byte)32);
            } else if (b != 37) {
                buffer.put(idx, b);
            } else {
                if (j + 2 >= end) {
                    throw new IllegalStateException("Unexpected termination");
                }
                byte b1 = buffer.get(j + 1);
                byte b2 = buffer.get(j + 2);
                if (!HexUtils.isHexDigit(b1) || !HexUtils.isHexDigit(b2)) {
                    throw new IllegalStateException("isHexDigit");
                }
                j += 2;
                int res = URLDecoder.x2c(b1, b2);
                if (!allowEncodedSlash && res == 47) {
                    throw new CharConversionException("Encoded slashes are not allowed");
                }
                buffer.put(idx, (byte)res);
            }
            ++j;
            ++idx;
        }
        bufferChunk.setEnd(idx);
    }

    public static String decode(String str) throws CharConversionException {
        return URLDecoder.decode(str, true);
    }

    public static String decode(String str, boolean allowEncodedSlash) throws CharConversionException {
        if (str == null) {
            return null;
        }
        int strPos = str.indexOf(37);
        if (strPos < 0) {
            return str;
        }
        int strLen = str.length();
        StringBuilder dec = new StringBuilder(strLen);
        while (strPos < strLen) {
            char laChar;
            int laPos;
            for (laPos = strPos; laPos < strLen && (laChar = str.charAt(laPos)) != '%'; ++laPos) {
            }
            if (laPos > strPos) {
                dec.append(str.substring(strPos, laPos));
                strPos = laPos;
            }
            if (strPos >= strLen) break;
            char metaChar = str.charAt(strPos);
            if (metaChar == '+') {
                dec.append(' ');
                ++strPos;
                continue;
            }
            if (metaChar != '%') continue;
            char res = (char)Integer.parseInt(str.substring(strPos + 1, strPos + 3), 16);
            if (!allowEncodedSlash && res == '/') {
                throw new CharConversionException("Encoded slashes are not allowed");
            }
            dec.append(res);
            strPos += 3;
        }
        return dec.toString();
    }

    private static int x2c(byte b1, byte b2) {
        return (HexUtils.hexDigit2Dec(b1) << 4) + HexUtils.hexDigit2Dec(b2);
    }
}

