/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.util;

import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.glassfish.grizzly.http.util.BufferChunk;
import org.glassfish.grizzly.http.util.HttpStatus;

public class Utils {
    private static ConcurrentHashMap<String, Charset> charsetAliasMap = new ConcurrentHashMap();
    private static HashMap<Integer, BufferChunk> statusMessages = new HashMap();

    public static Charset lookupCharset(String charsetName) {
        Charset charset = charsetAliasMap.get(charsetName);
        if (charset == null) {
            charset = Charset.forName(charsetName);
            charsetAliasMap.putIfAbsent(charsetName, charset);
        }
        return charset;
    }

    public static BufferChunk getHttpStatusMessage(int httpStatus) {
        return statusMessages.get(httpStatus);
    }

    static {
        for (HttpStatus status : HttpStatus.values()) {
            statusMessages.put(status.getStatusCode(), status.getReasonPhraseBC());
        }
    }
}

