/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http;

import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.TransformationResult;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.http.ContentEncoding;
import org.glassfish.grizzly.http.EncodingFilter;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.ParsingResult;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.zip.GZipDecoder;
import org.glassfish.grizzly.zip.GZipEncoder;

public class GZipContentEncoding
implements ContentEncoding {
    public static final int DEFAULT_IN_BUFFER_SIZE = 512;
    public static final int DEFAULT_OUT_BUFFER_SIZE = 512;
    public static final String[] ALIASES = new String[]{"gzip", "deflate"};
    private final String name = "gzip";
    private final GZipDecoder decoder;
    private final GZipEncoder encoder;
    private final EncodingFilter encoderFilter;

    public GZipContentEncoding() {
        this(512, 512);
    }

    public GZipContentEncoding(int inBufferSize, int outBufferSize) {
        this(inBufferSize, outBufferSize, null);
    }

    public GZipContentEncoding(int inBufferSize, int outBufferSize, EncodingFilter encoderFilter) {
        this.decoder = new GZipDecoder(inBufferSize);
        this.encoder = new GZipEncoder(outBufferSize);
        this.encoderFilter = encoderFilter != null ? encoderFilter : new EncodingFilter(){

            @Override
            public boolean applyEncoding(HttpHeader httpPacket) {
                return false;
            }
        };
    }

    @Override
    public String getName() {
        return "gzip";
    }

    @Override
    public String[] getAliases() {
        return ALIASES;
    }

    @Override
    public boolean wantEncode(HttpHeader header) {
        return this.encoderFilter.applyEncoding(header);
    }

    @Override
    public ParsingResult decode(Connection connection, HttpContent httpContent) {
        Buffer input;
        HttpHeader httpHeader = httpContent.getHttpHeader();
        TransformationResult result = this.decoder.transform((AttributeStorage)httpHeader, (Object)(input = httpContent.getContent()));
        Buffer remainder = (Buffer)result.getExternalRemainder();
        if (remainder == null || !remainder.hasRemaining()) {
            input.tryDispose();
            remainder = null;
        } else {
            input.shrink();
        }
        try {
            switch (result.getStatus()) {
                case COMPLETED: {
                    httpContent.setContent((Buffer)result.getMessage());
                    ParsingResult parsingResult = ParsingResult.create(httpContent, remainder);
                    return parsingResult;
                }
                case INCOMPLETED: {
                    ParsingResult parsingResult = ParsingResult.create(null, remainder);
                    return parsingResult;
                }
                case ERROR: {
                    throw new IllegalStateException("GZip decode error. Code: " + result.getErrorCode() + " Description: " + result.getErrorDescription());
                }
            }
            throw new IllegalStateException("Unexpected status: " + result.getStatus());
        }
        finally {
            result.recycle();
        }
    }

    @Override
    public HttpContent encode(Connection connection, HttpContent httpContent) {
        HttpHeader httpHeader = httpContent.getHttpHeader();
        Buffer input = httpContent.getContent();
        if (httpContent.isLast() && !input.hasRemaining()) {
            return httpContent;
        }
        TransformationResult result = this.encoder.transform((AttributeStorage)httpHeader, (Object)input);
        input.tryDispose();
        try {
            switch (result.getStatus()) {
                case COMPLETED: 
                case INCOMPLETED: {
                    Buffer encodedBuffer = (Buffer)result.getMessage();
                    Buffer finishBuffer = this.encoder.finish((AttributeStorage)httpHeader);
                    encodedBuffer = Buffers.appendBuffers((MemoryManager)connection.getTransport().getMemoryManager(), (Buffer)encodedBuffer, (Buffer)finishBuffer);
                    if (encodedBuffer != null) {
                        httpContent.setContent(encodedBuffer);
                        HttpContent httpContent2 = httpContent;
                        return httpContent2;
                    }
                    HttpContent httpContent3 = null;
                    return httpContent3;
                }
                case ERROR: {
                    throw new IllegalStateException("GZip decode error. Code: " + result.getErrorCode() + " Description: " + result.getErrorDescription());
                }
            }
            throw new IllegalStateException("Unexpected status: " + result.getStatus());
        }
        finally {
            result.recycle();
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GZipContentEncoding other = (GZipContentEncoding)obj;
        return this.name.equals(other.name);
    }

    public int hashCode() {
        int hash = 3;
        hash = 53 * hash + this.name.hashCode();
        return hash;
    }
}

