/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpRequestPacketImpl;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.util.DataChunk;
import org.glassfish.grizzly.http.util.MimeHeaders;
import org.glassfish.grizzly.http.util.RequestURIRef;

public abstract class HttpRequestPacket
extends HttpHeader {
    private Connection connection;
    private HttpResponsePacket response;
    private int serverPort = -1;
    private int remotePort = -1;
    private int localPort = -1;
    private RequestURIRef requestURIRef = new RequestURIRef();
    private String localHost;
    private final DataChunk methodC = DataChunk.newInstance();
    private final DataChunk queryC = DataChunk.newInstance();
    private final DataChunk remoteAddressC = DataChunk.newInstance();
    private final DataChunk remoteHostC = DataChunk.newInstance();
    private final DataChunk localNameC = DataChunk.newInstance();
    private final DataChunk localAddressC = DataChunk.newInstance();
    private final DataChunk serverNameC = DataChunk.newInstance();
    private boolean requiresAcknowledgement;

    public static Builder builder() {
        return new Builder();
    }

    protected HttpRequestPacket() {
        this.methodC.setString("GET");
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public HttpResponsePacket getResponse() {
        return this.response;
    }

    public DataChunk getMethodDC() {
        return this.methodC;
    }

    public String getMethod() {
        return this.methodC.toString();
    }

    public void setMethod(String method) {
        this.methodC.setString(method);
    }

    public RequestURIRef getRequestURIRef() {
        return this.requestURIRef;
    }

    public String getRequestURI() {
        return this.requestURIRef.getURI();
    }

    public void setRequestURI(String requestURI) {
        this.requestURIRef.setURI(requestURI);
    }

    public DataChunk getQueryStringDC() {
        return this.queryC;
    }

    public String getQueryString() {
        return this.queryC.isNull() ? null : this.queryC.toString();
    }

    public void setQueryString(String query) {
        this.queryC.setString(query);
    }

    public DataChunk serverName() {
        return this.serverNameC;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    public DataChunk remoteAddr() {
        if (this.remoteAddressC.isNull()) {
            this.remoteAddressC.setString(((InetSocketAddress)this.connection.getPeerAddress()).getAddress().getHostAddress());
        }
        return this.remoteAddressC;
    }

    public String getRemoteAddress() {
        return this.remoteAddr().toString();
    }

    public DataChunk remoteHost() {
        if (this.remoteHostC.isNull()) {
            String remoteHost = null;
            InetAddress inetAddr = ((InetSocketAddress)this.connection.getPeerAddress()).getAddress();
            if (inetAddr != null) {
                remoteHost = inetAddr.getHostName();
            }
            if (remoteHost == null) {
                if (!this.remoteAddressC.isNull()) {
                    remoteHost = this.remoteAddressC.toString();
                } else {
                    this.remoteHostC.recycle();
                }
            }
            this.remoteHostC.setString(remoteHost);
        }
        return this.remoteHostC;
    }

    public String getRemoteHost() {
        return this.remoteHost().toString();
    }

    protected void requiresAcknowledgement(boolean requiresAcknowledgement) {
        this.requiresAcknowledgement = requiresAcknowledgement;
    }

    public boolean requiresAcknowledgement() {
        return this.requiresAcknowledgement;
    }

    public DataChunk localName() {
        if (this.localNameC.isNull()) {
            InetAddress inetAddr = ((InetSocketAddress)this.connection.getLocalAddress()).getAddress();
            this.localNameC.setString(inetAddr.getHostName());
        }
        return this.localNameC;
    }

    public String getLocalName() {
        return this.localName().toString();
    }

    public DataChunk localAddr() {
        if (this.localAddressC.isNull()) {
            InetAddress inetAddr = ((InetSocketAddress)this.connection.getLocalAddress()).getAddress();
            this.localAddressC.setString(inetAddr.getHostAddress());
        }
        return this.localAddressC;
    }

    public String getLocalAddress() {
        return this.localAddr().toString();
    }

    public int getRemotePort() {
        if (this.remotePort == -1) {
            this.remotePort = ((InetSocketAddress)this.connection.getPeerAddress()).getPort();
        }
        return this.remotePort;
    }

    public void setRemotePort(int port) {
        this.remotePort = port;
    }

    public int getLocalPort() {
        if (this.localPort == -1) {
            this.localPort = ((InetSocketAddress)this.connection.getLocalAddress()).getPort();
        }
        return this.localPort;
    }

    public void setLocalPort(int port) {
        this.localPort = port;
    }

    public String getLocalHost() {
        return this.localHost;
    }

    public void setLocalHost(String host) {
        this.localHost = host;
    }

    @Override
    protected void reset() {
        this.requestURIRef.recycle();
        this.queryC.recycle();
        this.protocolC.recycle();
        this.methodC.recycle();
        this.remoteAddressC.recycle();
        this.remoteHostC.recycle();
        this.localAddressC.recycle();
        this.localNameC.recycle();
        this.serverNameC.recycle();
        this.requiresAcknowledgement = false;
        this.remotePort = -1;
        this.localPort = -1;
        this.serverPort = -1;
        this.connection = null;
        this.localHost = null;
        this.response = null;
        super.reset();
    }

    @Override
    public final boolean isRequest() {
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(256);
        sb.append("HttpRequestPacket (\n   method=").append(this.getMethod()).append("\n   url=").append(this.getRequestURI()).append("\n   query=").append(this.getQueryString()).append("\n   protocol=").append((Object)this.getProtocol()).append("\n   content-length=").append(this.getContentLength()).append("\n   headers=[");
        MimeHeaders headersLocal = this.getHeaders();
        for (String name : headersLocal.names()) {
            sb.append("\n      ").append(name).append('=').append(headersLocal.getHeader(name));
        }
        sb.append("]\n)");
        return sb.toString();
    }

    void setResponse(HttpResponsePacket response) {
        this.response = response;
    }

    public static class Builder
    extends HttpHeader.Builder<Builder> {
        protected Builder() {
            this.packet = HttpRequestPacketImpl.create();
        }

        public Builder method(String method) {
            ((HttpRequestPacket)this.packet).setMethod(method);
            return this;
        }

        public Builder uri(String uri) {
            ((HttpRequestPacket)this.packet).setRequestURI(uri);
            return this;
        }

        public Builder query(String query) {
            ((HttpRequestPacket)this.packet).setQueryString(query);
            return this;
        }

        public final HttpRequestPacket build() {
            return (HttpRequestPacket)this.packet;
        }
    }
}

