/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http;

import java.util.Locale;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacketImpl;
import org.glassfish.grizzly.http.util.DataChunk;
import org.glassfish.grizzly.http.util.Utils;

public abstract class HttpResponsePacket
extends HttpHeader {
    public static final int NON_PARSED_STATUS = Integer.MIN_VALUE;
    private HttpRequestPacket request;
    private Locale locale;
    private String contentLanguage;
    protected int parsedStatusInt = Integer.MIN_VALUE;
    protected final DataChunk statusC = new StatusDataChunk();
    private final DataChunk reasonPhraseC = DataChunk.newInstance();
    private boolean acknowledgment;
    private boolean allowCustomReasonPhrase = true;

    public static Builder builder(HttpRequestPacket request) {
        return new Builder(request);
    }

    protected HttpResponsePacket() {
    }

    public DataChunk getStatusDC() {
        return this.statusC;
    }

    public int getStatus() {
        if (this.parsedStatusInt == Integer.MIN_VALUE) {
            this.parsedStatusInt = Integer.parseInt(this.statusC.toString());
        }
        return this.parsedStatusInt;
    }

    public void setStatus(int status) {
        Buffer b = Utils.getHttpStatus(status);
        this.statusC.setBuffer(b, b.position(), b.limit());
        this.parsedStatusInt = status;
    }

    public void setStatus(int status, Buffer statusBuffer) {
        this.statusC.setBuffer(statusBuffer, statusBuffer.position(), statusBuffer.limit());
        this.parsedStatusInt = status;
    }

    public final boolean isAllowCustomReasonPhrase() {
        return this.allowCustomReasonPhrase;
    }

    public final void setAllowCustomReasonPhrase(boolean allowCustomReasonPhrase) {
        this.allowCustomReasonPhrase = allowCustomReasonPhrase;
    }

    public final DataChunk getReasonPhraseRawDC() {
        return this.reasonPhraseC;
    }

    public final DataChunk getReasonPhraseDC() {
        if (this.allowCustomReasonPhrase && !this.reasonPhraseC.isNull()) {
            return this.reasonPhraseC;
        }
        Buffer b = Utils.getHttpStatusMessage(this.getStatus());
        this.reasonPhraseC.setBuffer(b, b.position(), b.limit());
        return this.reasonPhraseC;
    }

    public final String getReasonPhrase() {
        return this.getReasonPhraseDC().toString();
    }

    public void setReasonPhrase(String message) {
        this.reasonPhraseC.setString(message);
    }

    public void setReasonPhrase(Buffer reason) {
        this.reasonPhraseC.setBuffer(reason, reason.position(), reason.limit());
    }

    public HttpRequestPacket getRequest() {
        return this.request;
    }

    public boolean isAcknowledgement() {
        return this.acknowledgment;
    }

    public void setAcknowledgement(boolean acknowledgement) {
        this.acknowledgment = acknowledgement;
    }

    public void acknowledged() {
        this.request.requiresAcknowledgement(false);
        this.acknowledgment = false;
        this.parsedStatusInt = Integer.MIN_VALUE;
        this.reasonPhraseC.recycle();
    }

    @Override
    protected void reset() {
        this.statusC.recycle();
        this.parsedStatusInt = Integer.MIN_VALUE;
        this.acknowledgment = false;
        this.allowCustomReasonPhrase = true;
        this.reasonPhraseC.recycle();
        this.locale = null;
        this.contentLanguage = null;
        this.request = null;
        super.reset();
    }

    @Override
    public final boolean isRequest() {
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(256);
        sb.append("HttpResponsePacket (status=").append(this.getStatus()).append(" reason=").append(this.getReasonPhrase()).append(" protocol=").append((Object)this.getProtocol()).append(" content-length=").append(this.getContentLength()).append(" headers=").append(this.getHeaders()).append(" committed=").append(this.isCommitted()).append(')');
        return sb.toString();
    }

    @Override
    public void setHeader(String name, String value) {
        char c = name.charAt(0);
        if ((c == 'C' || c == 'c') && this.checkSpecialHeader(name, value)) {
            return;
        }
        super.setHeader(name, value);
    }

    @Override
    public void addHeader(String name, String value) {
        char c = name.charAt(0);
        if ((c == 'C' || c == 'c') && this.checkSpecialHeader(name, value)) {
            return;
        }
        super.addHeader(name, value);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        if (locale == null) {
            return;
        }
        this.locale = locale;
        this.contentLanguage = locale.getLanguage();
        if (this.contentLanguage != null && this.contentLanguage.length() > 0) {
            String country = locale.getCountry();
            StringBuilder value = new StringBuilder(this.contentLanguage);
            if (country != null && country.length() > 0) {
                value.append('-');
                value.append(country);
            }
            this.contentLanguage = value.toString();
        }
    }

    public String getContentLanguage() {
        return this.contentLanguage;
    }

    public void setContentLanguage(String contentLanguage) {
        this.contentLanguage = contentLanguage;
    }

    public void setRequest(HttpRequestPacket request) {
        this.request = request;
    }

    private boolean checkSpecialHeader(String name, String value) {
        if (name.equalsIgnoreCase("Content-Type")) {
            this.setContentType(value);
            return true;
        }
        if (name.equalsIgnoreCase("Content-Length")) {
            try {
                int cL = Integer.parseInt(value);
                this.setContentLength(cL);
                return true;
            }
            catch (NumberFormatException ex) {
                return false;
            }
        }
        if (name.equalsIgnoreCase("Content-Language")) {
            // empty if block
        }
        return false;
    }

    public static class Builder
    extends HttpHeader.Builder<Builder> {
        protected Builder(HttpRequestPacket request) {
            this.packet = request.getResponse();
            if (this.packet == null) {
                this.packet = HttpResponsePacketImpl.create();
                ((HttpResponsePacket)this.packet).setRequest(request);
                this.packet.setSecure(request.isSecure());
            }
        }

        public Builder status(int status) {
            ((HttpResponsePacket)this.packet).setStatus(status);
            return this;
        }

        public Builder reasonPhrase(String reasonPhrase) {
            ((HttpResponsePacket)this.packet).setReasonPhrase(reasonPhrase);
            return this;
        }

        public final HttpResponsePacket build() {
            return (HttpResponsePacket)this.packet;
        }
    }

    private class StatusDataChunk
    extends DataChunk {
        private StatusDataChunk() {
        }

        @Override
        protected void onContentChanged() {
            HttpResponsePacket.this.parsedStatusInt = Integer.MIN_VALUE;
        }
    }
}

