/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.EmptyCompletionHandler;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.WriteResult;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.http.GZipContentEncoding;
import org.glassfish.grizzly.http.HttpCodecFilter;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpPacket;
import org.glassfish.grizzly.http.HttpPacketParsing;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpRequestPacketImpl;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.HttpResponsePacketImpl;
import org.glassfish.grizzly.http.KeepAlive;
import org.glassfish.grizzly.http.ProcessingState;
import org.glassfish.grizzly.http.Protocol;
import org.glassfish.grizzly.http.util.BufferChunk;
import org.glassfish.grizzly.http.util.Constants;
import org.glassfish.grizzly.http.util.DataChunk;
import org.glassfish.grizzly.http.util.FastHttpDateFormat;
import org.glassfish.grizzly.http.util.HexUtils;
import org.glassfish.grizzly.http.util.HttpStatus;
import org.glassfish.grizzly.http.util.MimeHeaders;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.utils.DelayedExecutor;

public class HttpServerFilter
extends HttpCodecFilter {
    public static final Object RESPONSE_COMPLETE_EVENT = new Object();
    private static final FlushAndCloseHandler FLUSH_AND_CLOSE_HANDLER = new FlushAndCloseHandler();
    private final Attribute<HttpRequestPacketImpl> httpRequestInProcessAttr = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute("HttpServerFilter.HttpRequest");
    private final Attribute<KeepAliveContext> keepAliveContextAttr = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute("HttpServerFilter.KeepAliveContext");
    private final DelayedExecutor.DelayQueue<KeepAliveContext> keepAliveQueue;
    private final KeepAlive keepAlive;
    private final boolean processKeepAlive;
    private boolean authPassthroughEnabled;
    private boolean traceEnabled;

    public HttpServerFilter() {
        this(null, true, 8192, null, null);
    }

    public HttpServerFilter(boolean chunkingEnabled, int maxHeadersSize, KeepAlive keepAlive, DelayedExecutor executor) {
        this(null, chunkingEnabled, maxHeadersSize, keepAlive, executor);
    }

    public HttpServerFilter(Boolean isSecure, boolean chunkingEnabled, int maxHeadersSize, KeepAlive keepAlive, DelayedExecutor executor) {
        super(isSecure, chunkingEnabled, maxHeadersSize);
        if (executor != null) {
            this.keepAliveQueue = executor.createDelayQueue((DelayedExecutor.Worker)new KeepAliveWorker(keepAlive), (DelayedExecutor.Resolver)new KeepAliveResolver());
            this.keepAlive = keepAlive;
            this.processKeepAlive = true;
        } else {
            this.keepAliveQueue = null;
            this.keepAlive = null;
            this.processKeepAlive = false;
        }
        GZipContentEncoding enc = new GZipContentEncoding(512, 512);
        this.contentEncodings.add((Object)enc);
    }

    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        Buffer input = (Buffer)ctx.getMessage();
        Connection connection = ctx.getConnection();
        HttpRequestPacketImpl httpRequest = (HttpRequestPacketImpl)this.httpRequestInProcessAttr.get((AttributeStorage)connection);
        if (httpRequest == null) {
            boolean isSecureLocal = this.isSecure;
            httpRequest = HttpRequestPacketImpl.create();
            httpRequest.initialize(connection, input.position(), this.maxHeadersSize);
            httpRequest.setSecure(isSecureLocal);
            HttpResponsePacketImpl response = HttpResponsePacketImpl.create();
            response.setUpgrade(httpRequest.getUpgrade());
            response.setSecure(isSecureLocal);
            httpRequest.setResponse(response);
            response.setRequest(httpRequest);
            if (this.processKeepAlive) {
                KeepAliveContext keepAliveContext = (KeepAliveContext)this.keepAliveContextAttr.get((AttributeStorage)connection);
                if (keepAliveContext == null) {
                    keepAliveContext = new KeepAliveContext(connection);
                    this.keepAliveContextAttr.set((AttributeStorage)connection, (Object)keepAliveContext);
                }
                keepAliveContext.request = httpRequest;
                int requestsProcessed = keepAliveContext.requestsProcessed;
                if (requestsProcessed > 0) {
                    KeepAlive.notifyProbesHit(this.keepAlive, connection, requestsProcessed);
                }
                this.keepAliveQueue.remove((Object)keepAliveContext);
            }
            this.httpRequestInProcessAttr.set((AttributeStorage)connection, (Object)httpRequest);
        }
        return this.handleRead(ctx, httpRequest);
    }

    public NextAction handleEvent(FilterChainContext ctx, Object event) throws IOException {
        Connection c = ctx.getConnection();
        if (event == RESPONSE_COMPLETE_EVENT && c.isOpen()) {
            KeepAliveContext keepAliveContext = (KeepAliveContext)this.keepAliveContextAttr.get((AttributeStorage)c);
            this.keepAliveQueue.add((Object)keepAliveContext, (long)this.keepAlive.getIdleTimeoutInSeconds(), TimeUnit.SECONDS);
            HttpRequestPacket httpRequest = keepAliveContext.request;
            boolean isStayAlive = this.isKeepAlive(httpRequest, keepAliveContext);
            if (!isStayAlive) {
                ctx.flush((CompletionHandler)FLUSH_AND_CLOSE_HANDLER);
            } else if (httpRequest.isExpectContent()) {
                httpRequest.setSkipRemainder(true);
            }
            keepAliveContext.request = null;
            return ctx.getStopAction();
        }
        return ctx.getInvokeAction();
    }

    @Override
    boolean onHttpHeaderParsed(HttpHeader httpHeader, Buffer buffer, FilterChainContext ctx) {
        HttpRequestPacketImpl request = (HttpRequestPacketImpl)httpHeader;
        if (!request.getUpgradeDC().isNull()) {
            return false;
        }
        HttpServerFilter.prepareRequest(request, buffer.hasRemaining());
        return request.getProcessingState().error;
    }

    @Override
    final boolean onHttpPacketParsed(HttpHeader httpHeader, FilterChainContext ctx) {
        HttpRequestPacketImpl request = (HttpRequestPacketImpl)httpHeader;
        boolean error = request.getProcessingState().error;
        if (!error) {
            this.httpRequestInProcessAttr.remove((AttributeStorage)ctx.getConnection());
        }
        return error;
    }

    @Override
    void onHttpError(HttpHeader httpHeader, FilterChainContext ctx) throws IOException {
        HttpRequestPacketImpl request = (HttpRequestPacketImpl)httpHeader;
        HttpContent errorHttpResponse = this.customizeErrorResponse(request.getResponse());
        Buffer resBuf = this.encodeHttpPacket(ctx.getConnection(), errorHttpResponse);
        ctx.write((Object)resBuf);
    }

    @Override
    protected Buffer encodeHttpPacket(Connection connection, HttpPacket input) {
        HttpHeader header = input.isHeader() ? (HttpHeader)input : ((HttpContent)input).getHttpHeader();
        HttpResponsePacketImpl response = (HttpResponsePacketImpl)header;
        if (!response.isCommitted() && response.getUpgrade() == null) {
            this.prepareResponse(response.getRequest(), response);
        }
        Buffer encoded = super.encodeHttpPacket(connection, input);
        if (HttpContent.isContent(input)) {
            input.recycle();
        }
        return encoded;
    }

    @Override
    final boolean decodeInitialLine(HttpPacketParsing httpPacket, HttpCodecFilter.HeaderParsingState parsingState, Buffer input) {
        HttpRequestPacketImpl httpRequest = (HttpRequestPacketImpl)httpPacket;
        int reqLimit = parsingState.packetLimit;
        int subState = parsingState.subState++;
        switch (subState) {
            case 0: {
                int spaceIdx = HttpServerFilter.findSpace(input, parsingState.offset, reqLimit);
                if (spaceIdx == -1) {
                    parsingState.offset = input.limit();
                    return false;
                }
                httpRequest.getMethodDC().setBuffer(input, parsingState.start, spaceIdx);
                parsingState.start = -1;
                parsingState.offset = spaceIdx;
            }
            case 1: {
                int nonSpaceIdx = HttpServerFilter.skipSpaces(input, parsingState.offset, reqLimit);
                if (nonSpaceIdx == -1) {
                    parsingState.offset = input.limit();
                    return false;
                }
                parsingState.start = nonSpaceIdx;
                parsingState.offset = nonSpaceIdx + 1;
                ++parsingState.subState;
            }
            case 2: {
                if (!HttpServerFilter.parseRequestURI(httpRequest, parsingState, input)) {
                    return false;
                }
            }
            case 3: {
                int nonSpaceIdx = HttpServerFilter.skipSpaces(input, parsingState.offset, reqLimit);
                if (nonSpaceIdx == -1) {
                    parsingState.offset = input.limit();
                    return false;
                }
                parsingState.start = nonSpaceIdx;
                parsingState.offset = nonSpaceIdx;
                ++parsingState.subState;
            }
            case 4: {
                if (!HttpServerFilter.findEOL(parsingState, input)) {
                    parsingState.offset = input.limit();
                    return false;
                }
                if (parsingState.checkpoint > parsingState.start) {
                    httpRequest.getProtocolDC().setBuffer(input, parsingState.start, parsingState.checkpoint);
                } else {
                    httpRequest.getProtocolDC().setString("");
                }
                parsingState.subState = 0;
                parsingState.start = -1;
                parsingState.checkpoint = -1;
                return true;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    Buffer encodeInitialLine(HttpPacket httpPacket, Buffer output, MemoryManager memoryManager) {
        HttpResponsePacket httpResponse = (HttpResponsePacket)httpPacket;
        output = HttpServerFilter.put(memoryManager, output, httpResponse.getProtocol().getProtocolBytes());
        output = HttpServerFilter.put(memoryManager, output, (byte)32);
        output = HttpServerFilter.put(memoryManager, output, httpResponse.getStatusDC());
        output = HttpServerFilter.put(memoryManager, output, (byte)32);
        output = HttpServerFilter.put(memoryManager, output, httpResponse.getReasonPhraseDC());
        return output;
    }

    private static boolean parseRequestURI(HttpRequestPacketImpl httpRequest, HttpCodecFilter.HeaderParsingState state, Buffer input) {
        int offset;
        int limit = Math.min(input.limit(), state.packetLimit);
        boolean found = false;
        for (offset = state.offset; offset < limit; ++offset) {
            byte b = input.get(offset);
            if (b == 32 || b == 9) {
                found = true;
                break;
            }
            if (b == 13 || b == 10) {
                found = true;
                break;
            }
            if (b != 63 || state.checkpoint != -1) continue;
            state.checkpoint = offset;
        }
        if (found) {
            DataChunk requestURIBC = httpRequest.getRequestURIRef().getRequestURIBC();
            requestURIBC.setBuffer(input, state.start, offset);
            if (state.checkpoint != -1) {
                requestURIBC.getBufferChunk().setEnd(state.checkpoint);
                httpRequest.getQueryStringDC().setBuffer(input, state.checkpoint + 1, offset);
            }
            state.start = -1;
            state.checkpoint = -1;
            ++state.subState;
        }
        state.offset = offset;
        return found;
    }

    private void prepareResponse(HttpRequestPacket request, HttpResponsePacketImpl response) {
        Protocol protocol = request.getProtocol();
        response.setProtocol(protocol);
        if (response.parsedStatusInt == Integer.MIN_VALUE) {
            HttpStatus.OK_200.setValues(response);
        }
        ProcessingState state = response.getProcessingState();
        if (protocol == Protocol.HTTP_0_9) {
            return;
        }
        boolean entityBody = true;
        int statusCode = response.getStatus();
        if (statusCode == 204 || statusCode == 205 || statusCode == 304) {
            entityBody = false;
            response.setExpectContent(false);
            state.contentDelimitation = true;
        }
        boolean isHttp11 = protocol == Protocol.HTTP_1_1;
        MimeHeaders headers = response.getHeaders();
        long contentLength = response.getContentLength();
        if (contentLength != -1L) {
            state.contentDelimitation = true;
        } else if (this.chunkingEnabled && entityBody && isHttp11) {
            state.contentDelimitation = true;
            response.setChunked(true);
        }
        DataChunk methodBC = request.getMethodDC();
        if (methodBC.equals("HEAD")) {
            state.contentDelimitation = true;
        }
        if (!entityBody) {
            response.setContentLength(-1);
        } else {
            String contentLanguage = response.getContentLanguage();
            if (contentLanguage != null) {
                headers.setValue("Content-Language").setString(contentLanguage);
            }
        }
        if (!response.containsHeader("Date")) {
            String date = FastHttpDateFormat.getCurrentDate();
            response.addHeader("Date", date);
        }
        if (entityBody && !state.contentDelimitation) {
            state.keepAlive = false;
        } else if (entityBody && !isHttp11 && response.getContentLength() == -1L) {
            state.keepAlive = false;
        } else if (entityBody && !response.isChunked() && response.getContentLength() == -1L) {
            state.keepAlive = false;
        } else if (!this.checkKeepAliveRequestsCount(request.getConnection())) {
            state.keepAlive = false;
        }
        boolean bl = state.keepAlive = state.keepAlive && !HttpServerFilter.statusDropsConnection(response.getStatus());
        if (!state.keepAlive) {
            headers.setValue("Connection").setString("close");
        } else if (!isHttp11 && !state.error) {
            headers.setValue("Connection").setString("Keep-Alive");
        }
    }

    private static void prepareRequest(HttpRequestPacketImpl request, boolean hasReadyContent) {
        DataChunk hostBC;
        long contentLength;
        boolean isConnectionClose;
        Protocol protocol;
        ProcessingState state = request.getProcessingState();
        HttpResponsePacket response = request.getResponse();
        DataChunk methodBC = request.getMethodDC();
        if (methodBC.equals("GET")) {
            request.setExpectContent(false);
        }
        try {
            protocol = request.getProtocol();
        }
        catch (IllegalStateException e) {
            state.error = true;
            HttpStatus.HTTP_VERSION_NOT_SUPPORTED_505.setValues(response);
            protocol = Protocol.HTTP_1_1;
            request.setProtocol(protocol);
        }
        MimeHeaders headers = request.getHeaders();
        BufferChunk uriBC = request.getRequestURIRef().getRequestURIBC().getBufferChunk();
        if (uriBC.startsWithIgnoreCase("http", 0)) {
            int pos = uriBC.indexOf("://", 4);
            int uriBCStart = uriBC.getStart();
            if (pos != -1) {
                Buffer uriB = uriBC.getBuffer();
                int slashPos = uriBC.indexOf('/', pos + 3);
                if (slashPos == -1) {
                    slashPos = uriBC.getLength();
                    uriBC.setBufferChunk(uriB, uriBCStart + pos + 1, 1);
                } else {
                    uriBC.setBufferChunk(uriB, uriBCStart + slashPos, uriBC.getLength() - slashPos);
                }
                DataChunk hostDC = headers.setValue("host");
                hostDC.setBuffer(uriB, uriBCStart + pos + 3, slashPos - pos - 3);
            }
        }
        boolean isHttp11 = protocol == Protocol.HTTP_1_1;
        DataChunk connectionValueDC = headers.getValue("connection");
        boolean bl = isConnectionClose = connectionValueDC != null && connectionValueDC.getBufferChunk().findBytesAscii(Constants.CLOSE_BYTES) != -1;
        if (!isConnectionClose) {
            boolean bl2 = state.keepAlive = isHttp11 || connectionValueDC != null && connectionValueDC.getBufferChunk().findBytesAscii(Constants.KEEPALIVE_BYTES) != -1;
        }
        if ((contentLength = request.getContentLength()) >= 0L) {
            state.contentDelimitation = true;
        }
        if ((hostBC = headers.getValue("host")) != null) {
            HttpServerFilter.parseHost(hostBC.getBufferChunk(), request, response, state);
        } else if (isHttp11) {
            state.error = true;
            HttpStatus.BAD_REQUEST_400.setValues(response);
            return;
        }
        if (!state.contentDelimitation) {
            state.contentDelimitation = true;
        }
        if (request.requiresAcknowledgement()) {
            request.requiresAcknowledgement(isHttp11 && !hasReadyContent);
        }
    }

    protected HttpContent customizeErrorResponse(HttpResponsePacket response) {
        response.setContentLength(0);
        return ((HttpContent.Builder)HttpContent.builder(response).last(true)).build();
    }

    private static boolean statusDropsConnection(int status) {
        return status == 400 || status == 408 || status == 411 || status == 413 || status == 414 || status == 417 || status == 500 || status == 503 || status == 501 || status == 505;
    }

    private static void parseHost(BufferChunk valueBC, HttpRequestPacket request, HttpResponsePacket response, ProcessingState state) {
        if (valueBC == null || valueBC.isNull()) {
            Connection connection = request.getConnection();
            request.setServerPort(((InetSocketAddress)connection.getLocalAddress()).getPort());
            InetAddress localAddress = ((InetSocketAddress)connection.getLocalAddress()).getAddress();
            request.setLocalHost(localAddress.getHostName());
            request.serverName().setString(localAddress.getHostName());
            return;
        }
        int valueS = valueBC.getStart();
        int valueL = valueBC.getEnd() - valueS;
        int colonPos = -1;
        Buffer valueB = valueBC.getBuffer();
        boolean ipv6 = valueB.get(valueS) == 91;
        boolean bracketClosed = false;
        for (int i = 0; i < valueL; ++i) {
            char b = (char)valueB.get(i + valueS);
            if (b == ']') {
                bracketClosed = true;
                continue;
            }
            if (b != ':' || ipv6 && !bracketClosed) continue;
            colonPos = i;
            break;
        }
        if (colonPos < 0) {
            if (!request.isSecure()) {
                request.setServerPort(80);
            } else {
                request.setServerPort(443);
            }
        } else {
            request.serverName().setBuffer(valueB, valueS, colonPos + valueS);
            int port = 0;
            int mult = 1;
            for (int i = valueL - 1; i > colonPos; --i) {
                int charValue = HexUtils.DEC[valueB.get(i + valueS)];
                if (charValue == -1) {
                    state.error = true;
                    HttpStatus.BAD_REQUEST_400.setValues(response);
                    return;
                }
                port += charValue * mult;
                mult = 10 * mult;
            }
            request.setServerPort(port);
        }
    }

    private boolean isKeepAlive(HttpRequestPacket request, KeepAliveContext keepAliveContext) {
        boolean isKeepAlive;
        ProcessingState ps = request.getProcessingState();
        boolean bl = isKeepAlive = !ps.isError() && ps.isKeepAlive();
        if (isKeepAlive && keepAliveContext != null && keepAliveContext.requestsProcessed == 1) {
            if (isKeepAlive) {
                KeepAlive.notifyProbesConnectionAccepted(this.keepAlive, keepAliveContext.connection);
            } else {
                KeepAlive.notifyProbesRefused(this.keepAlive, keepAliveContext.connection);
            }
        }
        return isKeepAlive;
    }

    private boolean checkKeepAliveRequestsCount(Connection connection) {
        KeepAliveContext keepAliveContext;
        return !this.processKeepAlive || (keepAliveContext = (KeepAliveContext)this.keepAliveContextAttr.get((AttributeStorage)connection)) == null || ++keepAliveContext.requestsProcessed <= this.keepAlive.getMaxRequestsCount();
    }

    public boolean isAuthPassthroughEnabled() {
        return this.authPassthroughEnabled;
    }

    public void setAuthPassthroughEnabled(boolean enabled) {
        this.authPassthroughEnabled = enabled;
    }

    public boolean isTraceEnabled() {
        return this.traceEnabled;
    }

    public void setTraceEnabled(boolean enabled) {
        this.traceEnabled = enabled;
    }

    private static class KeepAliveResolver
    implements DelayedExecutor.Resolver<KeepAliveContext> {
        private KeepAliveResolver() {
        }

        public boolean removeTimeout(KeepAliveContext context) {
            if (context.keepAliveTimeoutMillis != -1L) {
                context.keepAliveTimeoutMillis = -1L;
                return true;
            }
            return false;
        }

        public Long getTimeoutMillis(KeepAliveContext element) {
            return element.keepAliveTimeoutMillis;
        }

        public void setTimeoutMillis(KeepAliveContext element, long timeoutMillis) {
            element.keepAliveTimeoutMillis = timeoutMillis;
        }
    }

    private static class KeepAliveWorker
    implements DelayedExecutor.Worker<KeepAliveContext> {
        private final KeepAlive keepAlive;

        public KeepAliveWorker(KeepAlive keepAlive) {
            this.keepAlive = keepAlive;
        }

        public void doWork(KeepAliveContext context) {
            try {
                KeepAlive.notifyProbesTimeout(this.keepAlive, context.connection);
                context.connection.close().markForRecycle(false);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static class KeepAliveContext {
        private final Connection connection;
        private volatile long keepAliveTimeoutMillis = -1L;
        private int requestsProcessed;
        private HttpRequestPacket request;

        public KeepAliveContext(Connection connection) {
            this.connection = connection;
        }
    }

    private static class FlushAndCloseHandler
    extends EmptyCompletionHandler {
        private FlushAndCloseHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void completed(Object result) {
            WriteResult wr = (WriteResult)result;
            try {
                wr.getConnection().close().markForRecycle(false);
            }
            catch (IOException iOException) {
            }
            finally {
                wr.recycle();
            }
        }
    }
}

