/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.jmx;

import java.util.concurrent.atomic.AtomicLong;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.GmbalMBean;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.http.ContentEncoding;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpProbe;
import org.glassfish.grizzly.http.TransferEncoding;
import org.glassfish.grizzly.monitoring.jmx.GrizzlyJmxManager;
import org.glassfish.grizzly.monitoring.jmx.JmxObject;

@ManagedObject
@Description(value="This Filter is responsible for the parsing incoming HTTP packets and serializing high level objects back into the HTTP protocol format.")
public class HttpCodecFilter
extends JmxObject {
    private final org.glassfish.grizzly.http.HttpCodecFilter httpCodecFilter;
    private final AtomicLong httpContentReceived = new AtomicLong();
    private final AtomicLong httpContentWritten = new AtomicLong();
    private final AtomicLong httpCodecErrorCount = new AtomicLong();
    private final HttpProbe probe = new JmxHttpProbe();

    public HttpCodecFilter(org.glassfish.grizzly.http.HttpCodecFilter httpCodecFilter) {
        this.httpCodecFilter = httpCodecFilter;
    }

    public String getJmxName() {
        return "HttpCodecFilter";
    }

    protected void onRegister(GrizzlyJmxManager mom, GmbalMBean bean) {
        this.httpCodecFilter.getMonitoringConfig().addProbes((Object[])new HttpProbe[]{this.probe});
    }

    protected void onUnregister(GrizzlyJmxManager mom) {
        this.httpCodecFilter.getMonitoringConfig().removeProbes((Object[])new HttpProbe[]{this.probe});
    }

    @ManagedAttribute(id="total-bytes-received")
    @Description(value="The total number of bytes this filter has processed as part of the HTTP protocol parsing process.")
    public long getTotalContentReceived() {
        return this.httpContentReceived.get();
    }

    @ManagedAttribute(id="total-bytes-written")
    @Description(value="The total number of bytes that have been written as part of the serialization process to the HTTP protocol.")
    public long getTotalContentWritten() {
        return this.httpContentWritten.get();
    }

    @ManagedAttribute(id="http-codec-error-count")
    @Description(value="The total number of protocol errors that have occurred during either the parsing or serialization process.")
    public long getHttpCodecErrorCount() {
        return this.httpCodecErrorCount.get();
    }

    private final class JmxHttpProbe
    implements HttpProbe {
        private JmxHttpProbe() {
        }

        @Override
        public void onDataReceivedEvent(Connection connection, Buffer buffer) {
            HttpCodecFilter.this.httpContentReceived.addAndGet(buffer.remaining());
        }

        @Override
        public void onDataSentEvent(Connection connection, Buffer buffer) {
            HttpCodecFilter.this.httpContentWritten.addAndGet(buffer.remaining());
        }

        @Override
        public void onErrorEvent(Connection connection, Throwable error) {
            HttpCodecFilter.this.httpCodecErrorCount.incrementAndGet();
        }

        @Override
        public void onHeaderParseEvent(Connection connection, HttpHeader header, int size) {
        }

        @Override
        public void onHeaderSerializeEvent(Connection connection, HttpHeader header, Buffer buffer) {
        }

        @Override
        public void onContentChunkParseEvent(Connection connection, HttpContent content) {
        }

        @Override
        public void onContentChunkSerializeEvent(Connection connection, HttpContent content) {
        }

        @Override
        public void onContentEncodingParseEvent(Connection connection, HttpHeader header, Buffer buffer, ContentEncoding contentEncoding) {
        }

        @Override
        public void onContentEncodingSerializeEvent(Connection connection, HttpHeader header, Buffer buffer, ContentEncoding contentEncoding) {
        }

        @Override
        public void onTransferEncodingParseEvent(Connection connection, HttpHeader header, Buffer buffer, TransferEncoding transferEncoding) {
        }

        @Override
        public void onTransferEncodingSerializeEvent(Connection connection, HttpHeader header, Buffer buffer, TransferEncoding transferEncoding) {
        }
    }
}

