/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.util;

import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.util.Charsets;
import org.glassfish.grizzly.memory.Buffers;

public enum HttpStatus {
    CONINTUE_100(100, "Continue"),
    SWITCHING_PROTOCOLS_101(101, "Switching Protocols"),
    WEB_SOCKET_PROTOCOL_HANDSHAKE_101(101, "Web Socket Protocol Handshake"),
    OK_200(200, "OK"),
    CREATED_201(201, "Created"),
    ACCEPTED_202(202, "Accepted"),
    NON_AUTHORATIVE_INFORMATION_203(203, "Not-Authoritative Information"),
    NO_CONTENT_204(204, "No Content"),
    RESET_CONTENT_205(205, "Reset Content"),
    PARTIAL_CONTENT_206(206, "Partial Content"),
    MULTIPLE_CHOICES_300(300, "Multiple Choices"),
    MOVED_PERMANENTLY_301(301, "Moved Permanently"),
    FOUND_302(302, "Found"),
    SEE_OTHER_303(303, "See Other"),
    NOT_MODIFIED_304(304, "Not Modified"),
    USE_PROXY_305(305, "Use Proxy"),
    TEMPORARY_REDIRECT_307(307, "Temporary Redirect"),
    BAD_REQUEST_400(400, "Bad Request"),
    UNAUTHORIZED_401(401, "Unauthorized"),
    PAYMENT_REQUIRED_402(402, "Payment Required"),
    FORBIDDEN_403(403, "Forbidden"),
    NOT_FOUND_404(404, "Not Found"),
    METHOD_NOT_ALLOWED_405(405, "Method Not Allowed"),
    NOT_ACCEPTABLE_406(406, "Not Acceptable"),
    PROXY_AUTHENTICATION_REQUIRED_407(407, "Proxy Authentication Required"),
    REQUEST_TIMEOUT_408(408, "Request Timeout"),
    CONFLICT_409(409, "Conflict"),
    GONE_410(410, "Gone"),
    LENGTH_REQUIRED_411(411, "Length Required"),
    PRECONDITION_FAILED_412(412, "Precondition Failed"),
    REQUEST_ENTITY_TOO_LARGE_413(413, "Request Entity Too Large"),
    REQUEST_URI_TOO_LONG_414(414, "Request-URI Too Long"),
    UNSUPPORTED_MEDIA_TYPE_415(415, "Unsupported Media Type"),
    REQUEST_RANGE_NOT_SATISFIABLE_416(416, "Request Range Not Satisfiable"),
    EXPECTATION_FAILED_417(417, "Expectation Failed"),
    INTERNAL_SERVER_ERROR_500(500, "Internal Server Error"),
    NOT_IMPLEMENTED_501(501, "Not Implemented"),
    BAD_GATEWAY_502(502, "Bad Gateway"),
    SERVICE_UNAVAILABLE_503(503, "Service Unavailable"),
    GATEWAY_TIMEOUT_504(504, "Gateway Timeout"),
    HTTP_VERSION_NOT_SUPPORTED_505(505, "HTTP Version Not Supported");

    private final int status;
    private final byte[] reasonPhraseBytes;
    private final byte[] statusBytes;

    private HttpStatus(int status, String reasonPhrase) {
        this.status = status;
        this.reasonPhraseBytes = reasonPhrase.getBytes(Charsets.ASCII_CHARSET);
        this.statusBytes = Integer.toString(status).getBytes(Charsets.ASCII_CHARSET);
    }

    public int getStatusCode() {
        return this.status;
    }

    public byte[] getStatusBytes() {
        return this.statusBytes;
    }

    public byte[] getReasonPhraseBytes() {
        return this.reasonPhraseBytes;
    }

    public void setValues(HttpResponsePacket response) {
        response.setStatus(this.status, Buffers.wrap(null, (byte[])this.statusBytes));
        response.setReasonPhrase(Buffers.wrap(null, (byte[])this.reasonPhraseBytes));
    }
}

