/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.http.util.DataChunk;
import org.glassfish.grizzly.http.util.MimeHeaderField;
import org.glassfish.grizzly.http.util.NamesIterator;
import org.glassfish.grizzly.http.util.ValuesIterator;

public class MimeHeaders {
    public static final int DEFAULT_HEADER_SIZE = 8;
    private MimeHeaderField[] headers = new MimeHeaderField[8];
    private int count;
    private final Iterable<String> namesIterable = new Iterable<String>(){

        @Override
        public Iterator<String> iterator() {
            return new NamesIterator(MimeHeaders.this);
        }
    };

    public void recycle() {
        this.clear();
    }

    public void clear() {
        for (int i = 0; i < this.count; ++i) {
            this.headers[i].recycle();
        }
        this.count = 0;
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("=== MimeHeaders ===");
        for (String name : this.names()) {
            pw.println(name + " = " + this.getHeader(name));
        }
        return sw.toString();
    }

    public int size() {
        return this.count;
    }

    public DataChunk getName(int n) {
        return n >= 0 && n < this.count ? this.headers[n].getName() : null;
    }

    public DataChunk getValue(int n) {
        return n >= 0 && n < this.count ? this.headers[n].getValue() : null;
    }

    public boolean getAndSetSerialized(int n, boolean newValue) {
        boolean value;
        if (n >= 0 && n < this.count) {
            MimeHeaderField field = this.headers[n];
            value = field.isSerialized();
            field.setSerialized(newValue);
        } else {
            value = true;
        }
        return value;
    }

    public int indexOf(String name, int fromIndex) {
        for (int i = fromIndex; i < this.count; ++i) {
            if (!this.headers[i].getName().equalsIgnoreCase(name)) continue;
            return i;
        }
        return -1;
    }

    public Iterable<String> names() {
        return this.namesIterable;
    }

    public Iterable<String> values(final String name) {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new ValuesIterator(MimeHeaders.this, name);
            }
        };
    }

    private MimeHeaderField createHeader() {
        MimeHeaderField mh;
        int len = this.headers.length;
        if (this.count >= len) {
            MimeHeaderField[] tmp = new MimeHeaderField[this.count * 2];
            System.arraycopy(this.headers, 0, tmp, 0, len);
            this.headers = tmp;
        }
        if ((mh = this.headers[this.count]) == null) {
            this.headers[this.count] = mh = new MimeHeaderField();
        }
        ++this.count;
        return mh;
    }

    public DataChunk addValue(String name) {
        MimeHeaderField mh = this.createHeader();
        mh.getName().setString(name);
        return mh.getValue();
    }

    public DataChunk addValue(Buffer buffer, int startN, int len) {
        MimeHeaderField mhf = this.createHeader();
        mhf.getName().setBuffer(buffer, startN, len);
        return mhf.getValue();
    }

    public DataChunk setValue(String name) {
        for (int i = 0; i < this.count; ++i) {
            if (!this.headers[i].getName().equalsIgnoreCase(name)) continue;
            for (int j = i + 1; j < this.count; ++j) {
                if (!this.headers[j].getName().equalsIgnoreCase(name)) continue;
                this.removeHeader(j--);
            }
            return this.headers[i].getValue();
        }
        MimeHeaderField mh = this.createHeader();
        mh.getName().setString(name);
        return mh.getValue();
    }

    public DataChunk getValue(String name) {
        for (int i = 0; i < this.count; ++i) {
            if (!this.headers[i].getName().equalsIgnoreCase(name)) continue;
            return this.headers[i].getValue();
        }
        return null;
    }

    public String getHeader(String name) {
        DataChunk mh = this.getValue(name);
        return mh != null ? mh.toString() : null;
    }

    public void removeHeader(String name) {
        for (int i = 0; i < this.count; ++i) {
            if (!this.headers[i].getName().equalsIgnoreCase(name)) continue;
            this.removeHeader(i--);
        }
    }

    public void removeHeader(String name, String str) {
        for (int i = 0; i < this.count; ++i) {
            if (!this.headers[i].getName().equalsIgnoreCase(name) || this.getValue(i) == null || this.getValue(i).toString() == null || this.getValue(i).toString().indexOf(str) == -1) continue;
            this.removeHeader(i--);
        }
    }

    void removeHeader(int idx) {
        MimeHeaderField mh = this.headers[idx];
        mh.recycle();
        this.headers[idx] = this.headers[this.count - 1];
        this.headers[this.count - 1] = mh;
        --this.count;
    }
}

