/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.util;

import java.util.Iterator;
import org.glassfish.grizzly.http.util.MimeHeaders;

class NamesIterator
implements Iterator<String> {
    int pos;
    int size;
    int currentPos;
    String next;
    MimeHeaders headers;

    NamesIterator(MimeHeaders headers) {
        this.headers = headers;
        this.pos = 0;
        this.size = headers.size();
        this.findNext();
    }

    private void findNext() {
        this.next = null;
        while (this.pos < this.size) {
            this.next = this.headers.getName(this.pos).toString();
            for (int j = 0; j < this.pos; ++j) {
                if (!this.headers.getName(j).equalsIgnoreCase(this.next)) continue;
                this.next = null;
                break;
            }
            if (this.next != null) break;
            ++this.pos;
        }
        ++this.pos;
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public String next() {
        this.currentPos = this.pos - 1;
        String current = this.next;
        this.findNext();
        return current;
    }

    @Override
    public void remove() {
        if (this.currentPos < 0) {
            throw new IllegalStateException("No current element");
        }
        this.headers.removeHeader(this.currentPos);
        this.pos = this.currentPos;
        this.currentPos = -1;
        this.findNext();
    }
}

