/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.util;

import java.io.CharConversionException;
import java.nio.charset.Charset;
import org.glassfish.grizzly.http.util.Charsets;
import org.glassfish.grizzly.http.util.DataChunk;
import org.glassfish.grizzly.http.util.HttpRequestURIDecoder;

public class RequestURIRef {
    private final DataChunk requestURIBC = DataChunk.newInstance();
    private boolean isDecoded;
    private Charset decodedURIEncoding;
    private boolean wasSlashAllowed = true;
    private Charset defaultURIEncoding = Charsets.UTF8_CHARSET;

    public final DataChunk getRequestURIBC() {
        return this.requestURIBC;
    }

    public final DataChunk getDecodedRequestURIBC() throws CharConversionException {
        return this.getDecodedRequestURIBC(this.wasSlashAllowed, this.defaultURIEncoding);
    }

    public DataChunk getDecodedRequestURIBC(boolean isSlashAllowed) throws CharConversionException {
        return this.getDecodedRequestURIBC(isSlashAllowed, this.defaultURIEncoding);
    }

    public DataChunk getDecodedRequestURIBC(boolean isSlashAllowed, Charset charset) throws CharConversionException {
        if (this.isDecoded) {
            if (isSlashAllowed != this.wasSlashAllowed) {
                throw new IllegalStateException("URI was already decoded with isSlashAllowed=" + this.wasSlashAllowed);
            }
            if (charset == this.decodedURIEncoding) {
                return this.requestURIBC;
            }
            HttpRequestURIDecoder.convertToChars(this.requestURIBC, charset);
        } else {
            HttpRequestURIDecoder.decode(this.requestURIBC, isSlashAllowed, charset);
            this.isDecoded = true;
            this.wasSlashAllowed = isSlashAllowed;
        }
        this.decodedURIEncoding = charset;
        return this.requestURIBC;
    }

    public String getURI() {
        return this.getURI(null);
    }

    public String getURI(Charset encoding) {
        return this.requestURIBC.toString(encoding);
    }

    public void setURI(String uri) {
        this.requestURIBC.setString(uri);
    }

    public final String getDecodedURI() throws CharConversionException {
        return this.getDecodedURI(this.wasSlashAllowed);
    }

    public final String getDecodedURI(boolean isSlashAllowed) throws CharConversionException {
        return this.getDecodedURI(isSlashAllowed, null);
    }

    public String getDecodedURI(boolean isSlashAllowed, Charset encoding) throws CharConversionException {
        this.getDecodedRequestURIBC(isSlashAllowed, encoding);
        String strValue = this.requestURIBC.toString();
        return strValue;
    }

    public void setDecodedURI(String uri) {
        this.requestURIBC.setString(uri);
        this.isDecoded = true;
    }

    public boolean isDecoded() {
        return this.isDecoded;
    }

    public void setDecoded(boolean isDecoded) {
        this.isDecoded = isDecoded;
    }

    public Charset getDefaultURIEncoding() {
        return this.defaultURIEncoding;
    }

    public void setDefaultURIEncoding(Charset defaultURIEncoding) {
        this.defaultURIEncoding = defaultURIEncoding;
    }

    public void recycle() {
        this.requestURIBC.recycle();
        this.isDecoded = false;
        this.wasSlashAllowed = true;
        this.decodedURIEncoding = null;
        this.defaultURIEncoding = Charsets.UTF8_CHARSET;
    }
}

