/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.util;

import java.util.HashMap;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.http.util.DataChunk;
import org.glassfish.grizzly.http.util.HttpStatus;
import org.glassfish.grizzly.memory.Buffers;

public class Utils {
    private static final HashMap<Integer, byte[]> statusMessages = new HashMap(HttpStatus.values().length);
    private static final HashMap<Integer, byte[]> statusCodes = new HashMap(HttpStatus.values().length);

    public static Buffer getHttpStatusMessage(int httpStatus) {
        return Buffers.wrap(null, (byte[])statusMessages.get(httpStatus));
    }

    public static Buffer getHttpStatus(int httpStatus) {
        return Buffers.wrap(null, (byte[])statusCodes.get(httpStatus));
    }

    public static void longToBuffer(long value, Buffer buffer) {
        boolean negative;
        if (value == 0L) {
            buffer.put(0, (byte)48);
            buffer.limit(1);
            return;
        }
        int radix = 10;
        if (value < 0L) {
            negative = true;
            value = -value;
        } else {
            negative = false;
        }
        int position = buffer.limit();
        do {
            int ch = 48 + (int)(value % 10L);
            buffer.put(--position, (byte)ch);
        } while ((value /= 10L) != 0L);
        if (negative) {
            buffer.put(--position, (byte)45);
        }
        buffer.position(position);
    }

    private static DataChunk newChunk(byte[] bytes) {
        DataChunk dc = DataChunk.newInstance();
        Buffer b = Buffers.wrap(null, (byte[])bytes);
        dc.setBuffer(b, 0, bytes.length);
        return dc;
    }

    static {
        for (HttpStatus status : HttpStatus.values()) {
            statusMessages.put(status.getStatusCode(), status.getReasonPhraseBytes());
            statusCodes.put(status.getStatusCode(), status.getStatusBytes());
        }
    }
}

