/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http;

import java.util.Locale;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacketImpl;
import org.glassfish.grizzly.http.util.DataChunk;
import org.glassfish.grizzly.http.util.HttpStatus;
import org.glassfish.grizzly.memory.Buffers;

public abstract class HttpResponsePacket
extends HttpHeader {
    private HttpRequestPacket request;
    private Locale locale;
    private String contentLanguage;
    protected HttpStatus httpStatus;
    private final DataChunk reasonPhraseC = DataChunk.newInstance();
    private boolean acknowledgment;
    private boolean allowCustomReasonPhrase = true;

    public static Builder builder(HttpRequestPacket request) {
        return new Builder(request);
    }

    protected HttpResponsePacket() {
    }

    public int getStatus() {
        return this.getHttpStatus().getStatusCode();
    }

    public HttpStatus getHttpStatus() {
        if (this.httpStatus == null) {
            this.httpStatus = HttpStatus.OK_200;
        }
        return this.httpStatus;
    }

    public void setStatus(int status) {
        this.httpStatus = HttpStatus.getHttpStatus(status);
    }

    public void setStatus(HttpStatus status) {
        this.httpStatus = status;
    }

    public final boolean isAllowCustomReasonPhrase() {
        return this.allowCustomReasonPhrase;
    }

    public final void setAllowCustomReasonPhrase(boolean allowCustomReasonPhrase) {
        this.allowCustomReasonPhrase = allowCustomReasonPhrase;
    }

    public final DataChunk getReasonPhraseRawDC() {
        return this.reasonPhraseC;
    }

    public final DataChunk getReasonPhraseDC() {
        if (this.allowCustomReasonPhrase && !this.reasonPhraseC.isNull()) {
            return HttpStatus.filter(this.reasonPhraseC);
        }
        Buffer b = Buffers.wrap(null, (byte[])this.httpStatus.getReasonPhraseBytes());
        this.reasonPhraseC.setBuffer(b, b.position(), b.limit());
        return this.reasonPhraseC;
    }

    public final String getReasonPhrase() {
        return this.getReasonPhraseDC().toString();
    }

    public void setReasonPhrase(String message) {
        this.reasonPhraseC.setString(message);
    }

    public void setReasonPhrase(Buffer reason) {
        this.reasonPhraseC.setBuffer(reason, reason.position(), reason.limit());
    }

    public HttpRequestPacket getRequest() {
        return this.request;
    }

    public boolean isAcknowledgement() {
        return this.acknowledgment;
    }

    public void setAcknowledgement(boolean acknowledgement) {
        this.acknowledgment = acknowledgement;
    }

    public void acknowledged() {
        this.request.requiresAcknowledgement(false);
        this.acknowledgment = false;
        this.httpStatus = null;
        this.reasonPhraseC.recycle();
    }

    @Override
    protected void reset() {
        this.httpStatus = null;
        this.acknowledgment = false;
        this.allowCustomReasonPhrase = true;
        this.reasonPhraseC.recycle();
        this.locale = null;
        this.contentLanguage = null;
        this.request = null;
        super.reset();
    }

    @Override
    public final boolean isRequest() {
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(256);
        sb.append("HttpResponsePacket (status=").append(this.getStatus()).append(" reason=").append(this.getReasonPhrase()).append(" protocol=").append((Object)this.getProtocol()).append(" content-length=").append(this.getContentLength()).append(" headers=").append(this.getHeaders()).append(" committed=").append(this.isCommitted()).append(')');
        return sb.toString();
    }

    @Override
    public void setHeader(String name, String value) {
        char c = name.charAt(0);
        if ((c == 'C' || c == 'c') && this.checkSpecialHeader(name, value)) {
            return;
        }
        super.setHeader(name, value);
    }

    @Override
    public void addHeader(String name, String value) {
        char c = name.charAt(0);
        if ((c == 'C' || c == 'c') && this.checkSpecialHeader(name, value)) {
            return;
        }
        super.addHeader(name, value);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        String country;
        if (locale == null) {
            return;
        }
        this.locale = locale;
        this.contentLanguage = locale.getLanguage();
        if (this.contentLanguage != null && this.contentLanguage.length() > 0 && (country = locale.getCountry()) != null && country.length() > 0) {
            StringBuilder value = new StringBuilder(this.contentLanguage);
            value.append('-');
            value.append(country);
            this.contentLanguage = value.toString();
        }
    }

    public String getContentLanguage() {
        return this.contentLanguage;
    }

    public void setContentLanguage(String contentLanguage) {
        this.contentLanguage = contentLanguage;
    }

    public void setRequest(HttpRequestPacket request) {
        this.request = request;
    }

    private boolean checkSpecialHeader(String name, String value) {
        if (name.equalsIgnoreCase("Content-Type")) {
            this.setContentType(value);
            return true;
        }
        if (name.equalsIgnoreCase("Content-Length")) {
            try {
                int cL = Integer.parseInt(value);
                this.setContentLength(cL);
                return true;
            }
            catch (NumberFormatException ex) {
                return false;
            }
        }
        if (name.equalsIgnoreCase("Content-Language")) {
            // empty if block
        }
        return false;
    }

    public static class Builder
    extends HttpHeader.Builder<Builder> {
        protected Builder(HttpRequestPacket request) {
            this.packet = request.getResponse();
            if (this.packet == null) {
                this.packet = HttpResponsePacketImpl.create();
                ((HttpResponsePacket)this.packet).setRequest(request);
                this.packet.setSecure(request.isSecure());
            }
        }

        public Builder status(int status) {
            ((HttpResponsePacket)this.packet).setStatus(status);
            return this;
        }

        public Builder reasonPhrase(String reasonPhrase) {
            ((HttpResponsePacket)this.packet).setReasonPhrase(reasonPhrase);
            return this;
        }

        public final HttpResponsePacket build() {
            return (HttpResponsePacket)this.packet;
        }
    }
}

