/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.util;

import java.io.CharConversionException;
import java.util.HashMap;
import java.util.Map;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.util.Charsets;
import org.glassfish.grizzly.http.util.DataChunk;
import org.glassfish.grizzly.memory.Buffers;

public class HttpStatus {
    private static final Map<Integer, HttpStatus> statusMessages = new HashMap<Integer, HttpStatus>();
    public static final HttpStatus CONINTUE_100 = HttpStatus.register(100, "Continue");
    public static final HttpStatus SWITCHING_PROTOCOLS_101 = HttpStatus.register(101, "Switching Protocols");
    public static final HttpStatus WEB_SOCKET_PROTOCOL_HANDSHAKE_101 = HttpStatus.register(101, "Web Socket Protocol Handshake");
    public static final HttpStatus OK_200 = HttpStatus.register(200, "OK");
    public static final HttpStatus CREATED_201 = HttpStatus.register(201, "Created");
    public static final HttpStatus ACCEPTED_202 = HttpStatus.register(202, "Accepted");
    public static final HttpStatus NON_AUTHORATIVE_INFORMATION_203 = HttpStatus.register(203, "Not-Authoritative Information");
    public static final HttpStatus NO_CONTENT_204 = HttpStatus.register(204, "No Content");
    public static final HttpStatus RESET_CONTENT_205 = HttpStatus.register(205, "Reset Content");
    public static final HttpStatus PARTIAL_CONTENT_206 = HttpStatus.register(206, "Partial Content");
    public static final HttpStatus MULTIPLE_CHOICES_300 = HttpStatus.register(300, "Multiple Choices");
    public static final HttpStatus MOVED_PERMANENTLY_301 = HttpStatus.register(301, "Moved Permanently");
    public static final HttpStatus FOUND_302 = HttpStatus.register(302, "Found");
    public static final HttpStatus SEE_OTHER_303 = HttpStatus.register(303, "See Other");
    public static final HttpStatus NOT_MODIFIED_304 = HttpStatus.register(304, "Not Modified");
    public static final HttpStatus USE_PROXY_305 = HttpStatus.register(305, "Use Proxy");
    public static final HttpStatus TEMPORARY_REDIRECT_307 = HttpStatus.register(307, "Temporary Redirect");
    public static final HttpStatus BAD_REQUEST_400 = HttpStatus.register(400, "Bad Request");
    public static final HttpStatus UNAUTHORIZED_401 = HttpStatus.register(401, "Unauthorized");
    public static final HttpStatus PAYMENT_REQUIRED_402 = HttpStatus.register(402, "Payment Required");
    public static final HttpStatus FORBIDDEN_403 = HttpStatus.register(403, "Forbidden");
    public static final HttpStatus NOT_FOUND_404 = HttpStatus.register(404, "Not Found");
    public static final HttpStatus METHOD_NOT_ALLOWED_405 = HttpStatus.register(405, "Method Not Allowed");
    public static final HttpStatus NOT_ACCEPTABLE_406 = HttpStatus.register(406, "Not Acceptable");
    public static final HttpStatus PROXY_AUTHENTICATION_REQUIRED_407 = HttpStatus.register(407, "Proxy Authentication Required");
    public static final HttpStatus REQUEST_TIMEOUT_408 = HttpStatus.register(408, "Request Timeout");
    public static final HttpStatus CONFLICT_409 = HttpStatus.register(409, "Conflict");
    public static final HttpStatus GONE_410 = HttpStatus.register(410, "Gone");
    public static final HttpStatus LENGTH_REQUIRED_411 = HttpStatus.register(411, "Length Required");
    public static final HttpStatus PRECONDITION_FAILED_412 = HttpStatus.register(412, "Precondition Failed");
    public static final HttpStatus REQUEST_ENTITY_TOO_LARGE_413 = HttpStatus.register(413, "Request Entity Too Large");
    public static final HttpStatus REQUEST_URI_TOO_LONG_414 = HttpStatus.register(414, "Request-URI Too Long");
    public static final HttpStatus UNSUPPORTED_MEDIA_TYPE_415 = HttpStatus.register(415, "Unsupported Media Type");
    public static final HttpStatus REQUEST_RANGE_NOT_SATISFIABLE_416 = HttpStatus.register(416, "Request Range Not Satisfiable");
    public static final HttpStatus EXPECTATION_FAILED_417 = HttpStatus.register(417, "Expectation Failed");
    public static final HttpStatus INTERNAL_SERVER_ERROR_500 = HttpStatus.register(500, "Internal Server Error");
    public static final HttpStatus NOT_IMPLEMENTED_501 = HttpStatus.register(501, "Not Implemented");
    public static final HttpStatus BAD_GATEWAY_502 = HttpStatus.register(502, "Bad Gateway");
    public static final HttpStatus SERVICE_UNAVAILABLE_503 = HttpStatus.register(503, "Service Unavailable");
    public static final HttpStatus GATEWAY_TIMEOUT_504 = HttpStatus.register(504, "Gateway Timeout");
    public static final HttpStatus HTTP_VERSION_NOT_SUPPORTED_505 = HttpStatus.register(505, "HTTP Version Not Supported");
    private final int status;
    private final byte[] reasonPhraseBytes;
    private final byte[] statusBytes;

    private static HttpStatus register(int statusCode, String reasonPhrase) {
        HttpStatus httpStatus = HttpStatus.newHttpStatus(statusCode, reasonPhrase);
        statusMessages.put(statusCode, httpStatus);
        return httpStatus;
    }

    public static HttpStatus newHttpStatus(int statusCode, String reasonPhrase) {
        return new HttpStatus(statusCode, reasonPhrase);
    }

    public static HttpStatus getHttpStatus(int statusCode) {
        HttpStatus status = statusMessages.get(statusCode);
        if (status == null) {
            status = new HttpStatus(statusCode, "CUSTOM");
        }
        return status;
    }

    private HttpStatus(int status, String reasonPhrase) {
        this.status = status;
        this.reasonPhraseBytes = reasonPhrase.getBytes(Charsets.ASCII_CHARSET);
        this.statusBytes = Integer.toString(status).getBytes(Charsets.ASCII_CHARSET);
    }

    public int getStatusCode() {
        return this.status;
    }

    public byte[] getStatusBytes() {
        return this.statusBytes;
    }

    public byte[] getReasonPhraseBytes() {
        return this.reasonPhraseBytes;
    }

    public void setValues(HttpResponsePacket response) {
        response.setStatus(this);
        response.setReasonPhrase(Buffers.wrap(null, (byte[])this.reasonPhraseBytes));
    }

    public static DataChunk filter(DataChunk message) {
        if (message == null || message.isNull()) {
            return null;
        }
        try {
            message.toChars(Charsets.ASCII_CHARSET);
        }
        catch (CharConversionException ignored) {
            // empty catch block
        }
        char[] content = message.getCharChunk().getChars();
        StringBuilder result = null;
        int len = content.length;
        block8: for (int i = 0; i < len; ++i) {
            switch (content[i]) {
                case '<': {
                    if (result == null) {
                        result = new StringBuilder(content.length + 50);
                        result.append(content, 0, i);
                    }
                    result.append("&lt;");
                    continue block8;
                }
                case '>': {
                    if (result == null) {
                        result = new StringBuilder(content.length + 50);
                        result.append(content, 0, i);
                    }
                    result.append("&gt;");
                    continue block8;
                }
                case '&': {
                    if (result == null) {
                        result = new StringBuilder(content.length + 50);
                        result.append(content, 0, i);
                    }
                    result.append("&amp;");
                    continue block8;
                }
                case '\"': {
                    if (result == null) {
                        result = new StringBuilder(content.length + 50);
                        result.append(content, 0, i);
                    }
                    result.append("&quot;");
                    continue block8;
                }
                default: {
                    char c = content[i];
                    if (c <= '\u001f' && c != '\t') {
                        if (result == null) {
                            result = new StringBuilder(content.length + 50);
                            result.append(content, 0, i);
                        }
                        c = ' ';
                    } else if (c == '\u007f') {
                        c = ' ';
                        if (result == null) {
                            result = new StringBuilder(content.length + 50);
                            result.append(content, 0, i);
                        }
                    }
                    byte b = (byte)c;
                    if (b == 10 || b == 13) {
                        c = ' ';
                        if (result == null) {
                            result = new StringBuilder(content.length + 50);
                            result.append(content, 0, i);
                        }
                    }
                    if (result == null) continue block8;
                    result.append(c);
                }
            }
        }
        if (result != null) {
            int len2 = result.length();
            char[] finalResult = new char[len2];
            result.getChars(0, len2, finalResult, 0);
            message.setChars(finalResult, 0, finalResult.length);
        }
        return message;
    }

    public static String filter(String message) {
        if (message == null) {
            return null;
        }
        char[] content = new char[message.length()];
        message.getChars(0, message.length(), content, 0);
        StringBuilder result = new StringBuilder(content.length + 50);
        block6: for (int i = 0; i < content.length; ++i) {
            switch (content[i]) {
                case '<': {
                    result.append("&lt;");
                    continue block6;
                }
                case '>': {
                    result.append("&gt;");
                    continue block6;
                }
                case '&': {
                    result.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    result.append("&quot;");
                    continue block6;
                }
                default: {
                    result.append(content[i]);
                }
            }
        }
        return result.toString();
    }
}

