/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http;

import java.io.IOException;
import java.util.Queue;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.http.GZipContentEncoding;
import org.glassfish.grizzly.http.HttpCodecFilter;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpPacket;
import org.glassfish.grizzly.http.HttpPacketParsing;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpRequestPacketImpl;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.HttpResponsePacketImpl;
import org.glassfish.grizzly.http.LZMAContentEncoding;
import org.glassfish.grizzly.http.util.Ascii;
import org.glassfish.grizzly.http.util.HttpCodecUtils;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.utils.DataStructures;

public class HttpClientFilter
extends HttpCodecFilter {
    private final Attribute<Queue<HttpRequestPacketImpl>> httpRequestQueueAttr;
    private final Attribute<HttpResponsePacketImpl> httpResponseInProcessAttr = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute("HttpClientFilter.httpResponse");

    public HttpClientFilter() {
        this(8192);
    }

    public HttpClientFilter(int maxHeadersSize) {
        super(true, maxHeadersSize);
        this.httpRequestQueueAttr = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute("HttpClientFilter.httpRequest");
        this.contentEncodings.add((Object)new GZipContentEncoding());
        this.contentEncodings.add((Object)new LZMAContentEncoding());
    }

    @Override
    public NextAction handleWrite(FilterChainContext ctx) throws IOException {
        HttpHeader header;
        Connection c = ctx.getConnection();
        Queue<HttpRequestPacketImpl> requestQueue = this.getRequestQueue(c);
        Object message = ctx.getMessage();
        if ((requestQueue.isEmpty() || !requestQueue.contains(message)) && HttpHeader.isHttp(message) && (header = message instanceof HttpHeader ? (HttpHeader)message : ((HttpContent)message).getHttpHeader()).isRequest()) {
            requestQueue.offer((HttpRequestPacketImpl)header);
        }
        return super.handleWrite(ctx);
    }

    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        Buffer input = (Buffer)ctx.getMessage();
        Connection connection = ctx.getConnection();
        HttpResponsePacketImpl httpResponse = (HttpResponsePacketImpl)this.httpResponseInProcessAttr.get((AttributeStorage)connection);
        if (httpResponse == null) {
            httpResponse = HttpResponsePacketImpl.create();
            Queue<HttpRequestPacketImpl> requestQueue = this.getRequestQueue(connection);
            httpResponse.setRequest(requestQueue.poll());
            httpResponse.initialize(this, input.position(), this.maxHeadersSize);
            httpResponse.setSecure(HttpClientFilter.isSecure(connection));
            this.httpResponseInProcessAttr.set((AttributeStorage)connection, (Object)httpResponse);
        }
        return this.handleRead(ctx, httpResponse);
    }

    @Override
    protected boolean onHttpPacketParsed(HttpHeader httpHeader, FilterChainContext ctx) {
        Connection connection = ctx.getConnection();
        this.clearResponse(connection);
        return false;
    }

    @Override
    protected boolean onHttpHeaderParsed(HttpHeader httpHeader, Buffer buffer, FilterChainContext ctx) {
        HttpResponsePacketImpl response = (HttpResponsePacketImpl)httpHeader;
        HttpRequestPacket request = response.getRequest();
        int statusCode = response.getStatus();
        if (statusCode == 204 || statusCode == 205 || statusCode == 304 || request != null && request.isHeadRequest()) {
            response.setExpectContent(false);
        }
        return false;
    }

    @Override
    protected void onHttpHeaderError(HttpHeader httpHeader, FilterChainContext ctx, Throwable t) throws IOException {
        throw new IllegalStateException(t);
    }

    @Override
    protected void onHttpContentError(HttpHeader httpHeader, FilterChainContext ctx, Throwable t) throws IOException {
        httpHeader.setContentBroken(true);
        throw new IllegalStateException(t);
    }

    @Override
    protected void onInitialLineParsed(HttpHeader httpHeader, FilterChainContext ctx) {
    }

    @Override
    protected void onInitialLineEncoded(HttpHeader header, FilterChainContext ctx) {
    }

    @Override
    protected void onHttpHeadersParsed(HttpHeader httpHeader, FilterChainContext ctx) {
    }

    @Override
    protected void onHttpHeadersEncoded(HttpHeader httpHeader, FilterChainContext ctx) {
    }

    @Override
    protected void onHttpContentParsed(HttpContent content, FilterChainContext ctx) {
    }

    @Override
    protected void onHttpContentEncoded(HttpContent content, FilterChainContext ctx) {
    }

    protected final void clearResponse(Connection connection) {
        this.httpResponseInProcessAttr.remove((AttributeStorage)connection);
    }

    @Override
    final boolean decodeInitialLine(FilterChainContext ctx, HttpPacketParsing httpPacket, HttpCodecFilter.HeaderParsingState parsingState, Buffer input) {
        HttpResponsePacket httpResponse = (HttpResponsePacket)((Object)httpPacket);
        int packetLimit = parsingState.packetLimit;
        int subState = parsingState.subState++;
        switch (subState) {
            case 0: {
                int spaceIdx = HttpClientFilter.findSpace(input, parsingState.offset, packetLimit);
                if (spaceIdx == -1) {
                    parsingState.offset = input.limit();
                    return false;
                }
                httpResponse.getProtocolDC().setBuffer(input, parsingState.start, spaceIdx);
                parsingState.start = -1;
                parsingState.offset = spaceIdx;
            }
            case 1: {
                int nonSpaceIdx = HttpClientFilter.skipSpaces(input, parsingState.offset, packetLimit);
                if (nonSpaceIdx == -1) {
                    parsingState.offset = input.limit();
                    return false;
                }
                parsingState.start = nonSpaceIdx;
                parsingState.offset = nonSpaceIdx + 1;
                ++parsingState.subState;
            }
            case 2: {
                int spaceIdx = HttpClientFilter.findSpace(input, parsingState.offset, packetLimit);
                if (spaceIdx == -1) {
                    parsingState.offset = input.limit();
                    return false;
                }
                httpResponse.setStatus(Ascii.parseInt(input, parsingState.start, spaceIdx - parsingState.start));
                parsingState.start = -1;
                parsingState.offset = spaceIdx;
                ++parsingState.subState;
            }
            case 3: {
                int nonSpaceIdx = HttpClientFilter.skipSpaces(input, parsingState.offset, packetLimit);
                if (nonSpaceIdx == -1) {
                    parsingState.offset = input.limit();
                    return false;
                }
                parsingState.start = nonSpaceIdx;
                parsingState.offset = nonSpaceIdx;
                ++parsingState.subState;
            }
            case 4: {
                if (!HttpClientFilter.findEOL(parsingState, input)) {
                    parsingState.offset = input.limit();
                    return false;
                }
                httpResponse.getReasonPhraseRawDC().setBuffer(input, parsingState.start, parsingState.checkpoint);
                parsingState.subState = 0;
                parsingState.start = -1;
                parsingState.checkpoint = -1;
                this.onInitialLineParsed(httpResponse, ctx);
                if (httpResponse.getStatus() == 100) {
                    parsingState.offset += 2;
                    parsingState.start = 0;
                    input.position(parsingState.offset);
                    input.shrink();
                    parsingState.offset = 0;
                    return false;
                }
                return true;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    Buffer encodeInitialLine(HttpPacket httpPacket, Buffer output, MemoryManager memoryManager) {
        HttpRequestPacket httpRequest = (HttpRequestPacket)httpPacket;
        output = HttpCodecUtils.put(memoryManager, output, httpRequest.getMethodDC());
        output = HttpCodecUtils.put(memoryManager, output, (byte)32);
        output = HttpCodecUtils.put(memoryManager, output, httpRequest.getRequestURIRef().getRequestURIBC());
        if (!httpRequest.getQueryStringDC().isNull()) {
            output = HttpCodecUtils.put(memoryManager, output, (byte)63);
            output = HttpCodecUtils.put(memoryManager, output, httpRequest.getQueryStringDC());
        }
        output = HttpCodecUtils.put(memoryManager, output, (byte)32);
        output = HttpCodecUtils.put(memoryManager, output, httpRequest.getProtocolString());
        return output;
    }

    private Queue<HttpRequestPacketImpl> getRequestQueue(Connection c) {
        Queue q = (Queue)this.httpRequestQueueAttr.get((AttributeStorage)c);
        if (q == null) {
            q = DataStructures.getLTQInstance(HttpRequestPacketImpl.class);
            this.httpRequestQueueAttr.set((AttributeStorage)c, (Object)q);
        }
        return q;
    }
}

